/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.mobility;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.mobility.MobilityProgramType$callable$create;
import org.fenixedu.academic.domain.student.mobility.MobilityProgramType$callable$delete;
import org.fenixedu.academic.domain.student.mobility.MobilityProgramType$callable$edit;
import org.fenixedu.academic.domain.student.mobility.MobilityProgramType_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MobilityProgramType
extends MobilityProgramType_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected MobilityProgramType() {
        this.setBennu(Bennu.getInstance());
    }

    protected MobilityProgramType(String code, LocalizedString name, boolean active) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setActive(active);
    }

    public void setCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            throw new AcademicExtensionsDomainException("error.MobilityProgramType.code.required", new String[0]);
        }
        MobilityProgramType foundByCode = MobilityProgramType.findByCode(code);
        if (foundByCode != null && foundByCode != this) {
            throw new AcademicExtensionsDomainException("error.MobilityProgramType.code.duplicated", new String[0]);
        }
        super.setCode(code);
    }

    public void setName(LocalizedString name) {
        if (name == null || Strings.isNullOrEmpty((String)name.getContent())) {
            throw new AcademicExtensionsDomainException("error.MobilityProgramType.name.required", new String[0]);
        }
        super.setName(name);
    }

    public boolean isActive() {
        return this.getActive();
    }

    public void edit(String string, LocalizedString localizedString, boolean bl) {
        Object object = advice$edit.perform((Callable)new MobilityProgramType$callable$edit(this, string, localizedString, bl));
    }

    static /* synthetic */ void advised$edit(MobilityProgramType this_, String code, LocalizedString name, boolean active) {
        this_.setCode(code);
        this_.setName(name);
        this_.setActive(active);
    }

    public static final MobilityProgramType create(String string, LocalizedString localizedString, boolean bl) {
        return (MobilityProgramType)((Object)advice$create.perform((Callable)new MobilityProgramType$callable$create(string, localizedString, bl)));
    }

    static final /* synthetic */ MobilityProgramType advised$create(String code, LocalizedString name, boolean active) {
        return new MobilityProgramType(code, name, active);
    }

    public static Set<MobilityProgramType> findAll() {
        return Bennu.getInstance().getMobilityProgramTypesSet();
    }

    public static Set<MobilityProgramType> findAllActive() {
        return Sets.filter(MobilityProgramType.findAll(), (Predicate)new Predicate<MobilityProgramType>(){

            public boolean apply(MobilityProgramType arg) {
                return arg.isActive();
            }
        });
    }

    public static final MobilityProgramType findByCode(String code) {
        MobilityProgramType result = null;
        Set<MobilityProgramType> readAll = MobilityProgramType.findAll();
        for (MobilityProgramType MobilityProgramType2 : readAll) {
            if (code.equals(MobilityProgramType2.getCode()) && result != null) {
                throw new AcademicExtensionsDomainException("error.MobilityProgramType.code.duplicated", new String[0]);
            }
            if (!code.equals(MobilityProgramType2.getCode())) continue;
            result = MobilityProgramType2;
        }
        return result;
    }

    public boolean isDeletable() {
        return this.getMobilityRegistrationInformationsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MobilityProgramType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MobilityProgramType this_) {
        if (!this_.isDeletable()) {
            throw new AcademicExtensionsDomainException("error.MobilityProgramType.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.deleteDomainObject();
    }
}

