/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.ResearchArea_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;

public class ResearchArea
extends ResearchArea_Base {
    public static final Comparator<ResearchArea> COMPARATOR_BY_CODE = new Comparator<ResearchArea>(){

        @Override
        public int compare(ResearchArea o1, ResearchArea o2) {
            int c = Comparator.naturalOrder().compare(o1.getCode(), o2.getCode());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    protected ResearchArea() {
        this.setBennu(Bennu.getInstance());
    }

    protected ResearchArea(String code, LocalizedString name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (ResearchArea.findAll().stream().anyMatch(r -> r != this && Objects.equals(r.getCode(), this.getCode()))) {
            throw new AcademicExtensionsDomainException("error.ResearchArea.already.exists.with.same.code", new String[0]);
        }
    }

    public static final ResearchArea create(String code, LocalizedString name) {
        return new ResearchArea(code, name);
    }

    public static ResearchArea findByCode(String code) {
        return ResearchArea.findAll().stream().filter(fos -> code.equalsIgnoreCase(fos.getCode())).findFirst().orElse(null);
    }

    public static Collection<ResearchArea> findAll() {
        return Bennu.getInstance().getResearchAreasSet();
    }
}

