/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.function.Supplier;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResultMessage;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegime;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class RegistrationRegimeVerifierInitializer {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationRegimeVerifierInitializer.class);
    private static Supplier<RegistrationRegime.RegistrationRegimeVerifier> REGISTRATION_REGIME_VERIFIER = () -> new RegistrationRegime.RegistrationRegimeVerifier(){

        public void checkEctsCredits(Registration registration, ExecutionYear executionYear, RegistrationRegimeType type) {
            block4: {
                if (type == RegistrationRegimeType.PARTIAL_TIME) {
                    StudentCurricularPlan plan = registration.getStudentCurricularPlan(executionYear);
                    if (plan == null) {
                        plan = registration.getLastStudentCurricularPlan();
                    }
                    try {
                        plan.enrol(executionYear.getFirstExecutionPeriod(), CurricularRuleLevel.ENROLMENT_VERIFICATION_WITH_RULES);
                    }
                    catch (EnrollmentDomainException e) {
                        RuleResultMessage resultMessage;
                        RuleResult ruleResult = e.getFalseResult();
                        RuleResultMessage ruleResultMessage = resultMessage = ruleResult == null ? null : (RuleResultMessage)ruleResult.getMessages().iterator().next();
                        if (resultMessage == null) break block4;
                        throw new DomainException(resultMessage.getMessage(), resultMessage.getArgs());
                    }
                }
            }
        }
    };

    public static void init() {
        RegistrationRegime.setRegistrationRegimeVerifier(REGISTRATION_REGIME_VERIFIER);
    }

    private static String convertToString(RuleResult ruleResult) {
        StringBuilder builder = new StringBuilder();
        for (RuleResultMessage message : ruleResult.getMessages()) {
            if (message.isToTranslate()) {
                builder.append(RegistrationRegimeVerifierInitializer.translateRuleMessage(message));
            } else {
                builder.append(message.getMessage());
            }
            builder.append("\n");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static String translateRuleMessage(RuleResultMessage message) {
        return MessageFormat.format(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)I18N.getLocale(), (String)message.getMessage(), (String[])new String[0]).replace("{0}", "'{0}'"), message.getArgs());
    }
}

