/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationObservations_Base;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.FenixFramework;

public class RegistrationObservations
extends RegistrationObservations_Base {
    private static final String APPEND = "(...)";
    private static final int LIMIT_NUMBER_OF_LINES = 6;
    private static final int LIMIT_NUMBER_OF_CHARS = 200;
    static Comparator<Object> compareByModifiedDate = (x, y) -> {
        DateTime xUpdateDate = FenixEDUTreasuryPlatformDependentServices.readVersioningUpdateDate((Object)x);
        DateTime yUpdateDate = FenixEDUTreasuryPlatformDependentServices.readVersioningUpdateDate((Object)y);
        if (xUpdateDate == null || yUpdateDate == null) {
            return 0;
        }
        return xUpdateDate.compareTo((ReadableInstant)yUpdateDate);
    };

    public RegistrationObservations(Registration registration) {
        this.setRegistration(registration);
    }

    public Registration getRegistration() {
        return super.getRegistration();
    }

    public static void setupDeleteListener() {
        FenixFramework.getDomainModel().registerDeletionListener(Registration.class, registration -> {
            for (RegistrationObservations observations : registration.getRegistrationObservationsSet()) {
                observations.delete();
            }
        });
    }

    public void delete() {
        this.setRegistration(null);
        this.deleteDomainObject();
    }

    public String getAsHtml() {
        return this.getValue() != null ? StringEscapeUtils.escapeHtml((String)this.getValue()).replaceAll("\r\n", "<br>") : null;
    }

    public String getAsLimitedHtml() {
        int nthIndexOfLineBreak;
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value.length() > 200) {
            value = value.substring(0, 200) + APPEND;
        }
        if ((nthIndexOfLineBreak = RegistrationObservations.nthIndexOf(value, '\n', 6)) > -1) {
            value = value.substring(0, nthIndexOfLineBreak) + "\r\n" + APPEND;
        }
        return value.replaceAll("\r\n", "<br>");
    }

    public static List<RegistrationObservations> getLastThreeSortedObservations(Registration registration) {
        return registration.getRegistrationObservationsSet().stream().sorted(compareByModifiedDate.reversed()).limit(3L).collect(Collectors.toList());
    }

    public static List<RegistrationObservations> getReverseSortedObservations(Registration registration) {
        return registration.getRegistrationObservationsSet().stream().sorted(compareByModifiedDate.reversed()).collect(Collectors.toList());
    }

    public static int nthIndexOf(String s, char c, int n) {
        int i = -1;
        while (n-- > 0) {
            if ((i = s.indexOf(c, i + 1)) != -1) continue;
            return -1;
        }
        return i;
    }
}

