/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYearExtendedInformation;
import org.fenixedu.academic.domain.student.RegistrationObservations;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.CurriculumConfigurationInitializer;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class RegistrationDataServices {
    public static void delete(RegistrationDataByExecutionYear input) {
        if (input.getRegistration().hasAnyEnrolmentsIn(input.getExecutionYear())) {
            throw new DomainException("error.RegistrationDataByExecutionYear.checkDeletion.hasAnyEnrolments", new String[]{input.getExecutionYear().getQualifiedName()});
        }
        input.delete();
    }

    public static void setCurricularYear(RegistrationDataByExecutionYear data, Integer update) {
        RegistrationDataByExecutionYearExtendedInformation info = RegistrationDataByExecutionYearExtendedInformation.findOrCreate(data);
        Integer overriden = info.getCurricularYear();
        if (overriden == null && update != null || overriden != null && !overriden.equals(update)) {
            Registration registration = data.getRegistration();
            CurriculumConfigurationInitializer.CurricularYearResult current = RegistrationServices.getCurricularYear(registration, data.getExecutionYear());
            RegistrationObservations observation = new RegistrationObservations(registration);
            String value = update == null ? AcademicExtensionsUtil.bundle("label.curricularYear.overriden.observation.removed", new String[0]) : AcademicExtensionsUtil.bundle("label.curricularYear.overriden.observation.updated", update.toString(), String.valueOf(current.getResult()), current.getJustificationPresentation());
            value = value + " " + AcademicExtensionsUtil.bundle("label.curricularYear.overriden.observation.suffix", String.valueOf(current.getResult()), current.getJustificationPresentation());
            observation.setValue(value);
            info.setCurricularYear(update);
            RegistrationServices.invalidateCacheCurricularYear(registration, data.getExecutionYear());
        }
    }

    private static Integer getCurricularYear(RegistrationDataByExecutionYear data) {
        return data == null || data.getExtendedInformation() == null ? null : data.getExtendedInformation().getCurricularYear();
    }

    public static Integer getOverridenCurricularYear(Registration registration, ExecutionYear executionYear) {
        RegistrationDataByExecutionYear data = executionYear != null ? RegistrationDataServices.getRegistrationData(registration, executionYear) : null;
        Integer curricularYear = RegistrationDataServices.getCurricularYear(data);
        if (curricularYear != null) {
            return curricularYear;
        }
        return null;
    }

    public static RegistrationDataByExecutionYear getRegistrationData(Registration registration, ExecutionYear year) {
        for (RegistrationDataByExecutionYear iter : registration.getRegistrationDataByExecutionYearSet()) {
            if (iter.getExecutionYear() != year) continue;
            return iter;
        }
        return null;
    }

    public static RegistrationDataByExecutionYear getFirstRegistrationData(Registration registration) {
        return registration == null ? null : (RegistrationDataByExecutionYear)registration.getRegistrationDataByExecutionYearSet().stream().min((i, j) -> i.getExecutionYear().compareTo(j.getExecutionYear())).orElse(null);
    }

    public static RegistrationDataByExecutionYear getLastRegistrationData(Registration registration) {
        return registration == null ? null : (RegistrationDataByExecutionYear)registration.getRegistrationDataByExecutionYearSet().stream().max((i, j) -> i.getExecutionYear().compareTo(j.getExecutionYear())).orElse(null);
    }
}

