/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.person.qualifications;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.fenixedu.academic.domain.person.qualifications.QualificationLevel_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class QualificationLevel
extends QualificationLevel_Base
implements Comparable<QualificationLevel> {
    public QualificationLevel() {
        this.setRoot(Bennu.getInstance());
    }

    public void setName(LocalizedString name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("error.QualificationLevel.name.cannotBeEmpty");
        }
        super.setName(name);
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getQualificationsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.QualificationLevel.delete.qualificationsNotEmpty", (String[])new String[0]));
        }
    }

    public void delete() {
        super.setRoot(null);
        this.getTypesSet().clear();
        super.deleteDomainObject();
    }

    @Override
    public int compareTo(QualificationLevel otherLevel) {
        Comparator nullSafeStringComparator = Comparator.nullsLast(String::compareToIgnoreCase);
        Comparator<QualificationLevel> levelComparator = Comparator.comparing(QualificationLevel_Base::getCode, nullSafeStringComparator).thenComparing(QualificationLevel_Base::getName).thenComparing(AbstractDomainObject::getExternalId);
        return levelComparator.compare(this, otherLevel);
    }

    public static Optional<QualificationLevel> findByCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return Optional.empty();
        }
        return Bennu.getInstance().getQualificationLevelsSet().stream().filter(c -> code.equals(c.getCode())).findAny();
    }
}

