/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.services;

import java.util.Collection;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;

public class EnrolmentServices {
    public static void updateState(Enrolment enrolment) {
        if (!enrolment.isAnnulled()) {
            enrolment.setEnrollmentState(EnrolmentServices.calculateState(enrolment));
        }
    }

    public static EnrollmentState calculateState(Enrolment enrolment) {
        Grade finalGrade = enrolment.getGrade();
        return finalGrade.isEmpty() ? EnrollmentState.ENROLLED : finalGrade.getEnrolmentState();
    }

    public static Collection<Shift> getShiftsFor(Enrolment enrolment, ExecutionInterval executionInterval) {
        return enrolment.getRegistration().getShiftsFor(enrolment.getExecutionCourseFor(executionInterval));
    }

    public static String getShiftsDescription(Enrolment enrolment, ExecutionInterval executionInterval) {
        return EnrolmentServices.getShiftsFor(enrolment, executionInterval).stream().map(s -> s.getNome()).collect(Collectors.joining(", "));
    }

    public static boolean containsAnyShift(Enrolment enrolment, ExecutionInterval executionInterval, Collection<Shift> shifts) {
        return EnrolmentServices.getShiftsFor(enrolment, executionInterval).stream().anyMatch(s -> shifts.contains(s));
    }
}

