/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import com.google.common.collect.Lists;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.StudentStatuteCurricularRule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.StudentStatuteCurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.StudentStatuteCurricularRuleVerifier;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class StudentStatuteCurricularRule
extends StudentStatuteCurricularRule_Base {
    protected StudentStatuteCurricularRule() {
    }

    public StudentStatuteCurricularRule(DegreeModule toApplyRule, CourseGroup contextCourseGroup, ExecutionInterval begin, ExecutionInterval end, StatuteType statuteType, CurricularPeriod curricularPeriod) {
        this();
        this.init(toApplyRule, contextCourseGroup, begin, end, CurricularRuleType.CUSTOM);
        this.edit(contextCourseGroup, statuteType, curricularPeriod);
    }

    public void edit(CourseGroup contextCourseGroup, StatuteType statuteType, CurricularPeriod curricularPeriod) {
        this.setContextCourseGroup(contextCourseGroup);
        super.setStatuteType(statuteType);
        super.setCurricularPeriod(curricularPeriod);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getStatuteType() == null) {
            throw new DomainException("error.StudentStatuteCurricularRule.statuteType.cannot.be.null", new String[0]);
        }
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return new StudentStatuteCurricularRuleExecutor().execute((ICurricularRule)this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return new StudentStatuteCurricularRuleVerifier();
    }

    protected void removeOwnParameters() {
        super.setStatuteType(null);
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        StringBuilder label = new StringBuilder();
        label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentStatuteCurricularRule", (String[])new String[0])).append(": ").append(this.getStatuteType().getCode() + " - " + this.getStatuteType().getName().getContent());
        if (this.getContextCourseGroup() != null) {
            label.append(", ");
            label.append(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"label.inGroup", (String[])new String[0]));
            label.append(" ");
            label.append(this.getContextCourseGroup().getOneFullName());
        }
        return Lists.newArrayList((Object[])new GenericPair[]{new GenericPair((Object)label, (Object)false)});
    }

    public boolean isVisible() {
        return false;
    }
}

