/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.StudentSchoolClassCurricularRule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.StudentSchoolClassCurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class StudentSchoolClassCurricularRule
extends StudentSchoolClassCurricularRule_Base {
    protected StudentSchoolClassCurricularRule() {
    }

    public StudentSchoolClassCurricularRule(DegreeModule toApplyRule, CourseGroup contextCourseGroup, ExecutionInterval begin, ExecutionInterval end, Boolean schoolClassMustContainCourse, Boolean courseMustHaveFreeShifts, Boolean enrolInShiftIfUnique, Boolean allAvailableShiftsMustBeEnrolled, String schoolClassNames) {
        this();
        this.init(toApplyRule, contextCourseGroup, begin, end, CurricularRuleType.CUSTOM);
        this.setSchoolClassMustContainCourse(schoolClassMustContainCourse);
        this.setCourseMustHaveFreeShifts(courseMustHaveFreeShifts);
        this.setEnrolInShiftIfUnique(enrolInShiftIfUnique);
        this.setAllAvailableShiftsMustBeEnrolled(allAvailableShiftsMustBeEnrolled);
        this.setSchoolClassNames(schoolClassNames);
    }

    public void edit(CourseGroup contextCourseGroup, Boolean schoolClassMustContainCourse, Boolean courseMustHaveFreeShifts, Boolean enrolInShiftIfUnique, Boolean allAvailableShiftsMustBeEnrolled, String schoolClassNames) {
        this.setContextCourseGroup(contextCourseGroup);
        this.setSchoolClassMustContainCourse(schoolClassMustContainCourse);
        this.setCourseMustHaveFreeShifts(courseMustHaveFreeShifts);
        this.setEnrolInShiftIfUnique(enrolInShiftIfUnique);
        this.setAllAvailableShiftsMustBeEnrolled(allAvailableShiftsMustBeEnrolled);
        this.setSchoolClassNames(schoolClassNames);
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return new StudentSchoolClassCurricularRuleExecutor().execute((ICurricularRule)this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }

    public boolean isVisible() {
        return false;
    }

    protected void removeOwnParameters() {
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<Object> labels = new ArrayList<Object>();
        if (this.getSchoolClassMustContainCourse().booleanValue()) {
            labels.add(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.schoolClassMustContainCourse", (String[])new String[0]));
        }
        if (this.getCourseMustHaveFreeShifts().booleanValue()) {
            labels.add(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.courseMustHaveFreeShifts", (String[])new String[0]));
        }
        if (this.getEnrolInShiftIfUnique().booleanValue()) {
            labels.add(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.enrolInShiftIfUnique", (String[])new String[0]));
        }
        if (this.getAllAvailableShiftsMustBeEnrolled().booleanValue()) {
            labels.add(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.allAvailableShiftsMustBeEnrolled", (String[])new String[0]));
        }
        if (StringUtils.isNotBlank((String)this.getSchoolClassNames())) {
            labels.add(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.StudentSchoolClassCurricularRule.schoolClassNames", (String[])new String[]{this.getSchoolClassNames()}));
        }
        if (this.getContextCourseGroup() != null) {
            labels.add(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.inGroup", (String[])new String[0]) + " " + this.getContextCourseGroup().getOneFullName());
        }
        return List.of(new GenericPair((Object)labels.stream().collect(Collectors.joining(", ")), (Object)false));
    }

    public Stream<String> getSchoolClassesSplitted() {
        return StringUtils.isBlank((String)this.getSchoolClassNames()) ? Stream.empty() : Stream.of(this.getSchoolClassNames().trim().replace(';', '/').replace(',', '/').split("/")).map(String::trim);
    }

    public Boolean getSchoolClassMustContainCourse() {
        return super.getSchoolClassMustContainCourse() != null && super.getSchoolClassMustContainCourse() != false;
    }

    public Boolean getCourseMustHaveFreeShifts() {
        return super.getCourseMustHaveFreeShifts() != null && super.getCourseMustHaveFreeShifts() != false;
    }

    public Boolean getEnrolInShiftIfUnique() {
        return super.getEnrolInShiftIfUnique() != null && super.getEnrolInShiftIfUnique() != false;
    }

    public Boolean getAllAvailableShiftsMustBeEnrolled() {
        return super.getAllAvailableShiftsMustBeEnrolled() != null && super.getAllAvailableShiftsMustBeEnrolled() != false;
    }
}

