/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum.conclusion;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.CurriculumModuleServices;
import org.fenixedu.academic.domain.student.curriculum.ProgramConclusionProcess;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public abstract class RegistrationConclusionServices {
    public static final Comparator<RegistrationConclusionBean> CONCLUSION_BEAN_COMPARATOR_BY_OLDEST_PROCESSED = (x, y) -> {
        if (x.isConclusionProcessed() && !y.isConclusionProcessed()) {
            return -1;
        }
        if (!x.isConclusionProcessed() && y.isConclusionProcessed()) {
            return 1;
        }
        if (x.isConcluded() && !y.isConcluded()) {
            return -1;
        }
        if (!x.isConcluded() && y.isConcluded()) {
            return 1;
        }
        Comparator<Object> planComparator = !x.isConcluded() && !y.isConcluded() ? StudentCurricularPlan.COMPARATOR_BY_START_EXECUTION_AND_DATE.reversed().thenComparing(DomainObjectUtil.COMPARATOR_BY_ID.reversed()) : StudentCurricularPlan.COMPARATOR_BY_START_EXECUTION_AND_DATE.thenComparing(DomainObjectUtil.COMPARATOR_BY_ID);
        return planComparator.compare(x.getCurriculumGroup().getStudentCurricularPlan(), y.getCurriculumGroup().getStudentCurricularPlan());
    };

    @Deprecated
    public static Set<RegistrationConclusionInformation> inferConclusion(Registration registration) {
        return RegistrationConclusionServices.getConclusions(registration).values().stream().filter(c -> c.isConcluded()).map(c -> new RegistrationConclusionInformation((RegistrationConclusionBean)c)).collect(Collectors.toSet());
    }

    public static YearMonthDay calculateConclusionDate(RegistrationConclusionBean input) {
        YearMonthDay result = input.calculateConclusionDate();
        if (result == null && input.getCurriculumGroup().isRoot()) {
            for (CurriculumGroup group : RegistrationConclusionServices.getCurriculumGroupsForConclusion(input.getCurriculumGroup())) {
                YearMonthDay calculated = CurriculumModuleServices.calculateLastAcademicActDate(group, true);
                if (calculated == null || result != null && !calculated.isAfter((ReadablePartial)result)) continue;
                result = calculated;
            }
        }
        return result;
    }

    public static Set<CurriculumGroup> getCurriculumGroupsForConclusion(CurriculumGroup curriculumGroup) {
        HashSet result = Sets.newHashSet((Object[])new CurriculumGroup[]{curriculumGroup});
        StudentCurricularPlan scp = curriculumGroup.getStudentCurricularPlan();
        Registration registration = scp.getRegistration();
        if (RegistrationServices.isCurriculumAccumulated(registration)) {
            for (StudentCurricularPlan otherScp : registration.getSortedStudentCurricularPlans()) {
                if (!otherScp.getStartDateYearMonthDay().isBefore((ReadablePartial)scp.getStartDateYearMonthDay())) continue;
                for (CurriculumGroup otherGroup : RegistrationConclusionServices.otherGroups(otherScp, curriculumGroup)) {
                    result.add(otherGroup);
                }
            }
        }
        return result;
    }

    private static List<CurriculumGroup> otherGroups(StudentCurricularPlan otherScp, CurriculumGroup originalGroup) {
        ArrayList result = Lists.newArrayList();
        result.add(otherScp.getRoot());
        result.addAll(otherScp.getAllCurriculumGroups());
        ProgramConclusion programConclusion = originalGroup.getDegreeModule().getProgramConclusion();
        Predicate<CurriculumGroup> predicate = programConclusion == null ? otherGroup -> originalGroup.isRoot() && otherGroup.isRoot() : otherGroup -> otherGroup.getDegreeModule() != null && otherGroup.getDegreeModule().getProgramConclusion() == programConclusion;
        return result.stream().filter(predicate).collect(Collectors.toList());
    }

    public static Collection<ProgramConclusionProcess> getProgramConclusionProcesses(StudentCurricularPlan curricularPlan) {
        return Stream.concat(Stream.of(curricularPlan.getRoot()), curricularPlan.getAllCurriculumGroups().stream()).filter(cg -> cg.getConclusionProcess() != null && cg.getConclusionProcess() instanceof ProgramConclusionProcess).map(cg -> (ProgramConclusionProcess)cg.getConclusionProcess()).collect(Collectors.toSet());
    }

    public static boolean hasProcessedProgramConclusionInOtherPlan(StudentCurricularPlan curricularPlan, ProgramConclusion programConclusion) {
        return curricularPlan.getRegistration().getStudentCurricularPlansSet().stream().anyMatch(scp -> scp != curricularPlan && RegistrationConclusionServices.getProgramConclusionProcesses(scp).stream().anyMatch(pc -> pc.getGroup().getDegreeModule().getProgramConclusion() == programConclusion));
    }

    public static boolean canProcessProgramConclusionInPreviousPlans(StudentCurricularPlan curricularPlan, ProgramConclusion programConclusion) {
        if (RegistrationConclusionServices.getProgramConclusionProcesses(curricularPlan).stream().anyMatch(pcp -> pcp.getGroup().getDegreeModule().getProgramConclusion() == programConclusion)) {
            return false;
        }
        return curricularPlan.getRegistration().getStudentCurricularPlansSet().stream().filter(scp -> scp != curricularPlan && scp.getStartExecutionYear().isBefore(curricularPlan.getStartExecutionYear())).anyMatch(scp -> new RegistrationConclusionBean(scp, programConclusion).isConcluded());
    }

    public static Map<ProgramConclusion, RegistrationConclusionBean> getConclusions(Registration registration) {
        ArrayListMultimap conclusions = ArrayListMultimap.create();
        registration.getStudentCurricularPlansSet().forEach(arg_0 -> RegistrationConclusionServices.lambda$getConclusions$13((Multimap)conclusions, arg_0));
        HashMap<ProgramConclusion, RegistrationConclusionBean> result = new HashMap<ProgramConclusion, RegistrationConclusionBean>();
        conclusions.asMap().entrySet().stream().forEach(entry -> result.put((ProgramConclusion)entry.getKey(), ((Collection)entry.getValue()).stream().sorted(CONCLUSION_BEAN_COMPARATOR_BY_OLDEST_PROCESSED).findFirst().get()));
        return result;
    }

    private static /* synthetic */ void lambda$getConclusions$13(Multimap conclusions, StudentCurricularPlan scp) {
        ProgramConclusion.conclusionsFor((StudentCurricularPlan)scp).forEach(pc -> conclusions.put(pc, (Object)new RegistrationConclusionBean(scp, pc)));
    }
}

