/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academicextensions.services.registrationhistory;

import java.util.Objects;
import java.util.Optional;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationConfiguration;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.joda.time.LocalDate;

public class EnrolmentEvaluationReport {
    private EnrolmentEvaluation enrolmentEvaluation;

    public EnrolmentEvaluationReport(EnrolmentEvaluation evaluation) {
        this.enrolmentEvaluation = Objects.requireNonNull(evaluation);
    }

    public EnrolmentEvaluation getEnrolmentEvaluation() {
        return this.enrolmentEvaluation;
    }

    public ExecutionInterval getExecutionInterval() {
        return this.enrolmentEvaluation.getExecutionInterval();
    }

    public LocalDate getEvaluationDate() {
        return Optional.ofNullable(this.enrolmentEvaluation.getExamDateYearMonthDay()).map(v -> v.toLocalDate()).orElse(null);
    }

    public Grade getGrade() {
        return this.enrolmentEvaluation.getGrade();
    }

    public Boolean getImprovedPreviousGrade() {
        if (!this.enrolmentEvaluation.getEvaluationSeason().isImprovement()) {
            return null;
        }
        return EvaluationConfiguration.getInstance().getEnrolmentEvaluationForConclusionDate(this.enrolmentEvaluation.getEnrolment()).filter(ev -> ev.isApproved()).map(ev -> this.enrolmentEvaluation.getGrade().compareTo(ev.getGrade()) > 0).orElse(false);
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.enrolmentEvaluation.getEvaluationSeason();
    }

    public Registration getRegistration() {
        return this.enrolmentEvaluation.getRegistration();
    }

    public Person getPerson() {
        return this.getRegistration().getPerson();
    }

    public Enrolment getEnrolment() {
        return this.enrolmentEvaluation.getEnrolment();
    }

    public AcademicPeriod getAcademicPeriod() {
        return Optional.ofNullable(this.getEnrolment().getCurricularCourse().getCompetenceCourse()).map(cc -> cc.getAcademicPeriod(this.getExecutionInterval())).orElse(null);
    }

    public Degree getDegree() {
        return this.getRegistration().getDegree();
    }

    public Integer getCurricularYear() {
        return RegistrationServices.getCurricularYear(this.getRegistration(), this.getExecutionInterval().getExecutionYear()).getResult();
    }
}

