/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EnrolmentEvaluation_Base;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineExtendedInformation;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;

public abstract class CurriculumLineServices {
    private static RelationAdapter<Dismissal, Credits> ON_DISMISSAL_DELETION = new RelationAdapter<Dismissal, Credits>(){

        public void beforeRemove(Dismissal dismissal, Credits credits) {
            if (dismissal == null || credits == null) {
                return;
            }
            credits.setReason(null);
        }
    };
    private static Comparator<CurriculumLine> COMPARATOR_CONTEXT = (o1, o2) -> {
        Optional<Context> c1 = CurriculumLineServices.getParentContexts(o1).stream().sorted(Context::compareTo).findFirst();
        Optional<Context> c2 = CurriculumLineServices.getParentContexts(o2).stream().sorted(Context::compareTo).findFirst();
        if (c1.isPresent() && !c2.isPresent()) {
            return -1;
        }
        if (!c1.isPresent() && c2.isPresent()) {
            return 1;
        }
        if (!c1.isPresent() && !c2.isPresent()) {
            return 0;
        }
        return c1.get().compareTo(c2.get());
    };
    private static Comparator<CurriculumLine> COMPARATOR_FULL_PATH = (o1, o2) -> {
        List<CurriculumGroup> fullPath1 = CurriculumLineServices.collectFullPath(o1.getCurriculumGroup());
        List<CurriculumGroup> fullPath2 = CurriculumLineServices.collectFullPath(o2.getCurriculumGroup());
        for (int i = 0; i < Math.max(fullPath1.size(), fullPath2.size()); ++i) {
            CurriculumGroup group2;
            CurriculumGroup group1 = i >= fullPath1.size() ? null : fullPath1.get(i);
            CurriculumGroup curriculumGroup = group2 = i >= fullPath2.size() ? null : fullPath2.get(i);
            if (group1 == null && group2 != null) {
                return -1;
            }
            if (group1 != null && group2 == null) {
                return 1;
            }
            if (group1 == group2) continue;
            if (group1.getDegreeModule() == null && group2.getDegreeModule() != null) {
                return 1;
            }
            if (group1.getDegreeModule() != null && group2.getDegreeModule() == null) {
                return -1;
            }
            if (group1.getDegreeModule() == null && group2.getDegreeModule() == null) {
                return 0;
            }
            Context context1 = (Context)group1.getDegreeModule().getParentContextsSet().iterator().next();
            Context context2 = (Context)group2.getDegreeModule().getParentContextsSet().iterator().next();
            return context1.compareTo(context2);
        }
        return 0;
    };
    public static Comparator<CurriculumLine> COMPARATOR = (o1, o2) -> {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator(COMPARATOR_FULL_PATH);
        comparatorChain.addComparator(COMPARATOR_CONTEXT);
        comparatorChain.addComparator(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
        return comparatorChain.compare(o1, o2);
    };

    public static void initialize() {
        Dismissal.getRelationCreditsDismissalEquivalence().addListener(ON_DISMISSAL_DELETION);
    }

    public static boolean isOptionalByGroup(CurriculumLine line) {
        CurriculumGroup group = line == null ? null : line.getCurriculumGroup();
        CourseGroup groupModule = group == null ? null : group.getDegreeModule();
        return groupModule == null ? false : groupModule.getIsOptional();
    }

    public static void setRemarks(CurriculumLine curriculumLine, String remarks) {
        CurriculumLineExtendedInformation.findOrCreate(curriculumLine).setRemarks(remarks);
    }

    public static String getRemarks(CurriculumLine curriculumLine) {
        return curriculumLine.getExtendedInformation() == null ? null : curriculumLine.getExtendedInformation().getRemarks();
    }

    public static void setCurricularYear(CurriculumLine curriculumLine, Integer curricularYear) {
        CurriculumLineExtendedInformation.findOrCreate(curriculumLine).setCurricularYear(curricularYear);
    }

    public static Integer getCurricularYear(CurriculumLine curriculumLine) {
        return curriculumLine.getExtendedInformation() == null ? null : curriculumLine.getExtendedInformation().getCurricularYear();
    }

    public static void setExcludedFromAverage(CurriculumLine curriculumLine, Boolean excludedFromAverage) {
        CurriculumLineExtendedInformation.findOrCreate(curriculumLine).setExcludedFromAverage(excludedFromAverage);
    }

    public static boolean isExcludedFromAverage(CurriculumLine curriculumLine) {
        return curriculumLine.getExtendedInformation() != null && curriculumLine.getExtendedInformation().getExcludedFromAverage() != null && curriculumLine.getExtendedInformation().getExcludedFromAverage() != false;
    }

    public static void setExcludedFromCurriculum(CurriculumLine input, boolean value) {
        CurriculumLineExtendedInformation.findOrCreate(input).setExcludedFromCurriculum(value);
    }

    public static boolean isExcludedFromCurriculum(CurriculumLine input) {
        return input.getExtendedInformation() != null && input.getExtendedInformation().getExcludedFromCurriculum();
    }

    public static void setEctsCredits(CurriculumLine curriculumLine, BigDecimal ectsCredits) {
        CurriculumLineExtendedInformation.findOrCreate(curriculumLine).setEctsCredits(ectsCredits);
    }

    public static BigDecimal getEctsCredits(CurriculumLine curriculumLine) {
        return curriculumLine.getExtendedInformation() == null ? null : curriculumLine.getExtendedInformation().getEctsCredits();
    }

    public static void setWeight(CurriculumLine curriculumLine, BigDecimal weight) {
        CurriculumLineExtendedInformation.findOrCreate(curriculumLine).setWeight(weight);
    }

    public static BigDecimal getWeight(CurriculumLine curriculumLine) {
        return curriculumLine.getExtendedInformation() == null ? null : curriculumLine.getExtendedInformation().getWeight();
    }

    private static List<CurriculumGroup> collectFullPath(CurriculumGroup input) {
        ArrayList result = Lists.newArrayList();
        if (input != null) {
            result.addAll(CurriculumLineServices.collectFullPath(input.getCurriculumGroup()));
            result.add(input);
        }
        return result;
    }

    public static Collection<Context> getParentContexts(CurriculumLine curriculumLine) {
        if (curriculumLine.getDegreeModule() == null) {
            return Collections.emptySet();
        }
        CurricularCourse curricularCourse = curriculumLine instanceof OptionalEnrolment ? ((OptionalEnrolment)curriculumLine).getOptionalCurricularCourse() : curriculumLine.getCurricularCourse();
        return curricularCourse.getParentContextsByExecutionYear(curriculumLine.getExecutionYear()).stream().filter(c -> c.getParentCourseGroup() == curriculumLine.getCurriculumGroup().getDegreeModule()).collect(Collectors.toSet());
    }

    public static YearMonthDay getAcademicActDate(CurriculumLine input, boolean forConclusion) {
        YearMonthDay result = null;
        if (Enrolment.class.isAssignableFrom(input.getClass())) {
            result = CurriculumLineServices.getAcademicActDate((Enrolment)input, forConclusion);
        } else if (Dismissal.class.isAssignableFrom(input.getClass())) {
            result = CurriculumLineServices.getAcademicActDate((Dismissal)input);
        }
        return result;
    }

    private static YearMonthDay getAcademicActDate(Dismissal input) {
        return input.getCredits().getOfficialDate() != null ? input.getCredits().getOfficialDate().toDateTimeAtStartOfDay().toYearMonthDay() : input.getCreationDateDateTime().toYearMonthDay();
    }

    private static YearMonthDay getAcademicActDate(Enrolment input, boolean forConclusion) {
        if (input.isAnnulled()) {
            return null;
        }
        if (forConclusion && input.isApproved()) {
            return input.calculateConclusionDate();
        }
        EnrolmentEvaluation enrolmentEvaluation = CurriculumLineServices.getLatestEnrolmentEvaluationForAcademicAct(input.getEvaluationsSet());
        return enrolmentEvaluation == null ? null : enrolmentEvaluation.getExamDateYearMonthDay();
    }

    private static EnrolmentEvaluation getLatestEnrolmentEvaluationForAcademicAct(Collection<EnrolmentEvaluation> evaluations) {
        return evaluations == null ? null : (EnrolmentEvaluation)evaluations.stream().filter(i -> i.isFinal()).max(Comparator.comparing(EnrolmentEvaluation_Base::getExamDateYearMonthDay)).orElse(null);
    }

    public static boolean isSourceOfAnyCredits(ICurriculumEntry entry, StudentCurricularPlan studentCurricularPlan) {
        return studentCurricularPlan.getCreditsSet().stream().anyMatch(c -> c.getIEnrolments().contains(entry));
    }

    @Deprecated
    public static boolean isAffinity(CurriculumLine line) {
        return line.isAffinity();
    }

    public static boolean isEvaluated(CurriculumLine line) {
        if (line != null) {
            if (line instanceof Dismissal) {
                return true;
            }
            if (line instanceof Enrolment) {
                Enrolment enrolment = (Enrolment)line;
                return enrolment.getEvaluationsSet().stream().anyMatch(ev -> ev.getCompetenceCourseMarkSheet() != null || ev.isFinal());
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isNormal(CurriculumLine line) {
        return line.isNormal();
    }
}

