/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degree;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.ExtendedDegreeInfo$callable$getMostRecent;
import org.fenixedu.academic.domain.degree.ExtendedDegreeInfo$callable$getOrCreate;
import org.fenixedu.academic.domain.degree.ExtendedDegreeInfo_Base;
import org.fenixedu.academic.domain.dml.DynamicField;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.signals.Signal;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ExtendedDegreeInfo
extends ExtendedDegreeInfo_Base {
    public static final Advice advice$getMostRecent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$getOrCreate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void setupDeleteListener() {
        FenixFramework.getDomainModel().registerDeletionListener(DegreeInfo.class, degreeInfo -> {
            ExtendedDegreeInfo edi = degreeInfo.getExtendedDegreeInfo();
            degreeInfo.setExtendedDegreeInfo(null);
            if (edi != null) {
                edi.delete();
            }
        });
    }

    public static void setupCreationListener() {
        Signal.register((String)"DEGREE_INFO_CREATION_EVENT", event -> {
            DegreeInfo degreeInfo = (DegreeInfo)event.getInstance();
            if (degreeInfo.getExtendedDegreeInfo() != null) {
                return;
            }
            ExtendedDegreeInfo mostRecent = ExtendedDegreeInfo.findMostRecent(degreeInfo.getExecutionYear(), degreeInfo.getDegree());
            if (mostRecent != null) {
                new ExtendedDegreeInfo(degreeInfo, mostRecent);
            } else {
                new ExtendedDegreeInfo(degreeInfo);
            }
        });
    }

    public ExtendedDegreeInfo() {
        this.setBennu(Bennu.getInstance());
    }

    public ExtendedDegreeInfo(DegreeInfo degreeInfo) {
        this();
        this.setDegreeInfo(degreeInfo);
    }

    public ExtendedDegreeInfo(DegreeInfo degreeInfo, ExtendedDegreeInfo olderEdi) {
        this(degreeInfo);
        this.setScientificAreas(olderEdi.getScientificAreas());
        this.setStudyRegime(olderEdi.getStudyRegime());
        this.setStudyProgrammeDuration(olderEdi.getStudyProgrammeDuration());
        this.setStudyProgrammeRequirements(olderEdi.getStudyProgrammeRequirements());
        this.setHigherEducationAccess(olderEdi.getHigherEducationAccess());
        this.setProfessionalStatus(olderEdi.getProfessionalStatus());
        this.setSupplementExtraInformation(olderEdi.getSupplementExtraInformation());
        this.setSupplementOtherSources(olderEdi.getSupplementOtherSources());
    }

    public void delete() {
        this.setDegreeInfo(null);
        this.setBennu(null);
        this.deleteDomainObject();
    }

    public static ExtendedDegreeInfo getMostRecent(ExecutionYear executionYear, Degree degree) {
        return (ExtendedDegreeInfo)((Object)advice$getMostRecent.perform((Callable)new ExtendedDegreeInfo$callable$getMostRecent(executionYear, degree)));
    }

    static /* synthetic */ ExtendedDegreeInfo advised$getMostRecent(ExecutionYear executionYear, Degree degree) {
        DegreeInfo di = degree.getMostRecentDegreeInfo(executionYear);
        if (di.getExtendedDegreeInfo() == null) {
            ExtendedDegreeInfo mostRecent = ExtendedDegreeInfo.findMostRecent(executionYear, degree);
            return mostRecent != null ? new ExtendedDegreeInfo(di, mostRecent) : new ExtendedDegreeInfo(di);
        }
        return di.getExtendedDegreeInfo();
    }

    public static ExtendedDegreeInfo getOrCreate(ExecutionYear executionYear, Degree degree) {
        return (ExtendedDegreeInfo)((Object)advice$getOrCreate.perform((Callable)new ExtendedDegreeInfo$callable$getOrCreate(executionYear, degree)));
    }

    static /* synthetic */ ExtendedDegreeInfo advised$getOrCreate(ExecutionYear executionYear, Degree degree) {
        DegreeInfo di = degree.getDegreeInfoFor(executionYear);
        if (di == null) {
            DegreeInfo mrdi = degree.getMostRecentDegreeInfo(executionYear);
            DegreeInfo degreeInfo = di = mrdi != null ? new DegreeInfo(mrdi, executionYear) : new DegreeInfo(degree, executionYear);
            if (mrdi != null) {
                DegreeInfo finalDegreeInfo = di;
                mrdi.getDynamicFieldSet().stream().filter(df -> StringUtils.isNotBlank((String)df.getValue())).map(df -> df.getDescriptor().getCode()).forEach(code -> DynamicField.setFieldValue((DomainObject)finalDegreeInfo, (String)code, (Object)DynamicField.getFieldValue((DomainObject)mrdi, (String)code)));
            }
        }
        if (di.getExtendedDegreeInfo() == null) {
            ExtendedDegreeInfo mostRecent = ExtendedDegreeInfo.findMostRecent(executionYear, degree);
            return mostRecent != null ? new ExtendedDegreeInfo(di, mostRecent) : new ExtendedDegreeInfo(di);
        }
        return di.getExtendedDegreeInfo();
    }

    public static ExtendedDegreeInfo findMostRecent(ExecutionYear executionYear, Degree degree) {
        return degree.getDegreeInfosSet().stream().filter(di -> di.getExecutionYear().isBeforeOrEquals(executionYear)).sorted((di1, di2) -> ExecutionYear.REVERSE_COMPARATOR_BY_YEAR.compare(di1.getExecutionYear(), di2.getExecutionYear())).map(di -> di.getExtendedDegreeInfo()).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

