/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.services.evaluation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.academic.dto.evaluation.markSheet.report.CompetenceCourseSeasonReport;
import org.fenixedu.academic.dto.evaluation.markSheet.report.ExecutionCourseSeasonReport;
import org.fenixedu.academic.services.evaluation.MarkSheetStatusReportService$callable$iterateCompetenceCoursesBlock;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class MarkSheetStatusReportService {
    private static final int THREAD_BLOCK_SIZE = 10;
    public static final Advice advice$iterateCompetenceCoursesBlock = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

    public static List<ExecutionCourseSeasonReport> getReportsForExecutionCourse(ExecutionCourse executionCourse) {
        ArrayList result = Lists.newArrayList();
        for (EvaluationSeason season : EvaluationSeasonServices.findByActive(true).collect(Collectors.toList())) {
            ArrayListMultimap reportsByEvaluationDate = ArrayListMultimap.create();
            for (CompetenceCourseSeasonReport competenceCourseSeasonReport : MarkSheetStatusReportService.iterateCompetenceCourses(executionCourse.getExecutionPeriod(), executionCourse.getCompetenceCourses(), Sets.newHashSet((Object[])new EvaluationSeason[]{season}))) {
                reportsByEvaluationDate.put((Object)competenceCourseSeasonReport.getEvaluationDate(), (Object)competenceCourseSeasonReport);
            }
            for (Map.Entry entry : reportsByEvaluationDate.asMap().entrySet()) {
                ExecutionCourseSeasonReport report = new ExecutionCourseSeasonReport(executionCourse, season, (LocalDate)entry.getKey(), (Collection)entry.getValue());
                if (report.getTotalStudents() <= 0) continue;
                result.add(report);
            }
        }
        return result;
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourses(ExecutionInterval executionInterval) {
        return MarkSheetStatusReportService.getReportsForCompetenceCourses(executionInterval, EvaluationSeasonServices.findByActive(true).collect(Collectors.toSet()));
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourses(ExecutionInterval executionInterval, Set<EvaluationSeason> seasons) {
        ArrayList result = Lists.newArrayList();
        Set<CompetenceCourse> toProcess = MarkSheetStatusReportService.collectCompetenceCourses(executionInterval);
        result.addAll(MarkSheetStatusReportService.iterateCompetenceCourses(executionInterval, toProcess, seasons));
        return result;
    }

    private static Set<CompetenceCourse> collectCompetenceCourses(ExecutionInterval interval) {
        HashSet result = Sets.newHashSet();
        for (ExecutionCourse executionCourse : interval.getAssociatedExecutionCoursesSet()) {
            result.addAll(executionCourse.getCompetenceCourses());
        }
        for (EnrolmentEvaluation evaluation : interval.getEnrolmentEvaluationsSet()) {
            result.add(evaluation.getEnrolment().getCurricularCourse().getCompetenceCourse());
        }
        return result;
    }

    private static List<CompetenceCourseSeasonReport> iterateCompetenceCourses(ExecutionInterval interval, Set<CompetenceCourse> competenceCourses, Set<EvaluationSeason> seasons) {
        List errors = Collections.synchronizedList(new ArrayList());
        List<CompetenceCourseSeasonReport> result = Collections.synchronizedList(new ArrayList());
        ArrayList<CompetenceCourse> toProcess = new ArrayList<CompetenceCourse>(competenceCourses);
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors() / 4, 1));
        int startIndex = 0;
        while (startIndex < toProcess.size()) {
            int endIndex = Math.min(startIndex + 10, toProcess.size());
            List block = toProcess.subList(startIndex, endIndex);
            executor.submit(() -> {
                try {
                    result.addAll(MarkSheetStatusReportService.iterateCompetenceCoursesBlock(interval, block, seasons));
                }
                catch (Throwable e) {
                    errors.add(e.getCause() != null ? e.getCause() : e);
                }
            });
            startIndex = endIndex;
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            throw new RuntimeException(errors.stream().map(e -> e.getMessage()).distinct().collect(Collectors.joining("\n")));
        }
        return result;
    }

    private static List<CompetenceCourseSeasonReport> iterateCompetenceCoursesBlock(ExecutionInterval executionInterval, Collection<CompetenceCourse> collection, Set<EvaluationSeason> set) {
        return (List)advice$iterateCompetenceCoursesBlock.perform((Callable)new MarkSheetStatusReportService$callable$iterateCompetenceCoursesBlock(executionInterval, collection, set));
    }

    static /* synthetic */ List<CompetenceCourseSeasonReport> advised$iterateCompetenceCoursesBlock(ExecutionInterval interval, Collection<CompetenceCourse> toProcess, Set<EvaluationSeason> seasons) {
        ArrayList result = Lists.newArrayList();
        for (CompetenceCourse iter : toProcess) {
            result.addAll(MarkSheetStatusReportService.getReportsForCompetenceCourse(interval, iter, seasons));
        }
        return result;
    }

    public static List<CompetenceCourseSeasonReport> getReportsForCompetenceCourse(ExecutionInterval interval, CompetenceCourse toProcess, Set<EvaluationSeason> seasons) {
        ArrayList result = Lists.newArrayList();
        for (EvaluationSeason season : seasons) {
            MarkSheetStatusReportService.addNonEmptyReport(result, MarkSheetStatusReportService.generateReport(interval, toProcess, season, null));
        }
        return result;
    }

    private static void addNonEmptyReport(List<CompetenceCourseSeasonReport> result, CompetenceCourseSeasonReport report) {
        if (report.getTotalStudents() > 0) {
            result.add(report);
        }
    }

    private static CompetenceCourseSeasonReport generateReport(ExecutionInterval interval, CompetenceCourse toProcess, EvaluationSeason season, LocalDate evaluationDate) {
        CompetenceCourseSeasonReport result = new CompetenceCourseSeasonReport(toProcess, season, interval, evaluationDate);
        AtomicInteger notEvaluatedStudents = new AtomicInteger(0);
        toProcess.getExecutionCoursesByExecutionPeriod(interval).stream().forEach(i -> notEvaluatedStudents.addAndGet(CompetenceCourseMarkSheet.getExecutionCourseEnrolmentsNotInAnyMarkSheet(interval, toProcess, i, season, null, Sets.newHashSet()).size()));
        result.setNotEvaluatedStudents(notEvaluatedStudents.get());
        HashSet enrolments = Sets.newHashSet();
        toProcess.getAssociatedCurricularCoursesSet().stream().forEach(i -> enrolments.addAll(i.getEnrolmentsByAcademicInterval(interval.getAcademicInterval())));
        for (Object evaluation : interval.getEnrolmentEvaluationsSet()) {
            if (evaluation.getEvaluationSeason() != season || evaluation.getEnrolment().getCurricularCourse().getCompetenceCourse() != toProcess) continue;
            enrolments.add(evaluation.getEnrolment());
        }
        int evaluatedStudents = 0;
        for (Enrolment enrolment : enrolments) {
            Optional evaluation = enrolment.getEnrolmentEvaluation(season, interval, (Boolean)null);
            if (!evaluation.isPresent() || ((EnrolmentEvaluation)evaluation.get()).getCompetenceCourseMarkSheet() == null) continue;
            ++evaluatedStudents;
        }
        result.setEvaluatedStudents(evaluatedStudents);
        Supplier<Stream> supplier = () -> CompetenceCourseMarkSheet.findBy(interval, toProcess, null, season, null, null, null, null);
        long markSheetsTotal = supplier.get().count();
        result.setMarksheetsTotal(Long.valueOf(markSheetsTotal).intValue());
        long markSheetsToConfirm = supplier.get().filter(markSheet -> !markSheet.isConfirmed()).count();
        result.setMarksheetsToConfirm(Long.valueOf(markSheetsToConfirm).intValue());
        return result;
    }
}

