/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.services.evaluation;

import java.util.Optional;
import java.util.function.Function;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshot;
import org.fenixedu.academic.services.evaluation.MarkSheetDocumentPrinterInterface;

public class MarkSheetDocumentPrintService {
    private static MarkSheetDocumentPrinterInterface SINGLETON;
    public static final String PDF = "application/pdf";

    public static void registerPrinterInterface(MarkSheetDocumentPrinterInterface printer) {
        SINGLETON = printer;
    }

    private static <T> T apply(Function<MarkSheetDocumentPrinterInterface, T> function) {
        return Optional.ofNullable(SINGLETON).map(function).orElseThrow(() -> new RuntimeException("Feature not available"));
    }

    public static byte[] print(CompetenceCourseMarkSheet markSheet) {
        return MarkSheetDocumentPrintService.apply(p -> p.print(markSheet));
    }

    public static byte[] print(CompetenceCourseMarkSheetSnapshot snapshot) {
        return MarkSheetDocumentPrintService.apply(p -> p.print(snapshot));
    }
}

