/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum.creditstransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.student.curriculum.creditstransfer.CreditsTransferRemarkEntry;
import org.fenixedu.commons.i18n.LocalizedString;

public class CreditsTransferRemarksCollection {
    private static final Comparator<ICurriculumEntry> CURRICULUM_ENTRY_COMPARATOR_BY_CODE = (x, y) -> {
        if (StringUtils.isBlank((String)x.getCode()) && StringUtils.isBlank((String)y.getCode())) {
            return 0;
        }
        if (StringUtils.isBlank((String)x.getCode())) {
            return 1;
        }
        if (StringUtils.isBlank((String)y.getCode())) {
            return -1;
        }
        return x.getCode().compareTo(y.getCode());
    };
    private char nextRemarkId = (char)97;
    private Collection<CreditsTransferRemarkEntry> entries = new LinkedHashSet<CreditsTransferRemarkEntry>();

    private CreditsTransferRemarksCollection() {
    }

    private void addEntry(CreditsTransferRemarkEntry entry) {
        if (entry != CreditsTransferRemarkEntry.EMPTY && !entry.toLocalizedString().isEmpty()) {
            CreditsTransferRemarkEntry existingEntry = this.entries.stream().filter(e -> e.matches(entry)).findFirst().orElse(null);
            if (existingEntry != null) {
                existingEntry.merge(entry);
            } else {
                this.entries.add(entry);
            }
        }
    }

    private void sortAndAssignRemarkIds(Collection<ICurriculumEntry> curriculumEntries) {
        ArrayList<ICurriculumEntry> sortedCurriculumEntries = new ArrayList<ICurriculumEntry>(curriculumEntries);
        Comparator comparator = (left, right) -> {
            Integer leftMinIndex = left.getAllCurriculumEntries().stream().map(e -> sortedCurriculumEntries.indexOf(e)).min(Comparator.naturalOrder()).orElse(0);
            Integer rightMinIndex = right.getAllCurriculumEntries().stream().map(e -> sortedCurriculumEntries.indexOf(e)).min(Comparator.naturalOrder()).orElse(0);
            return leftMinIndex.compareTo(rightMinIndex);
        };
        this.entries = this.entries.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
        this.entries.forEach(e -> {
            char c = this.nextRemarkId;
            this.nextRemarkId = (char)(c + '\u0001');
            e.setRemarkId(String.valueOf(c));
        });
    }

    public String getRemarkIdsFor(ICurriculumEntry entry) {
        return this.entries.stream().filter(e -> e.appliesTo(entry)).map(e -> e.getFormattedRemarkId()).collect(Collectors.joining(" "));
    }

    public Collection<String> getRemarkIds() {
        return this.entries.stream().map(e -> e.getRemarkId()).sorted().collect(Collectors.toList());
    }

    public LocalizedString getRemarkTextForId(String remarkId) {
        return this.entries.stream().filter(e -> Objects.equals(e.getRemarkId(), remarkId)).findFirst().map(r -> r.toLocalizedString()).orElse(null);
    }

    public LocalizedString getFormattedRemarks(String separator) {
        LocalizedString.Builder builder = new LocalizedString.Builder();
        this.entries.stream().forEach(e -> builder.append(e.toLocalizedString()).append(separator));
        return builder.build();
    }

    public static CreditsTransferRemarksCollection build(Collection<ICurriculumEntry> curriculumEntries, StudentCurricularPlan studentCurricularPlan) {
        CreditsTransferRemarksCollection remarks = new CreditsTransferRemarksCollection();
        curriculumEntries.stream().sorted(CURRICULUM_ENTRY_COMPARATOR_BY_CODE).flatMap(e -> CreditsTransferRemarkEntry.buildEntries(e, studentCurricularPlan).stream()).forEach(re -> remarks.addEntry((CreditsTransferRemarkEntry)re));
        remarks.sortAndAssignRemarkIds(curriculumEntries);
        return remarks;
    }
}

