/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType$callable$create;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType$callable$delete;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType$callable$edit;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditsReasonType
extends CreditsReasonType_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public CreditsReasonType() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    private static boolean equalInAnyLanguage(LocalizedString object, LocalizedString value) {
        for (Locale objectLocale : object.getLocales()) {
            for (Locale valueLocale : value.getLocales()) {
                if (!object.getContent(objectLocale).equals(value.getContent(valueLocale))) continue;
                return true;
            }
        }
        return false;
    }

    public static CreditsReasonType create(LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, LocalizedString localizedString2, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        return (CreditsReasonType)((Object)advice$create.perform((Callable)new CreditsReasonType$callable$create(localizedString, bl, bl2, bl3, localizedString2, bl4, bl5, bl6, bl7)));
    }

    static /* synthetic */ CreditsReasonType advised$create(LocalizedString reason, boolean active, boolean averageEntry, boolean infoHidden, LocalizedString infoText, boolean infoExplained, boolean infoExplainedWithCountry, boolean infoExplainedWithInstitution, boolean infoExplainedWithEcts) {
        CreditsReasonType result = new CreditsReasonType();
        result.init(reason, active, averageEntry, infoHidden, infoText, infoExplained, infoExplainedWithCountry, infoExplainedWithInstitution, infoExplainedWithEcts);
        return result;
    }

    public CreditsReasonType edit(LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, LocalizedString localizedString2, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        return (CreditsReasonType)((Object)advice$edit.perform((Callable)new CreditsReasonType$callable$edit(this, localizedString, bl, bl2, bl3, localizedString2, bl4, bl5, bl6, bl7)));
    }

    static /* synthetic */ CreditsReasonType advised$edit(CreditsReasonType this_, LocalizedString reason, boolean active, boolean averageEntry, boolean infoHidden, LocalizedString infoText, boolean infoExplained, boolean infoExplainedWithCountry, boolean infoExplainedWithInstitution, boolean infoExplainedWithEcts) {
        this_.init(reason, active, averageEntry, infoHidden, infoText, infoExplained, infoExplainedWithCountry, infoExplainedWithInstitution, infoExplainedWithEcts);
        return this_;
    }

    private void init(LocalizedString reason, boolean active, boolean averageEntry, boolean infoHidden, LocalizedString infoText, boolean infoExplained, boolean infoExplainedWithCountry, boolean infoExplainedWithInstitution, boolean infoExplainedWithEcts) {
        super.setReason(reason);
        super.setActive(active);
        super.setAverageEntry(averageEntry);
        super.setInfoHidden(infoHidden);
        super.setInfoText(infoText);
        super.setInfoExplained(infoExplained);
        super.setInfoExplainedWithCountry(infoExplainedWithCountry);
        super.setInfoExplainedWithInstitution(infoExplainedWithInstitution);
        super.setInfoExplainedWithEcts(infoExplainedWithEcts);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getReason() == null || this.getReason().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CreditsReasonType.required.Reason", new String[0]);
        }
        for (CreditsReasonType creditsReasonType : CreditsReasonType.findAll()) {
            if (creditsReasonType == this || !CreditsReasonType.equalInAnyLanguage(creditsReasonType.getReason(), this.getReason())) continue;
            throw new AcademicExtensionsDomainException("error.CreditsReasonType.reason.must.be.unique", new String[0]);
        }
    }

    public boolean isActive() {
        return super.getActive();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CreditsReasonType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CreditsReasonType this_) {
        if (!this_.getCreditsSet().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CreditsReasonType.cannot.delete.because.already.has.credits.associated", new String[0]);
        }
        super.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static Collection<CreditsReasonType> findActive() {
        HashSet<CreditsReasonType> result = new HashSet<CreditsReasonType>();
        for (CreditsReasonType reasonType : CreditsReasonType.findAll()) {
            if (!reasonType.isActive()) continue;
            result.add(reasonType);
        }
        return result;
    }

    public static Collection<CreditsReasonType> findAll() {
        return Bennu.getInstance().getCreditsReasonTypesSet();
    }
}

