/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.FenixEduAcademicExtensionsConfiguration;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationDataServices;
import org.fenixedu.academic.domain.student.RegistrationExtendedInformation;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.CurriculumConfigurationInitializer;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;

public class RegistrationServices {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationServices.class);
    private static RelationAdapter<DegreeModule, CurriculumModule> CREDITS_CREATION_DISABLE_ACCUMULATED = new RelationAdapter<DegreeModule, CurriculumModule>(){

        public void afterAdd(DegreeModule degreeModule, CurriculumModule curriculumModule) {
            if (degreeModule == null || curriculumModule == null) {
                return;
            }
            if (!(curriculumModule instanceof Dismissal)) {
                return;
            }
            Dismissal dismissal = (Dismissal)curriculumModule;
            StudentCurricularPlan dismissalPlan = dismissal.getStudentCurricularPlan();
            Registration dismissalReg = dismissalPlan.getRegistration();
            if (!RegistrationServices.isCurriculumAccumulated(dismissalReg)) {
                return;
            }
            for (IEnrolment iEnrolment : dismissal.getSourceIEnrolments()) {
                StudentCurricularPlan enrolmentPlan;
                Enrolment enrolment;
                if (!(iEnrolment instanceof Enrolment) || CurriculumLineServices.isExcludedFromCurriculum((CurriculumLine)(enrolment = (Enrolment)iEnrolment)) || dismissalReg != (enrolmentPlan = enrolment.getStudentCurricularPlan()).getRegistration() || dismissalPlan == enrolmentPlan) continue;
                RegistrationServices.setCurriculumAccumulated(dismissalReg, false);
                return;
            }
        }
    };
    private static final Cache<String, ICurriculum> CACHE_CURRICULUMS = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
    private static final int CACHE_CURRICULAR_YEAR_EXPIRE_MINUTES = FenixEduAcademicExtensionsConfiguration.getConfiguration().getCurricularYearCalculatorCached() != false ? 5 : 0;
    private static final Cache<String, CurriculumConfigurationInitializer.CurricularYearResult> CACHE_CURRICULAR_YEAR = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite((long)CACHE_CURRICULAR_YEAR_EXPIRE_MINUTES, TimeUnit.MINUTES).build();
    private static BiFunction<Registration, ExecutionInterval, Collection<SchoolClass>> initialSchoolClassesService = RegistrationServices.defaultInitialSchoolClassesService();

    public static void initialize() {
        Dismissal.getRelationDegreeModuleCurriculumModule().addListener(CREDITS_CREATION_DISABLE_ACCUMULATED);
    }

    private static String getCacheKey(Registration registration, ExecutionYear year) {
        return String.format("%s#%s", registration.getExternalId(), year == null ? "null" : year.getExternalId());
    }

    public static ICurriculum getCurriculum(final Registration registration, final ExecutionYear executionYear) {
        final String key = RegistrationServices.getCacheKey(registration, executionYear);
        try {
            return (ICurriculum)CACHE_CURRICULUMS.get((Object)key, (Callable)new Callable<ICurriculum>(){

                @Override
                public ICurriculum call() {
                    logger.debug(String.format("Miss on Curriculum cache [%s %s]", new DateTime(), key));
                    return registration.getCurriculum(executionYear);
                }
            });
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to get Curriculum [%s %s %s]", new DateTime(), key, t.getLocalizedMessage()));
            return null;
        }
    }

    public static CurriculumConfigurationInitializer.CurricularYearResult getCurricularYear(final Registration registration, final ExecutionYear executionYear) {
        final String key = RegistrationServices.getCacheKey(registration, executionYear);
        try {
            return (CurriculumConfigurationInitializer.CurricularYearResult)CACHE_CURRICULAR_YEAR.get((Object)key, (Callable)new Callable<CurriculumConfigurationInitializer.CurricularYearResult>(){

                @Override
                public CurriculumConfigurationInitializer.CurricularYearResult call() {
                    logger.debug(String.format("Miss on Registration CurricularYear cache [%s %s]", new DateTime(), key));
                    return CurriculumConfigurationInitializer.calculateCurricularYear((Curriculum)RegistrationServices.getCurriculum(registration, executionYear));
                }
            });
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to get Registration CurricularYear [%s %s %s]", new DateTime(), key, t.getLocalizedMessage()));
            return null;
        }
    }

    public static void invalidateCaches(Registration registration, ExecutionYear executionYear) {
        CACHE_CURRICULAR_YEAR.invalidate((Object)RegistrationServices.getCacheKey(registration, executionYear));
        CACHE_CURRICULUMS.invalidate((Object)RegistrationServices.getCacheKey(registration, executionYear));
    }

    public static ExecutionYear getConclusionExecutionYear(Registration registration) {
        try {
            StudentCurricularPlan lastCurricularPlan = registration.getLastStudentCurricularPlan();
            ProgramConclusion conclusion = ProgramConclusion.conclusionsFor((StudentCurricularPlan)lastCurricularPlan).filter(i -> i.isTerminal()).findFirst().get();
            RegistrationConclusionBean bean = new RegistrationConclusionBean(lastCurricularPlan, conclusion);
            return bean.getConclusionYear();
        }
        catch (Throwable t) {
            logger.error("Error trying to determine ConclusionYear: {}", (Object)t.getMessage());
            return null;
        }
    }

    public static boolean isFlunkedUsingCurricularYear(Registration registration, ExecutionYear executionYear) {
        if (registration.getStartExecutionYear().isAfterOrEquals(executionYear) || RegistrationServices.getStudentCurricularPlan(registration, executionYear) == null) {
            return false;
        }
        RegistrationDataByExecutionYear previousData = registration.getRegistrationDataByExecutionYearSet().stream().filter(i -> i.getExecutionYear().isBefore(executionYear) && RegistrationServices.getEnrolmentsCount(i) > 0).max((i, j) -> i.getExecutionYear().compareTo(j.getExecutionYear())).orElse(null);
        if (previousData == null) {
            return false;
        }
        int currentYear = RegistrationServices.getCurricularYear(registration, executionYear).getResult();
        ExecutionYear previousExecutionYear = previousData.getExecutionYear();
        int previousYear = RegistrationServices.getCurricularYear(registration, previousExecutionYear).getResult();
        return previousYear == currentYear;
    }

    private static Integer getEnrolmentsCount(RegistrationDataByExecutionYear data) {
        StudentCurricularPlan plan = RegistrationServices.getStudentCurricularPlan(data.getRegistration(), data.getExecutionYear());
        return plan == null ? 0 : Long.valueOf(plan.getEnrolmentsByExecutionYear(data.getExecutionYear()).stream().filter(i -> !i.isAnnulled()).count()).intValue();
    }

    public static Set<SchoolClass> getSchoolClassesToEnrolBy(Registration registration, DegreeCurricularPlan degreeCurricularPlan, ExecutionInterval executionInterval) {
        return registration.getAssociatedAttendsSet().stream().filter(attends -> attends.getExecutionInterval() == executionInterval).flatMap(attends -> attends.getExecutionCourse().getSchoolClassesBy(degreeCurricularPlan).stream()).collect(Collectors.toSet());
    }

    public static void registerInitialSchoolClassesService(BiFunction<Registration, ExecutionInterval, Collection<SchoolClass>> service) {
        initialSchoolClassesService = service;
    }

    public static Collection<SchoolClass> getInitialSchoolClassesToEnrolBy(Registration registration, ExecutionInterval executionInterval) {
        return initialSchoolClassesService.apply(registration, executionInterval);
    }

    private static BiFunction<Registration, ExecutionInterval, Collection<SchoolClass>> defaultInitialSchoolClassesService() {
        return (r, ei) -> {
            ExecutionDegree executionDegree = r.getActiveDegreeCurricularPlan().getExecutionDegreeByYear(ei.getExecutionYear());
            if (executionDegree != null) {
                int curricularYear = RegistrationServices.getCurricularYear(r, ei.getExecutionYear()).getResult();
                return executionDegree.getSchoolClassesSet().stream().filter(sc -> sc.getCurricularYear().equals(curricularYear)).collect(Collectors.toSet());
            }
            return Collections.emptyList();
        };
    }

    @Deprecated
    public static void replaceSchoolClass(Registration registration, SchoolClass schoolClass, ExecutionInterval executionInterval) {
        SchoolClass.replaceSchoolClass((Registration)registration, (SchoolClass)schoolClass, (ExecutionInterval)executionInterval);
    }

    @Deprecated
    public static List<Shift> getAttendingShifts(SchoolClass schoolClass, Registration registration) {
        return schoolClass.findShiftsFor(registration).collect(Collectors.toList());
    }

    public static Collection<EnrolmentEvaluation> getImprovementEvaluations(Registration registration, ExecutionYear executionYear, Predicate<EnrolmentEvaluation> predicate) {
        HashSet result = Sets.newHashSet();
        for (ExecutionInterval executionInterval : executionYear.getExecutionPeriodsSet()) {
            for (EnrolmentEvaluation evaluation : executionInterval.getEnrolmentEvaluationsSet()) {
                if (!evaluation.getEvaluationSeason().isImprovement() || evaluation.getRegistration() != registration || predicate != null && !predicate.test(evaluation)) continue;
                result.add(evaluation);
            }
        }
        return result;
    }

    public static boolean hasImprovementEvaluations(Registration registration, ExecutionYear executionYear, Predicate<EnrolmentEvaluation> predicate) {
        for (ExecutionInterval executionInterval : executionYear.getExecutionPeriodsSet()) {
            for (EnrolmentEvaluation evaluation : executionInterval.getEnrolmentEvaluationsSet()) {
                if (!evaluation.getEvaluationSeason().isImprovement() || evaluation.getRegistration() != registration || predicate != null && !predicate.test(evaluation)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCreditsBetweenPlans(Registration registration) {
        for (StudentCurricularPlan scp : registration.getStudentCurricularPlansSet()) {
            for (Credits credits : scp.getCreditsSet()) {
                for (EnrolmentWrapper wrapper : credits.getEnrolmentsSet()) {
                    if (wrapper.getIEnrolment().isExternalEnrolment()) continue;
                    Enrolment e = (Enrolment)wrapper.getIEnrolment();
                    if (!registration.getStudentCurricularPlansSet().contains(e.getStudentCurricularPlan())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean canCollectAllPlansForCurriculum(Registration registration) {
        return registration.getStudentCurricularPlansSet().size() > 1 && !RegistrationServices.hasCreditsBetweenPlans(registration);
    }

    public static Curriculum getAllPlansCurriculum(Registration registration, ExecutionYear executionYear) {
        Curriculum curriculumSum = Curriculum.createEmpty((ExecutionYear)executionYear);
        for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
            curriculumSum.add(studentCurricularPlan.getRoot().getCurriculum(executionYear));
        }
        return curriculumSum;
    }

    public static Curriculum filterCurricularYearEntriesBySemester(Curriculum input, Integer semester) {
        Curriculum result = Curriculum.createEmpty((CurriculumModule)input.getCurriculumModule(), (ExecutionYear)input.getExecutionYear());
        result.add(input);
        Iterator iterator = result.getCurricularYearEntries().iterator();
        while (iterator.hasNext()) {
            ICurriculumEntry iter = (ICurriculumEntry)iterator.next();
            if (semester == CurricularPeriodServices.getCurricularSemester((CurriculumLine)iter)) continue;
            iterator.remove();
        }
        return result;
    }

    public static void setIngressionGradeA(Registration registration, BigDecimal grade) {
        RegistrationExtendedInformation.findOrCreate(registration).setIngressionGradeA(grade);
    }

    public static BigDecimal getIngressionGradeA(Registration registration) {
        return registration.getExtendedInformation() != null ? registration.getExtendedInformation().getIngressionGradeA() : null;
    }

    public static void setIngressionGradeB(Registration registration, BigDecimal grade) {
        RegistrationExtendedInformation.findOrCreate(registration).setIngressionGradeB(grade);
    }

    public static BigDecimal getIngressionGradeB(Registration registration) {
        return registration.getExtendedInformation() != null ? registration.getExtendedInformation().getIngressionGradeB() : null;
    }

    public static void setIngressionGradeC(Registration registration, BigDecimal grade) {
        RegistrationExtendedInformation.findOrCreate(registration).setIngressionGradeC(grade);
    }

    public static BigDecimal getIngressionGradeC(Registration registration) {
        return registration.getExtendedInformation() != null ? registration.getExtendedInformation().getIngressionGradeC() : null;
    }

    public static void setIngressionGradeD(Registration registration, BigDecimal grade) {
        RegistrationExtendedInformation.findOrCreate(registration).setIngressionGradeD(grade);
    }

    public static BigDecimal getIngressionGradeD(Registration registration) {
        return registration.getExtendedInformation() != null ? registration.getExtendedInformation().getIngressionGradeD() : null;
    }

    public static void setInternshipGrade(Registration registration, BigDecimal grade) {
        RegistrationExtendedInformation.findOrCreate(registration).setInternshipGrade(grade);
    }

    public static BigDecimal getInternshipGrade(Registration registration) {
        return registration.getExtendedInformation() != null ? registration.getExtendedInformation().getInternshipGrade() : null;
    }

    public static void setInternshipConclusionDate(Registration registration, LocalDate conclusionDate) {
        RegistrationExtendedInformation.findOrCreate(registration).setInternshipConclusionDate(conclusionDate);
    }

    public static LocalDate getInternshipConclusionDate(Registration registration) {
        return registration.getExtendedInformation() != null ? registration.getExtendedInformation().getInternshipConclusionDate() : null;
    }

    public static void setCurriculumAccumulated(Registration input, boolean value) {
        RegistrationExtendedInformation.findOrCreate(input).setCurriculumAccumulated(value);
    }

    public static boolean isCurriculumAccumulated(Registration input) {
        return input.getExtendedInformation() != null && input.getExtendedInformation().getCurriculumAccumulated();
    }

    public static Collection<ExecutionYear> getEnrolmentYears(Registration registration) {
        return registration.getRegistrationDataByExecutionYearSet().stream().filter(rd -> rd.getEnrolmentDate() != null).map(rd -> rd.getExecutionYear()).collect(Collectors.toSet());
    }

    public static ExecutionYear getLastReingressionYear(Registration registration) {
        return registration.getReingressions().stream().map(ri -> ri.getExecutionYear()).sorted(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed()).findFirst().orElse(null);
    }

    public static ExecutionYear getLastReingressionYearIncludingPrecedentRegistrations(Registration registration) {
        return Stream.concat(Stream.of(registration), RegistrationServices.getPrecedentDegreeRegistrations(registration).stream()).flatMap(r -> r.getReingressions().stream()).map(ri -> ri.getExecutionYear()).sorted(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed()).findFirst().orElse(null);
    }

    public static void setManuallyAssignedNumber(Registration input, boolean value) {
        RegistrationExtendedInformation.findOrCreate(input).setManuallyAssignedNumber(value);
    }

    public static boolean isManuallyAssignedNumber(Registration input) {
        return input.getExtendedInformation() != null && input.getExtendedInformation().getManuallyAssignedNumber();
    }

    public static LocalDate getEnrolmentDate(Registration registration, ExecutionYear executionYear) {
        RegistrationDataByExecutionYear dataByExecutionYear = RegistrationDataServices.getRegistrationData(registration, executionYear);
        return dataByExecutionYear == null ? null : dataByExecutionYear.getEnrolmentDate();
    }

    public static Collection<ExecutionYear> getEnrolmentYearsIncludingPrecedentRegistrations(Registration registration) {
        return RegistrationServices.getEnrolmentYearsIncludingPrecedentRegistrations(registration, null);
    }

    public static Collection<ExecutionYear> getEnrolmentYearsIncludingPrecedentRegistrations(Registration registration, ExecutionYear untilExecutionYear) {
        HashSet registrations = Sets.newHashSet();
        registrations.add(registration);
        registrations.addAll(RegistrationServices.getPrecedentDegreeRegistrations(registration));
        HashSet result = Sets.newHashSet();
        for (Registration it : registrations) {
            result.addAll(RegistrationServices.getEnrolmentYears(it));
        }
        if (untilExecutionYear == null) {
            return result;
        }
        return result.stream().filter(e -> e.isBeforeOrEquals(untilExecutionYear)).collect(Collectors.toSet());
    }

    public static Registration getRootRegistration(Registration registration) {
        TreeSet registrations = Sets.newTreeSet((Comparator)Registration.COMPARATOR_BY_START_DATE);
        registrations.add(registration);
        registrations.addAll(RegistrationServices.getPrecedentDegreeRegistrations(registration));
        return (Registration)registrations.first();
    }

    public static Collection<Registration> getPrecedentDegreeRegistrations(Registration registration) {
        Set<Degree> precedentDegreesUntilRoot = RegistrationServices.getPrecedentDegreesUntilRoot(registration.getDegree());
        HashSet result = Sets.newHashSet();
        for (Registration it : registration.getStudent().getRegistrationsSet()) {
            if (registration == it || it.isConcluded() || it.hasConcluded() || !precedentDegreesUntilRoot.contains(it.getDegree())) continue;
            result.add(it);
        }
        return result;
    }

    private static Set<Degree> getPrecedentDegreesUntilRoot(Degree degree) {
        HashSet result = Sets.newHashSet();
        result.addAll(degree.getPrecedentDegreesSet());
        for (Degree it : degree.getPrecedentDegreesSet()) {
            result.addAll(RegistrationServices.getPrecedentDegreesUntilRoot(it));
        }
        return result;
    }

    public static Set<CurriculumLine> getNormalEnroledCurriculumLines(Registration registration, ExecutionYear executionYear, boolean applyDismissalFilter, Collection<CreditsReasonType> dismissalTypesToInclude) {
        return RegistrationServices.getEnroledCurriculumLines(registration, executionYear, l -> CurriculumLineServices.isNormal(l), applyDismissalFilter, dismissalTypesToInclude);
    }

    public static Set<CurriculumLine> getEnroledCurriculumLines(Registration registration, ExecutionYear executionYear, Predicate<CurriculumLine> lineTypePredicate, boolean filterDismissalByReason, Collection<CreditsReasonType> reasonsToInclude) {
        Predicate<CurriculumLine> isForYear = line -> line.getExecutionYear() == executionYear;
        Predicate<CurriculumLine> isValid = line -> {
            if (line.isDismissal()) {
                boolean canBeAccountedAsEnroled;
                Dismissal dismissal = (Dismissal)line;
                boolean bl = canBeAccountedAsEnroled = dismissal.getCredits().getIEnrolments().isEmpty() || dismissal.getCredits().getIEnrolments().stream().allMatch(e -> e.getExecutionYear() == executionYear);
                if (!canBeAccountedAsEnroled) {
                    return false;
                }
                return !filterDismissalByReason || dismissal.getCredits().getReason() != null && reasonsToInclude.contains((Object)dismissal.getCredits().getReason());
            }
            return !((Enrolment)line).isAnnulled();
        };
        Set candidateLines = RegistrationServices.getStudentCurricularPlan(registration, executionYear).getAllCurriculumLines().stream().filter(isForYear.and(lineTypePredicate).and(isValid)).collect(Collectors.toSet());
        Set dismissalDegreeModules = candidateLines.stream().filter(line -> line.isDismissal() && line.getDegreeModule() != null).map(line -> line.getDegreeModule()).collect(Collectors.toSet());
        return candidateLines.stream().filter(line -> line.isDismissal() || line.isEnrolment() && !dismissalDegreeModules.contains(line.getDegreeModule())).collect(Collectors.toSet());
    }

    public static StudentCurricularPlan getStudentCurricularPlan(Registration registration, ExecutionYear executionYear) {
        if (registration.getStudentCurricularPlansSet().size() == 1) {
            return registration.getLastStudentCurricularPlan();
        }
        StudentCurricularPlan curricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (curricularPlan != null) {
            return curricularPlan;
        }
        StudentCurricularPlan firstCurricularPlan = registration.getFirstStudentCurricularPlan();
        return firstCurricularPlan.getStartExecutionYear().isAfterOrEquals(executionYear) ? firstCurricularPlan : null;
    }
}

