/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import org.apache.commons.lang.StringEscapeUtils;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationObservations_Base;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class RegistrationObservations
extends RegistrationObservations_Base {
    private static final String APPEND = "(...)";
    private static final int LIMIT_NUMBER_OF_LINES = 6;
    private static final int LIMIT_NUMBER_OF_CHARS = 200;

    protected RegistrationObservations() {
        this.setWhenCreated(new DateTime());
        this.setCreatedBy(Authenticate.getUser().getUsername());
        this.updateLastModificationData();
    }

    public RegistrationObservations(Registration registration) {
        this();
        this.setRegistration(registration);
    }

    public void setValue(String value) {
        super.setValue(value);
        this.updateLastModificationData();
    }

    private void updateLastModificationData() {
        this.setWhenUpdated(new DateTime());
        this.setUpdatedBy(Authenticate.getUser().getUsername());
    }

    public void delete() {
        this.setRegistration(null);
        this.deleteDomainObject();
    }

    public String getAsHtml() {
        return this.getValue() != null ? StringEscapeUtils.escapeHtml((String)this.getValue()).replaceAll("\r\n", "<br>") : null;
    }

    public String getAsLimitedHtml() {
        int nthIndexOfLineBreak;
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (((String)value).length() > 200) {
            value = ((String)value).substring(0, 200) + APPEND;
        }
        if ((nthIndexOfLineBreak = RegistrationObservations.nthIndexOf((String)value, '\n', 6)) > -1) {
            value = ((String)value).substring(0, nthIndexOfLineBreak) + "\r\n(...)";
        }
        return ((String)value).replaceAll("\r\n", "<br>");
    }

    private static int nthIndexOf(String s, char c, int n) {
        int i = -1;
        while (n-- > 0) {
            if ((i = s.indexOf(c, i + 1)) != -1) continue;
            return -1;
        }
        return i;
    }

    public static void setupDeleteListener() {
        FenixFramework.getDomainModel().registerDeletionListener(Registration.class, registration -> {
            for (RegistrationObservations observations : registration.getRegistrationObservationsSet()) {
                observations.delete();
            }
        });
    }
}

