/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.person;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.person.JobType_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.FenixFramework;

public class JobType
extends JobType_Base {
    public JobType() {
        this.setRoot(Bennu.getInstance());
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getJobsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.JobType.delete.jobsNotEmpty", (String[])new String[0]));
        }
    }

    public void delete() {
        super.setRoot(null);
        super.deleteDomainObject();
    }

    public static Optional<JobType> findByCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return Optional.empty();
        }
        return Bennu.getInstance().getJobTypesSet().stream().filter(c -> code.equals(c.getCode())).findAny();
    }

    static {
        FenixFramework.getDomainModel().registerDeletionListener(Job.class, j -> j.setType(null));
    }
}

