/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonInformation;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$create;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$create$1;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$delete;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$edit;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$edit$1;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$initialize;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$orderDown;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices$callable$orderUp;
import org.fenixedu.academic.domain.evaluation.season.rule.BlockingTreasuryEventInDebt;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonRule;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonStatuteType;
import org.fenixedu.academic.domain.evaluation.season.rule.PreviousSeasonBlockingGrade;
import org.fenixedu.academic.domain.evaluation.season.rule.PreviousSeasonEvaluation;
import org.fenixedu.academic.domain.evaluation.season.rule.PreviousSeasonMinimumGrade;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.academic.domain.treasury.IImprovementTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.core.AbstractDomainObject;
import pt.ist.fenixframework.core.AbstractDomainObjectServices;

public abstract class EvaluationSeasonServices {
    private static final Logger logger;
    public static Comparator<EvaluationSeason> SEASON_ORDER_COMPARATOR;
    private static boolean enrolmentsInEvaluationsDependOnAcademicalActsBlocked;
    public static final Advice advice$edit;
    public static final Advice advice$edit$1;
    public static final Advice advice$create;
    public static final Advice advice$create$1;
    public static final Advice advice$orderUp;
    public static final Advice advice$orderDown;
    public static final Advice advice$delete;
    public static final Advice advice$initialize;

    private static void init(EvaluationSeason evaluationSeason, boolean active, boolean requiresEnrolmentEvaluation, boolean supportsEmptyGrades, boolean supportsTeacherConfirmation, boolean allowsMarksheets) {
        EvaluationSeasonInformation.create(evaluationSeason, active, requiresEnrolmentEvaluation, supportsEmptyGrades, supportsTeacherConfirmation, allowsMarksheets);
        EvaluationSeasonServices.checkRules(evaluationSeason);
    }

    private static void checkRules(EvaluationSeason season) {
        if (season.getInformation() == null) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeason.evaluationSeasonInformation.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)season.getCode())) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeason.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty((LocalizedString)season.getAcronym())) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeason.acronym.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty((LocalizedString)season.getName())) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeason.name.required", new String[0]);
        }
        if (!EvaluationSeasonServices.checkNTrue(1, season.getNormal(), season.getImprovement(), season.getSpecial()) && !season.getSpecialAuthorization()) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeason.type.not.unique", new String[0]);
        }
        EvaluationSeasonServices.checkSeasonExistsForName(season, season.getName());
    }

    private static void checkSeasonExistsForName(EvaluationSeason evaluationSeason, LocalizedString name) {
        for (EvaluationSeason season : EvaluationSeasonServices.findByName(name).collect(Collectors.toSet())) {
            if (season == evaluationSeason) continue;
            throw new AcademicExtensionsDomainException("error.EvaluationSeason.duplicated.name", new String[0]);
        }
    }

    private static boolean checkNTrue(int n, boolean ... args) {
        assert (args.length > 0);
        int count = 0;
        for (boolean b : args) {
            if (b) {
                ++count;
            }
            if (count <= n) continue;
            return false;
        }
        return count == n;
    }

    public static void edit(EvaluationSeason evaluationSeason, String string, LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        Object object = advice$edit.perform((Callable)new EvaluationSeasonServices$callable$edit(evaluationSeason, string, localizedString, localizedString2, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9));
    }

    static /* synthetic */ void advised$edit(EvaluationSeason evaluationSeason, String code, LocalizedString acronym, LocalizedString name, boolean normal, boolean improvement, boolean special, boolean specialAuthorization, boolean active, boolean requiresEnrolmentEvaluation, boolean supportsEmptyGrades, boolean supportsTeacherConfirmation, boolean allowsMarksheets) {
        EvaluationSeasonServices.checkSeasonExistsForName(evaluationSeason, name);
        evaluationSeason.setCode(code);
        evaluationSeason.setAcronym(acronym);
        evaluationSeason.setName(name);
        evaluationSeason.setNormal(normal);
        evaluationSeason.setImprovement(improvement);
        evaluationSeason.setSpecial(special);
        evaluationSeason.setSpecialAuthorization(specialAuthorization);
        evaluationSeason.getInformation().edit(active, requiresEnrolmentEvaluation, supportsEmptyGrades, supportsTeacherConfirmation, allowsMarksheets);
        EvaluationSeasonServices.checkRules(evaluationSeason);
    }

    @Deprecated
    public static void edit(EvaluationSeason evaluationSeason, String string, LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        Object object = advice$edit$1.perform((Callable)new EvaluationSeasonServices$callable$edit$1(evaluationSeason, string, localizedString, localizedString2, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8));
    }

    static /* synthetic */ void advised$edit(EvaluationSeason evaluationSeason, String code, LocalizedString acronym, LocalizedString name, boolean normal, boolean improvement, boolean special, boolean specialAuthorization, boolean active, boolean requiresEnrolmentEvaluation, boolean supportsEmptyGrades, boolean supportsTeacherConfirmation) {
        EvaluationSeasonServices.edit(evaluationSeason, code, acronym, name, normal, improvement, special, specialAuthorization, active, requiresEnrolmentEvaluation, supportsEmptyGrades, supportsTeacherConfirmation, true);
    }

    public static EvaluationSeason create(String string, LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        return (EvaluationSeason)advice$create.perform((Callable)new EvaluationSeasonServices$callable$create(string, localizedString, localizedString2, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9));
    }

    static /* synthetic */ EvaluationSeason advised$create(String code, LocalizedString acronym, LocalizedString name, boolean normal, boolean improvement, boolean special, boolean specialAuthorization, boolean active, boolean requiresEnrolmentEvaluation, boolean supportsEmptyGrades, boolean supportsTeacherConfirmation, boolean allowsMarksheets) {
        EvaluationSeason evaluationSeason = new EvaluationSeason(acronym, name, normal, improvement, specialAuthorization, special);
        evaluationSeason.setCode(code);
        EvaluationSeasonServices.init(evaluationSeason, active, requiresEnrolmentEvaluation, supportsEmptyGrades, supportsTeacherConfirmation, allowsMarksheets);
        return evaluationSeason;
    }

    @Deprecated
    public static EvaluationSeason create(String string, LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        return (EvaluationSeason)advice$create$1.perform((Callable)new EvaluationSeasonServices$callable$create$1(string, localizedString, localizedString2, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8));
    }

    static /* synthetic */ EvaluationSeason advised$create(String code, LocalizedString acronym, LocalizedString name, boolean normal, boolean improvement, boolean special, boolean specialAuthorization, boolean active, boolean requiresEnrolmentEvaluation, boolean supportsEmptyGrades, boolean supportsTeacherConfirmation) {
        return EvaluationSeasonServices.create(code, acronym, name, normal, improvement, special, specialAuthorization, active, requiresEnrolmentEvaluation, supportsEmptyGrades, supportsTeacherConfirmation, true);
    }

    public static Stream<EvaluationSeason> findAll() {
        return EvaluationSeason.all();
    }

    public static Stream<EvaluationSeason> findByCode(String code) {
        return EvaluationSeasonServices.findAll().filter(i -> code.equalsIgnoreCase(i.getCode()));
    }

    public static Stream<EvaluationSeason> findByAcronym(LocalizedString acronym) {
        return EvaluationSeasonServices.findAll().filter(i -> acronym.equals((Object)i.getAcronym()));
    }

    public static Stream<EvaluationSeason> findByName(LocalizedString name) {
        return EvaluationSeasonServices.findAll().filter(i -> name.equals((Object)i.getName()));
    }

    public static Stream<EvaluationSeason> findBySeasonOrder(Integer seasonOrder) {
        return EvaluationSeasonServices.findAll().filter(i -> seasonOrder.equals(EvaluationSeasonServices.getSeasonOrder(i)));
    }

    public static Stream<EvaluationSeason> findByActive(boolean active) {
        return EvaluationSeasonServices.findAll().filter(i -> active == EvaluationSeasonServices.getActive(i));
    }

    public static LocalizedString getDescriptionI18N(EvaluationSeason input) {
        LocalizedString result = new LocalizedString();
        if (input != null) {
            result = result.append(input.getName());
            result = result.append(" [");
            result = result.append(EvaluationSeasonServices.getTypeDescriptionI18N(input));
            result = result.append("]");
        }
        return result;
    }

    public static LocalizedString getTypeDescriptionI18N(EvaluationSeason input) {
        return EvaluationSeasonServices.getEnrolmentEvaluationType(input).getDescriptionI18N();
    }

    public static boolean hasPreviousSeasonBlockingGrade(EvaluationSeason season, EnrolmentEvaluation evaluation) {
        if (evaluation != null) {
            for (PreviousSeasonBlockingGrade rule : EvaluationSeasonRule.find(season, PreviousSeasonBlockingGrade.class)) {
                Grade blocking = rule.getBlocking();
                Grade inspect = evaluation.getGrade();
                if (!blocking.toString().equals(inspect.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRequiredPreviousSeasonMinimumGrade(EvaluationSeason season, Collection<EnrolmentEvaluation> evaluations) {
        EvaluationSeason previousSeason;
        if (evaluations != null && (previousSeason = EvaluationSeasonServices.getPreviousSeason(season)) != null) {
            for (PreviousSeasonMinimumGrade rule : EvaluationSeasonRule.find(season, PreviousSeasonMinimumGrade.class)) {
                for (EnrolmentEvaluation evaluation : evaluations) {
                    Grade grade;
                    Grade minimum;
                    if (evaluation.getEvaluationSeason() != previousSeason || (minimum = rule.getMinimum()).compareTo(grade = evaluation.getGrade()) >= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isBlockingTreasuryEventInDebt(EvaluationSeason season, Enrolment enrolment, ExecutionInterval interval) {
        if (enrolment != null && !EvaluationSeasonRule.find(season, BlockingTreasuryEventInDebt.class).isEmpty()) {
            IImprovementTreasuryEvent event;
            EnrolmentEvaluation evaluation;
            Registration registration = enrolment.getRegistration();
            Person person = registration.getPerson();
            if (EvaluationSeasonServices.isEnrolmentsInEvaluationsDependOnAcademicalActsBlocked() && TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(person, new LocalDate())) {
                return true;
            }
            if (season.isImprovement() && (evaluation = (EnrolmentEvaluation)enrolment.getEnrolmentEvaluation(season, interval, (Boolean)null).orElse(null)) != null && (event = TreasuryBridgeAPIFactory.implementation().getImprovementTaxTreasuryEvent(registration, interval.getExecutionYear())) != null && event.isInDebt(evaluation)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasStudentStatuteBlocking(EvaluationSeason season, Enrolment enrolment, ExecutionInterval interval) {
        if (enrolment != null) {
            for (EvaluationSeasonStatuteType rule : EvaluationSeasonRule.find(season, EvaluationSeasonStatuteType.class)) {
                HashSet inspect;
                Set blocking = rule.getStatuteTypesSet();
                if (Sets.intersection((Set)blocking, (Set)(inspect = Sets.newHashSet(StatuteServices.findStatuteTypes(enrolment.getRegistration(), enrolment.getExecutionPeriod())))).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRequiredPreviousSeasonEvaluation(EvaluationSeason season) {
        return !EvaluationSeasonRule.find(season, PreviousSeasonEvaluation.class).isEmpty();
    }

    public static boolean isRequiredEnrolmentEvaluation(EvaluationSeason input) {
        return input != null && input.getInformation() != null && input.getInformation().getRequiresEnrolmentEvaluation();
    }

    public static boolean isSupportsEmptyGrades(EvaluationSeason input) {
        return input != null && input.getInformation() != null && input.getInformation().getSupportsEmptyGrades();
    }

    public static boolean isSupportsTeacherConfirmation(EvaluationSeason input) {
        return input != null && input.getInformation() != null && input.getInformation().getSupportsTeacherConfirmation();
    }

    public static boolean isForApprovedEnrolments(EvaluationSeason season) {
        return season != null && season.isImprovement();
    }

    public static boolean isDifferentEvaluationSemesterAccepted(EvaluationSeason season) {
        return season != null && season.isImprovement();
    }

    public static EvaluationSeason getPreviousSeason(EvaluationSeason input) {
        return EvaluationSeasonServices.getPreviousSeason(input, true);
    }

    private static EvaluationSeason getPreviousSeason(EvaluationSeason input, boolean onlyActive) {
        EvaluationSeason result = null;
        for (EvaluationSeason iter : EvaluationSeasonServices.findByActive(onlyActive).collect(Collectors.toSet())) {
            if (iter == input || EvaluationSeasonServices.getEnrolmentEvaluationType(iter) != EvaluationSeasonServices.getEnrolmentEvaluationType(input) || EvaluationSeasonServices.getSeasonOrder(iter) > EvaluationSeasonServices.getSeasonOrder(input) || result != null && EvaluationSeasonServices.getSeasonOrder(result) > EvaluationSeasonServices.getSeasonOrder(iter)) continue;
            result = iter;
        }
        return result;
    }

    public static EvaluationSeason getNextSeason(EvaluationSeason input) {
        return EvaluationSeasonServices.getNextSeason(input, true);
    }

    private static EvaluationSeason getNextSeason(EvaluationSeason input, boolean onlyActive) {
        EvaluationSeason result = null;
        for (EvaluationSeason iter : EvaluationSeasonServices.findByActive(onlyActive).collect(Collectors.toSet())) {
            if (iter == input || EvaluationSeasonServices.getEnrolmentEvaluationType(iter) != EvaluationSeasonServices.getEnrolmentEvaluationType(input) || EvaluationSeasonServices.getSeasonOrder(iter) < EvaluationSeasonServices.getSeasonOrder(input) || result != null && EvaluationSeasonServices.getSeasonOrder(result) < EvaluationSeasonServices.getSeasonOrder(iter)) continue;
            result = iter;
        }
        return result;
    }

    public static EvaluationSeason getFirstSeasonInChain(EvaluationSeason input) {
        if (EvaluationSeasonServices.isFirst(input)) {
            return input;
        }
        return EvaluationSeasonServices.getFirstSeasonInChain(EvaluationSeasonServices.getPreviousSeason(input));
    }

    public static boolean isFirst(EvaluationSeason input) {
        return EvaluationSeasonServices.getPreviousSeason(input) == null;
    }

    public static boolean isLast(EvaluationSeason input) {
        return EvaluationSeasonServices.getNextSeason(input) == null;
    }

    public static boolean isDeletable(EvaluationSeason evaluationSeason) {
        return evaluationSeason.getEvaluationSet().size() == 0;
    }

    public static boolean getActive(EvaluationSeason input) {
        return input != null && input.getInformation() != null && input.getInformation().getActive();
    }

    public static Integer getSeasonOrder(EvaluationSeason input) {
        EvaluationSeasonInformation information = input.getInformation();
        return information == null || information.getSeasonOrder() == null ? 0 : information.getSeasonOrder();
    }

    public static void setSeasonOrder(EvaluationSeason evaluationSeason, Integer order) {
        evaluationSeason.getInformation().setSeasonOrder(order);
    }

    public static void orderUp(EvaluationSeason evaluationSeason) {
        Object object = advice$orderUp.perform((Callable)new EvaluationSeasonServices$callable$orderUp(evaluationSeason));
    }

    static /* synthetic */ void advised$orderUp(EvaluationSeason input) {
        if (EvaluationSeasonServices.isFirst(input)) {
            return;
        }
        EvaluationSeason neighbour = EvaluationSeasonServices.getPreviousSeason(input, false);
        Integer temp = EvaluationSeasonServices.getSeasonOrder(neighbour);
        EvaluationSeasonServices.setSeasonOrder(neighbour, EvaluationSeasonServices.getSeasonOrder(input));
        EvaluationSeasonServices.setSeasonOrder(input, temp);
    }

    public static void orderDown(EvaluationSeason evaluationSeason) {
        Object object = advice$orderDown.perform((Callable)new EvaluationSeasonServices$callable$orderDown(evaluationSeason));
    }

    static /* synthetic */ void advised$orderDown(EvaluationSeason input) {
        if (EvaluationSeasonServices.isLast(input)) {
            return;
        }
        EvaluationSeason neighbour = EvaluationSeasonServices.getNextSeason(input, false);
        Integer temp = EvaluationSeasonServices.getSeasonOrder(neighbour);
        EvaluationSeasonServices.setSeasonOrder(neighbour, EvaluationSeasonServices.getSeasonOrder(input));
        EvaluationSeasonServices.setSeasonOrder(input, temp);
    }

    public static void delete(EvaluationSeason evaluationSeason) {
        Object object = advice$delete.perform((Callable)new EvaluationSeasonServices$callable$delete(evaluationSeason));
    }

    static /* synthetic */ void advised$delete(EvaluationSeason evaluationSeason) {
        if (!EvaluationSeasonServices.isDeletable(evaluationSeason)) {
            throw new AcademicExtensionsDomainException("error.EvaluationSeason.not.empty.to.delete", new String[0]);
        }
        AbstractDomainObjectServices.deleteDomainObject((AbstractDomainObject)evaluationSeason);
    }

    private static EnrolmentEvaluationType getEnrolmentEvaluationType(EvaluationSeason input) {
        if (input.isSpecialAuthorization()) {
            return EnrolmentEvaluationType.SPECIAL_AUTHORIZATION;
        }
        if (input.isNormal()) {
            return EnrolmentEvaluationType.NORMAL;
        }
        if (input.isSpecial()) {
            return EnrolmentEvaluationType.SPECIAL_SEASON;
        }
        if (input.isImprovement()) {
            return EnrolmentEvaluationType.IMPROVEMENT;
        }
        throw new AcademicExtensionsDomainException("error.EvaluationSeason.missing.type", new String[0]);
    }

    private static Integer getEnrolmentEvaluationTypePrecedence(EvaluationSeason input) {
        return EvaluationSeasonServices.getEnrolmentEvaluationType(input).ordinal();
    }

    public static void initialize() {
        Object object = advice$initialize.perform((Callable)new EvaluationSeasonServices$callable$initialize());
    }

    static /* synthetic */ void advised$initialize() {
        List seasons = EvaluationSeasonServices.findAll().sorted(SEASON_ORDER_COMPARATOR).collect(Collectors.toList());
        for (int i = 0; i < seasons.size(); ++i) {
            EvaluationSeason iter = (EvaluationSeason)seasons.get(i);
            if (iter.getInformation() != null) continue;
            logger.info("Init " + iter.getName().getContent());
            EvaluationSeasonInformation.create(iter, false, false, true, false, true).setSeasonOrder(i);
        }
    }

    public static Integer maxOrder() {
        int result = 0;
        for (EvaluationSeason iter : EvaluationSeasonServices.findAll().collect(Collectors.toSet())) {
            Integer order = EvaluationSeasonServices.getSeasonOrder(iter);
            if (order <= result) continue;
            result = order;
        }
        return result;
    }

    public static boolean isEnrolmentsInEvaluationsDependOnAcademicalActsBlocked() {
        return enrolmentsInEvaluationsDependOnAcademicalActsBlocked;
    }

    public static void setEnrolmentsInEvaluationsDependOnAcademicalActsBlocked(boolean enrolmentsInEvaluationsDependOnAcademicalActsBlocked) {
        EvaluationSeasonServices.enrolmentsInEvaluationsDependOnAcademicalActsBlocked = enrolmentsInEvaluationsDependOnAcademicalActsBlocked;
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$edit$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$orderUp = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$orderDown = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$initialize = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(EvaluationSeasonServices.class);
        SEASON_ORDER_COMPARATOR = new Comparator<EvaluationSeason>(){

            @Override
            public int compare(EvaluationSeason o1, EvaluationSeason o2) {
                int result = EvaluationSeasonServices.getEnrolmentEvaluationTypePrecedence(o1).compareTo(EvaluationSeasonServices.getEnrolmentEvaluationTypePrecedence(o2));
                if (result == 0) {
                    result = EvaluationSeasonServices.getSeasonOrder(o1).compareTo(EvaluationSeasonServices.getSeasonOrder(o2));
                }
                if (result == 0) {
                    result = o1.compareTo(o2);
                }
                return result;
            }
        };
        enrolmentsInEvaluationsDependOnAcademicalActsBlocked = true;
    }

    private static enum EnrolmentEvaluationType {
        NORMAL("label.EvaluationSeason.normal"),
        SPECIAL_SEASON("label.EvaluationSeason.special"),
        IMPROVEMENT("label.EvaluationSeason.improvement"),
        SPECIAL_AUTHORIZATION("label.EvaluationSeason.specialAuthorization");

        private String descriptionKey;

        private EnrolmentEvaluationType(String descriptionKey) {
            this.descriptionKey = descriptionKey;
        }

        public LocalizedString getDescriptionI18N() {
            return AcademicExtensionsUtil.bundleI18N(this.descriptionKey, new String[0]);
        }
    }
}

