/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriodType;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.util.date.IntervalTools;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInterval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class EvaluationSeasonPeriod
extends EvaluationSeasonPeriod_Base {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy").withLocale(I18N.getLocale());
    private static final Comparator<Interval> COMPARATOR_INTERVAL = (x, y) -> x.getStart().compareTo((ReadableInstant)y.getStart());
    private static final Gson intervalsGson = new GsonBuilder().registerTypeAdapter(Interval.class, (Object)new JsonSerializer<Interval>(){

        public JsonElement serialize(Interval src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("start", src.getStart().toString());
            json.addProperty("end", src.getEnd().toString());
            return json;
        }
    }).registerTypeAdapter(Interval.class, (Object)new JsonDeserializer<Interval>(){

        public Interval deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            DateTime start = new DateTime((Object)jsonObject.get("start").getAsString());
            DateTime end = new DateTime((Object)jsonObject.get("end").getAsString());
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
    }).create();

    protected EvaluationSeasonPeriod() {
    }

    public static EvaluationSeasonPeriod create(ExecutionInterval executionInterval, EvaluationSeasonPeriodType periodType, EvaluationSeason evaluationSeason, Set<DegreeType> degreeTypes, LocalDate start, LocalDate end) {
        EvaluationSeasonPeriod result = new EvaluationSeasonPeriod();
        result.setExecutionSemester(executionInterval);
        result.setSeason(evaluationSeason);
        result.setPeriodType(periodType);
        result.addInterval(start, end);
        Set<ExecutionDegree> initialExecutionDegrees = EvaluationSeasonPeriod.getInitialExecutionDegrees(executionInterval.getExecutionYear(), degreeTypes);
        result.getExecutionDegreesSet().addAll(initialExecutionDegrees);
        return result;
    }

    private static Set<ExecutionDegree> getInitialExecutionDegrees(ExecutionYear year, Set<DegreeType> degreeTypes) {
        if (year != null && !degreeTypes.isEmpty()) {
            return year.getExecutionDegreesSet().stream().filter(ed -> degreeTypes.contains(ed.getDegreeType())).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public void addDegree(ExecutionDegree input) {
        this.getExecutionDegreesSet().add(input);
    }

    public void removeDegree(ExecutionDegree input) {
        this.getExecutionDegreesSet().remove(input);
    }

    public void addInterval(LocalDate start, LocalDate end) {
        List<Interval> intervals = this.getIntervals();
        intervals.add(IntervalTools.getInterval((LocalDate)start, (LocalDate)end));
        intervals.sort(COMPARATOR_INTERVAL);
        this.setIntervalsRaw(intervalsGson.toJsonTree(intervals));
    }

    public void removeInterval(LocalDate start, LocalDate end) {
        List<Interval> intervals = this.getIntervals();
        intervals.removeIf(i -> i.getStart().toLocalDate().equals((Object)start) && i.getEnd().toLocalDate().equals((Object)end));
        if (intervals.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.OccupationPeriod.required.Interval", new String[0]);
        }
        intervals.sort(COMPARATOR_INTERVAL);
        this.setIntervalsRaw(intervalsGson.toJsonTree(intervals));
    }

    public void delete() {
        super.setExecutionSemester(null);
        super.setSeason(null);
        this.getExecutionDegreesSet().clear();
        this.deleteDomainObject();
    }

    public static Set<EvaluationSeasonPeriod> findBy(ExecutionYear executionYear) {
        return executionYear != null ? executionYear.getExecutionPeriodsSet().stream().flatMap(es -> es.getEvaluationSeasonPeriodSet().stream()).collect(Collectors.toSet()) : new HashSet<EvaluationSeasonPeriod>();
    }

    public static Stream<EvaluationSeasonPeriod> findBy(ExecutionCourse executionCourse, EvaluationSeason season, EvaluationSeasonPeriodType periodType) {
        if (executionCourse == null) {
            return Stream.empty();
        }
        ExecutionInterval executionInterval = executionCourse.getExecutionInterval();
        Set executionDegreesForCourse = executionCourse.getAssociatedCurricularCoursesSet().stream().flatMap(course -> course.getDegreeCurricularPlan().findExecutionDegree(executionInterval).stream()).collect(Collectors.toSet());
        return executionInterval.getEvaluationSeasonPeriodSet().stream().filter(period -> periodType == null || period.getPeriodType() == periodType).filter(period -> season == null || period.getSeason() == season).filter(period -> !Collections.disjoint(period.getExecutionDegrees(), executionDegreesForCourse));
    }

    @Deprecated
    public ExecutionInterval getExecutionSemester() {
        return super.getExecutionSemester();
    }

    public ExecutionInterval getExecutionInterval() {
        return super.getExecutionSemester();
    }

    public static String getIntervalsDescription(Set<EvaluationSeasonPeriod> input) {
        List<Interval> intervals = input.stream().flatMap(p -> p.getIntervals().stream()).collect(Collectors.toList());
        return EvaluationSeasonPeriod.getIntervalsDescription(intervals);
    }

    public String getIntervalsDescription() {
        return EvaluationSeasonPeriod.getIntervalsDescription(this.getIntervals());
    }

    private static String getIntervalsDescription(List<Interval> intervals) {
        String result = intervals.stream().sorted(Comparator.comparing(AbstractInterval::getStart)).map(i -> DATE_TIME_FORMATTER.print((ReadableInstant)i.getStart()) + " <-> " + DATE_TIME_FORMATTER.print((ReadableInstant)i.getEnd())).collect(Collectors.joining("; "));
        return result;
    }

    public Set<ExecutionDegree> getExecutionDegrees() {
        return this.getExecutionDegreesSet();
    }

    public List<Interval> getIntervals() {
        ArrayList<Interval> result = new ArrayList<Interval>();
        if (this.getIntervalsRaw() != null) {
            this.getIntervalsRaw().getAsJsonArray().forEach(elem -> result.add((Interval)intervalsGson.fromJson(elem, Interval.class)));
        }
        return result;
    }

    public boolean isContainingDate(LocalDate date) {
        return this.getIntervals().stream().anyMatch(i -> i.contains((ReadableInstant)date.toDateTimeAtStartOfDay()));
    }
}

