/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.FenixEduAcademicExtensionsConfiguration;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompetenceCourseServices {
    private static final Logger logger = LoggerFactory.getLogger(CompetenceCourseServices.class);
    private static final int CACHE_APPROVALS_MAX_SIZE = 200000;
    private static final int CACHE_APPROVALS_EXPIRE_MIN = 10;
    private static final Map<StudentCurricularPlan, Cache<String, Boolean>> CACHE_APPROVALS = new ConcurrentHashMap<StudentCurricularPlan, Cache<String, Boolean>>();
    private static final Map<StudentCurricularPlan, Cache<Registration, Set<StudentCurricularPlan>>> CACHE_SCPS = new ConcurrentHashMap<StudentCurricularPlan, Cache<Registration, Set<StudentCurricularPlan>>>();
    private static Map<String, Set<CurricularCourse>> CACHE_COMPETENCE_CURRICULARS = new ConcurrentHashMap<String, Set<CurricularCourse>>();

    public static boolean isCompetenceCourseApproved(StudentCurricularPlan plan, CurricularCourse course, ExecutionInterval Interval2) {
        Registration registration = plan.getRegistration();
        CompetenceCourse competence = course.getCompetenceCourse();
        if (competence == null) {
            return plan.isApproved(course, Interval2);
        }
        Cache cache = CACHE_SCPS.computeIfAbsent(plan, p -> CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(200000L).expireAfterWrite(10L, TimeUnit.MINUTES).build());
        try {
            Set set = (Set)cache.get((Object)registration, () -> CompetenceCourseServices.getScpsToCheck(registration));
            return set.stream().anyMatch(i -> CompetenceCourseServices.isApproved(i, competence, Interval2));
        }
        catch (ExecutionException e) {
            logger.error(String.format("Unable to get Approvals [%s %s %s]", new DateTime(), registration.getExternalId(), e.getLocalizedMessage()));
            return false;
        }
    }

    public static int countEnrolmentsUntil(StudentCurricularPlan plan, CurricularCourse curricularCourse, ExecutionYear executionYear) {
        Registration registration = plan.getRegistration();
        CompetenceCourse competence = curricularCourse.getCompetenceCourse();
        Predicate<Enrolment> validEnrolment = e -> !e.isAnnulled() && e.getExecutionYear().isBeforeOrEquals(executionYear);
        if (competence == null) {
            return (int)plan.getEnrolments(curricularCourse).stream().filter(validEnrolment).count();
        }
        Set<CurricularCourse> expandedCourses = CompetenceCourseServices.getExpandedCurricularCourses(competence.getCode());
        int total = 0;
        for (StudentCurricularPlan scpToCheck : CompetenceCourseServices.getScpsToCheck(registration)) {
            for (CurricularCourse expandedCourse : expandedCourses) {
                total = (int)((long)total + scpToCheck.getEnrolments(expandedCourse).stream().filter(validEnrolment).count());
            }
        }
        return total;
    }

    private static Set<StudentCurricularPlan> getScpsToCheck(Registration registration) {
        HashSet result = Sets.newHashSet();
        if (FenixEduAcademicExtensionsConfiguration.getConfiguration().getCurricularRulesApprovalsAwareOfCompetenceCourseAtStudentScope().booleanValue()) {
            ((Stream)registration.getStudent().getRegistrationsSet().stream().flatMap(r -> r.getStudentCurricularPlansSet().stream()).sequential()).collect(Collectors.toCollection(() -> result));
        } else {
            result.addAll(registration.getStudentCurricularPlansSet());
        }
        return result;
    }

    private static boolean isApproved(final StudentCurricularPlan plan, final CompetenceCourse competence, final ExecutionInterval interval) {
        Cache<String, Boolean> scpCache = CompetenceCourseServices.getApprovalCacheForSCP(plan);
        final String key = CompetenceCourseServices.buildCourseApprovalCacheKey(competence, interval);
        try {
            return (Boolean)scpCache.get((Object)key, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    logger.debug(String.format("Miss on Approvals cache [%s %s]", new DateTime(), plan.getExternalId() + "#" + key));
                    Set<CurricularCourse> curriculars = CompetenceCourseServices.getExpandedCurricularCourses(competence.getCode());
                    return curriculars == null ? false : curriculars.stream().anyMatch(curricular -> plan.isApproved(curricular, interval));
                }
            });
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to get Approvals [%s %s %s]", new DateTime(), plan.getExternalId() + "#" + key, t.getLocalizedMessage()));
            return false;
        }
    }

    private static Cache<String, Boolean> getApprovalCacheForSCP(StudentCurricularPlan plan) {
        Cache scpCache = CACHE_APPROVALS.computeIfAbsent(plan, p -> CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(200000L).expireAfterWrite(10L, TimeUnit.MINUTES).build());
        return scpCache;
    }

    private static String buildCourseApprovalCacheKey(CompetenceCourse competence, ExecutionInterval interval) {
        return competence.getExternalId() + "#" + (interval == null ? "null" : interval.getExternalId());
    }

    public static Set<CurricularCourse> getExpandedCurricularCourses(String code) {
        String key = CompetenceCourseServices.filterCode(code);
        try {
            return CACHE_COMPETENCE_CURRICULARS.computeIfAbsent(key, k -> CompetenceCourseServices.loadExpandedCurricularCourses(k));
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to get CompetenceCourse CurricularCourses [%s %s %s]", new DateTime(), key, t.getLocalizedMessage()));
            return null;
        }
    }

    private static Set<CurricularCourse> loadExpandedCurricularCourses(String key) {
        HashSet result = Sets.newHashSet();
        String code = CompetenceCourseServices.filterCode(key);
        if (!Strings.isNullOrEmpty((String)code)) {
            CompetenceCourse competence = CompetenceCourse.find((String)code);
            if (competence != null) {
                result.addAll(competence.getAssociatedCurricularCoursesSet());
            }
            for (CompetenceCourse iter : Bennu.getInstance().getCompetenceCoursesSet()) {
                if (iter == competence || !code.equals(CompetenceCourseServices.filterCode(iter.getCode()))) continue;
                result.addAll(iter.getAssociatedCurricularCoursesSet());
            }
        }
        return result;
    }

    private static boolean isExpandedCode(String input) {
        return !Strings.isNullOrEmpty((String)input) && input.endsWith("ects") && input.contains("_");
    }

    private static String filterCode(String input) {
        return !CompetenceCourseServices.isExpandedCode(input) ? input : input.substring(0, input.lastIndexOf("_"));
    }

    public static void invalidateCourseApprovalCache(StudentCurricularPlan plan, CurricularCourse curricularCourse, ExecutionInterval interval) {
        if (curricularCourse == null || curricularCourse.getCompetenceCourse() == null) {
            return;
        }
        Cache<String, Boolean> approvalCacheForSCP = CompetenceCourseServices.getApprovalCacheForSCP(plan);
        approvalCacheForSCP.invalidate((Object)CompetenceCourseServices.buildCourseApprovalCacheKey(curricularCourse.getCompetenceCourse(), interval));
    }
}

