/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourseRestrictions;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class AnyCurricularCourseRestrictionsExecutor
extends CurricularRuleExecutor {
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        AnyCurricularCourseRestrictions rule = (AnyCurricularCourseRestrictions)curricularRule;
        CurricularCourse curricularCourseToEnrol = AnyCurricularCourseRestrictionsExecutor.getCurricularCourseFromOptional(sourceDegreeModuleToEvaluate);
        if (curricularCourseToEnrol != null && this.isAllowedCourseGroup(rule, curricularCourseToEnrol, sourceDegreeModuleToEvaluate.getExecutionInterval().getExecutionYear())) {
            return AnyCurricularCourseRestrictionsExecutor.createResultFalse(rule, sourceDegreeModuleToEvaluate, curricularCourseToEnrol, "curricularRules.ruleExecutors.AnyCurricularCourseRestrictions.only.allowedCourseGroups");
        }
        return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected RuleResult executeEnrolmentPrefilter(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (sourceDegreeModuleToEvaluate instanceof OptionalDegreeModuleToEnrol) {
            RuleResult result = this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
            return result.isTrue() ? result : RuleResult.createFalse((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private boolean isAllowedCourseGroup(AnyCurricularCourseRestrictions rule, CurricularCourse courseToEnrol, ExecutionYear executionYear) {
        Collection parentGroups = courseToEnrol.getParentContextsByExecutionYear(executionYear).stream().map(ctx -> ctx.getParentCourseGroup()).collect(Collectors.toSet());
        Set ancestorGroups = Stream.concat(parentGroups.stream(), parentGroups.stream().flatMap(cg -> cg.getAllParentCourseGroups().stream())).collect(Collectors.toSet());
        return Sets.intersection((Set)rule.getCourseGroupsSet(), ancestorGroups).isEmpty();
    }

    private static CurricularCourse getCurricularCourseFromOptional(IDegreeModuleToEvaluate input) {
        CurricularCourse result = null;
        if (input.isEnroling()) {
            OptionalDegreeModuleToEnrol toEnrol = (OptionalDegreeModuleToEnrol)input;
            result = toEnrol.getCurricularCourse();
        } else if (input.isEnroled()) {
            EnroledOptionalEnrolment enroled = (EnroledOptionalEnrolment)input;
            result = (CurricularCourse)enroled.getCurriculumModule().getDegreeModule();
        }
        return result;
    }

    private static RuleResult createResultFalse(AnyCurricularCourseRestrictions rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CurricularCourse curricularCourseToEnrol, String messageKey) {
        String message = BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)messageKey, (String[])new String[]{curricularCourseToEnrol.getName(), rule.getDegreeModuleToApplyRule().getName(), rule.getCourseGroupsDescription()});
        return sourceDegreeModuleToEvaluate.isEnroled() ? RuleResult.createImpossibleWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)message) : RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)message);
    }
}

