/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.MinCreditsInEnrolmentPeriod$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.MinCreditsInEnrolmentPeriod_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResultMessage;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MinCreditsInEnrolmentPeriod
extends MinCreditsInEnrolmentPeriod_Base {
    private static final BigDecimal YEAR_CREDITS;
    public static final Advice advice$create;

    protected MinCreditsInEnrolmentPeriod() {
    }

    public RuleResult execute(EnrolmentContext enrolmentContext) {
        if (!this.hasValidRegime(enrolmentContext)) {
            return this.createNA();
        }
        if (!this.hasValidStatute(enrolmentContext)) {
            return this.createNA();
        }
        BigDecimal missingCredits = this.getMissingCredits(enrolmentContext);
        BigDecimal enroledCredits = this.getEnroledCredits(enrolmentContext);
        if (missingCredits.compareTo(BigDecimal.ZERO) == 0 || enroledCredits.compareTo(missingCredits) >= 0 || enroledCredits.compareTo(this.getCredits()) >= 0) {
            return this.createTrue();
        }
        return this.createWarning(missingCredits.min(this.getCredits()), enroledCredits);
    }

    private BigDecimal getMissingCredits(EnrolmentContext context) {
        Map<CurricularPeriod, BigDecimal> creditsByYear = CurricularPeriodServices.mapYearCredits(this.getCurriculum(context));
        return this.getCurricularPeriodsForYears(context).stream().map(cp -> this.getMissingCreditsFor(context, creditsByYear, (CurricularPeriod)cp)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private ICurriculum getCurriculum(EnrolmentContext context) {
        ICurriculum curriculum = RegistrationServices.getCurriculum(context.getRegistration(), context.getExecutionYear());
        if (context.isToEvaluateRulesByYear()) {
            return curriculum;
        }
        Set filteredEntries = curriculum.getCurricularYearEntries().stream().filter(e -> {
            CurricularPeriod period = CurricularPeriodServices.getCurricularPeriod((CurriculumLine)e);
            return period.getChildOrder().intValue() == context.getExecutionPeriod().getChildOrder().intValue() && period.getAcademicPeriod().equals((Object)context.getExecutionPeriod().getAcademicPeriod());
        }).collect(Collectors.toSet());
        return new Curriculum((CurriculumModule)context.getStudentCurricularPlan().getRoot(), context.getExecutionYear(), Collections.emptySet(), Collections.emptySet(), filteredEntries);
    }

    private BigDecimal getMissingCreditsFor(EnrolmentContext context, Map<CurricularPeriod, BigDecimal> creditsByYear, CurricularPeriod period) {
        BigDecimal approvedCredits = creditsByYear.getOrDefault(period, BigDecimal.ZERO);
        return this.getEnrolmentPeriodCreditsBaseline(context).subtract(approvedCredits).max(BigDecimal.ZERO);
    }

    private BigDecimal getEnrolmentPeriodCreditsBaseline(EnrolmentContext context) {
        return context.isToEvaluateRulesByYear() ? YEAR_CREDITS : YEAR_CREDITS.multiply(BigDecimal.valueOf(context.getExecutionPeriod().getAcademicPeriod().getWeight()).setScale(1, RoundingMode.HALF_UP));
    }

    private BigDecimal getEnroledCredits(EnrolmentContext context) {
        Collection<CurricularPeriod> curricularPeriods = this.getCurricularPeriodsForYears(context);
        Map<CurricularPeriod, BigDecimal> creditsByYear = CurricularPeriodServices.mapYearCredits(context, null);
        return creditsByYear.entrySet().stream().filter(e -> curricularPeriods.contains(e.getKey())).map(e -> (BigDecimal)e.getValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Collection<CurricularPeriod> getCurricularPeriodsForYears(EnrolmentContext context) {
        DegreeCurricularPlan curricularPlan = context.getStudentCurricularPlan().getDegreeCurricularPlan();
        int minYear = Optional.ofNullable(this.getYearMin()).map(v -> (int)v).orElse(1);
        int maxYear = Optional.ofNullable(this.getYearMax()).map(v -> (int)v).orElseGet(() -> curricularPlan.getDurationInYears());
        return this.getCurricularPeriodsConfigured(minYear, maxYear, false);
    }

    public RuleResult createWarning(BigDecimal minToEnrol, BigDecimal enroledCredits) {
        String prefix = BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.CurricularPeriodRule.prefix", (String[])new String[]{this.getConfiguration().getCurricularPeriod().getFullLabel()});
        String literalMessage = prefix + this.getPartialRegimeLabelPrefix() + this.getStatuteTypesLabelPrefix() + " " + BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.MinCreditsInEnrolmentPeriod", (String[])new String[]{minToEnrol.toPlainString(), enroledCredits.toPlainString()});
        return RuleResult.createWarning((DegreeModule)this.getDegreeModule(), Collections.singleton(new RuleResultMessage(literalMessage, false, new String[0])));
    }

    public String getLabel() {
        return BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.MinCreditsInEnrolmentPeriod", (String[])new String[0]);
    }

    public static MinCreditsInEnrolmentPeriod create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal) {
        return (MinCreditsInEnrolmentPeriod)((Object)advice$create.perform((Callable)new MinCreditsInEnrolmentPeriod$callable$create(curricularPeriodConfiguration, bigDecimal)));
    }

    static /* synthetic */ MinCreditsInEnrolmentPeriod advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits) {
        MinCreditsInEnrolmentPeriod result = new MinCreditsInEnrolmentPeriod();
        result.init(configuration, credits, null);
        return result;
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        YEAR_CREDITS = BigDecimal.valueOf(60L);
    }
}

