/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsNotEnroled$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsNotEnroled$callable$create$1;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsNotEnroled_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResultMessage;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditsNotEnroled
extends CreditsNotEnroled_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CreditsNotEnroled() {
    }

    public static CreditsNotEnroled create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal) {
        return (CreditsNotEnroled)((Object)advice$create.perform((Callable)new CreditsNotEnroled$callable$create(curricularPeriodConfiguration, bigDecimal)));
    }

    static /* synthetic */ CreditsNotEnroled advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits) {
        return CreditsNotEnroled.create(configuration, credits, configuration.getCurricularPeriod().getAbsoluteOrderOfChild());
    }

    public static CreditsNotEnroled create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n) {
        return (CreditsNotEnroled)((Object)advice$create$1.perform((Callable)new CreditsNotEnroled$callable$create$1(curricularPeriodConfiguration, bigDecimal, n)));
    }

    static /* synthetic */ CreditsNotEnroled advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer year) {
        CreditsNotEnroled result = new CreditsNotEnroled();
        result.init(configuration, credits, null, year);
        return result;
    }

    protected void init(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester, Integer year) {
        super.init(configuration, credits, semester);
        super.setYearMin(year);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getYearMin() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".yearMin.required", new String[0]);
        }
    }

    public RuleResult execute(EnrolmentContext enrolmentContext) {
        BigDecimal enroledAndEnroling;
        DegreeCurricularPlan dcp = this.getDegreeCurricularPlan();
        CurricularPeriod configured = CurricularPeriodServices.getCurricularPeriod(dcp, this.getYearMin());
        if (configured == null) {
            return this.createFalseConfiguration();
        }
        ICurriculum curriculum = RegistrationServices.getCurriculum(enrolmentContext.getRegistration(), null);
        BigDecimal approved = this.getCreditsApproved(curriculum, configured);
        BigDecimal total = approved.add(enroledAndEnroling = this.getCreditsEnroledAndEnroling(enrolmentContext, configured));
        return total.compareTo(this.getCredits()) >= 0 ? this.createTrue() : this.createWarningLabelled(enroledAndEnroling, approved, total);
    }

    private BigDecimal getCreditsApproved(ICurriculum curriculum, CurricularPeriod curricularPeriod) {
        BigDecimal result = BigDecimal.ZERO;
        Map<CurricularPeriod, BigDecimal> curricularPeriodCredits = CurricularPeriodServices.mapYearCredits(curriculum, this.getApplyToOptionals());
        BigDecimal credits = curricularPeriodCredits.get(curricularPeriod);
        if (credits != null) {
            result = result.add(credits);
        }
        return result;
    }

    private BigDecimal getCreditsEnroledAndEnroling(EnrolmentContext enrolmentContext, CurricularPeriod curricularPeriod) {
        BigDecimal result = BigDecimal.ZERO;
        Map<CurricularPeriod, BigDecimal> curricularPeriodCredits = CurricularPeriodServices.mapYearCredits(enrolmentContext, this.getApplyToOptionals());
        BigDecimal credits = curricularPeriodCredits.get(curricularPeriod);
        if (credits != null) {
            result = result.add(credits);
        }
        return result;
    }

    public RuleResult createWarningLabelled(BigDecimal enroledAndEnroling, BigDecimal approved, BigDecimal total) {
        String prefix = BundleUtil.getString((String)MODULE_BUNDLE, (String)"label.CurricularPeriodRule.prefix", (String[])new String[]{this.getConfiguration().getCurricularPeriod().getFullLabel()});
        String literalMessage = prefix + " " + this.getLabel() + " " + BundleUtil.getString((String)MODULE_BUNDLE, (String)"label.CreditsNotEnroled.suffix", (String[])new String[]{enroledAndEnroling.toPlainString(), approved.toPlainString(), total.toPlainString()});
        return RuleResult.createWarning((DegreeModule)this.getDegreeModule(), Collections.singleton(new RuleResultMessage(literalMessage, false, new String[0])));
    }

    public String getLabel() {
        String label = "label." + ((Object)((Object)this)).getClass().getSimpleName();
        if (this.getApplyToOptionals() != null) {
            label = label + (this.getApplyToOptionals() != false ? ".applyToOptionals" : ".applyToOptionals.not");
        }
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)label, (String[])new String[]{this.getCredits().toString(), this.getYearMin().toString()});
    }
}

