/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.services.evaluation;

import com.qubit.terra.docs.core.DocumentGenerator;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.evaluation.config.CompetenceCourseMarkSheetTemplateFile;
import org.fenixedu.academic.domain.evaluation.config.MarkSheetSettings;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshot;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshotEntry;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.qubdocs.util.reports.helpers.DateHelper;
import org.fenixedu.qubdocs.util.reports.helpers.EnumerationHelper;
import org.fenixedu.qubdocs.util.reports.helpers.LanguageHelper;
import org.fenixedu.qubdocs.util.reports.helpers.MoneyHelper;
import org.fenixedu.qubdocs.util.reports.helpers.NumbersHelper;
import org.fenixedu.qubdocs.util.reports.helpers.StringsHelper;
import org.joda.time.DateTime;

public class MarkSheetDocumentPrintService {
    public static final String PDF = "application/pdf";

    private static void registerHelpers(DocumentGenerator generator) {
        generator.registerHelper("dates", (IDocumentHelper)new DateHelper());
        generator.registerHelper("lang", (IDocumentHelper)new LanguageHelper());
        generator.registerHelper("numbers", (IDocumentHelper)new NumbersHelper());
        generator.registerHelper("enumeration", (IDocumentHelper)new EnumerationHelper());
        generator.registerHelper("strings", (IDocumentHelper)new StringsHelper());
        generator.registerHelper("money", (IDocumentHelper)new MoneyHelper());
    }

    public static byte[] print(CompetenceCourseMarkSheet markSheet) {
        markSheet.markAsPrinted();
        return MarkSheetDocumentPrintService.print(markSheet.getLastSnapshot().get());
    }

    public static byte[] print(CompetenceCourseMarkSheetSnapshot snapshot) {
        CompetenceCourseMarkSheetTemplateFile templateFile = MarkSheetSettings.getInstance().getTemplateFile();
        DocumentGenerator generator = DocumentGenerator.create((InputStream)new ByteArrayInputStream(templateFile.getContent()), (String)PDF);
        MarkSheetDocumentPrintService.registerHelpers(generator);
        generator.registerDataProvider((IReportDataProvider)new CompetenceCourseMarkSheetDataProvider(snapshot));
        return generator.generateReportCached(templateFile.getExternalId());
    }

    public static class CompetenceCourseMarkSheetDataProvider
    implements IReportDataProvider {
        private static final String MARK_SHEET_KEY = "markSheet";
        private static final String INSTITUTION_NAME_KEY = "institutionName";
        private static final String MARK_SHEET_EVALUATIONS_KEY = "markSheetEvaluations";
        private static final String CURRENT_DATE_TIME_KEY = "currentDateTime";
        private CompetenceCourseMarkSheetSnapshot competenceCourseMarkSheet;
        private List<EvaluationLine> evaluations = new ArrayList<EvaluationLine>();

        public CompetenceCourseMarkSheetDataProvider(CompetenceCourseMarkSheetSnapshot snapshot) {
            this.competenceCourseMarkSheet = snapshot;
            for (CompetenceCourseMarkSheetSnapshotEntry entry : snapshot.getSortedEntries()) {
                this.evaluations.add(new EvaluationLine(entry.getStudentNumber(), entry.getStudentName(), entry.getGrade().getValue()));
            }
        }

        public boolean handleKey(String key) {
            return key.equals(MARK_SHEET_KEY) || key.equals(INSTITUTION_NAME_KEY) || key.equals(MARK_SHEET_EVALUATIONS_KEY) || key.equals(CURRENT_DATE_TIME_KEY);
        }

        public Object valueForKey(String key) {
            if (key.equals(MARK_SHEET_KEY)) {
                return this.competenceCourseMarkSheet;
            }
            if (key.equals(INSTITUTION_NAME_KEY)) {
                return Bennu.getInstance().getInstitutionUnit().getNameI18n();
            }
            if (key.equals(MARK_SHEET_EVALUATIONS_KEY)) {
                return this.evaluations;
            }
            if (key.equals(CURRENT_DATE_TIME_KEY)) {
                return new DateTime();
            }
            return null;
        }

        public void registerFieldsAndImages(IDocumentFieldsData arg0) {
            arg0.registerCollectionAsField(MARK_SHEET_EVALUATIONS_KEY);
        }

        public static class EvaluationLine {
            private Integer studentNumber;
            private String studentName;
            private String grade;

            private EvaluationLine(Integer studentNumber, String studentName, String grade) {
                this.studentNumber = studentNumber;
                this.studentName = studentName;
                this.grade = grade;
            }

            public Integer getStudentNumber() {
                return this.studentNumber;
            }

            public String getStudentName() {
                return this.studentName;
            }

            public String getGrade() {
                return this.grade;
            }

            public void setStudentNumber(Integer studentNumber) {
                this.studentNumber = studentNumber;
            }

            public void setStudentName(String studentName) {
                this.studentName = studentName;
            }

            public void setGrade(String grade) {
                this.grade = grade;
            }
        }
    }
}

