/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.function.Supplier;
import org.fenixedu.academic.FenixEduAcademicExtensionsConfiguration;
import org.fenixedu.academic.FenixeduAcademicExtensionsInitializer;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataServices;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CurriculumConfigurationInitializer {
    private static final Logger logger = LoggerFactory.getLogger(CurriculumConfigurationInitializer.class);
    private static Supplier<Curriculum.CurricularYearCalculator> CURRICULAR_YEAR_CALCULATOR = () -> new Curriculum.CurricularYearCalculator(){
        private BigDecimal approvedCredits;
        private BigDecimal remainingCredits;
        private Integer curricularYear;
        private Integer totalCurricularYears;

        public Integer curricularYear(Curriculum curriculum) {
            if (this.curricularYear == null) {
                this.curricularYear = CurriculumConfigurationInitializer.calculateCurricularYear(curriculum).getResult();
            }
            return this.curricularYear;
        }

        public Integer totalCurricularYears(Curriculum curriculum) {
            if (this.totalCurricularYears == null) {
                this.totalCurricularYears = CurriculumConfigurationInitializer.calculateTotalCurricularYears(curriculum);
            }
            return this.totalCurricularYears;
        }

        public BigDecimal approvedCredits(Curriculum curriculum) {
            if (this.approvedCredits == null) {
                this.approvedCredits = BigDecimal.ZERO;
                for (ICurriculumEntry entry : curriculum.getCurricularYearEntries()) {
                    this.approvedCredits = this.approvedCredits.add(entry.getEctsCreditsForCurriculum());
                }
                this.accountForDirectIngressions(curriculum);
            }
            return this.approvedCredits;
        }

        public BigDecimal remainingCredits(Curriculum curriculum) {
            if (this.remainingCredits == null) {
                this.remainingCredits = BigDecimal.ZERO;
                for (ICurriculumEntry entry : curriculum.getCurricularYearEntries()) {
                    Dismissal dismissal;
                    if (!(entry instanceof Dismissal) || !(dismissal = (Dismissal)entry).getCredits().isCredits() && !dismissal.getCredits().isEquivalence() && (!dismissal.isCreditsDismissal() || dismissal.getCredits().isSubstitution())) continue;
                    this.remainingCredits = this.remainingCredits.add(entry.getEctsCreditsForCurriculum());
                }
            }
            return this.remainingCredits;
        }

        private void accountForDirectIngressions(Curriculum curriculum) {
            if (curriculum.getStudentCurricularPlan() == null) {
                return;
            }
            if (CurriculumConfigurationInitializer.calculateCycleType(curriculum) != null) {
                return;
            }
            if (!curriculum.getStudentCurricularPlan().getDegreeCurricularPlan().isBolonhaDegree()) {
                return;
            }
            if (curriculum.getStudentCurricularPlan().getCycleCurriculumGroups().isEmpty()) {
                return;
            }
            CycleCurriculumGroup sgroup = (CycleCurriculumGroup)Collections.min(curriculum.getStudentCurricularPlan().getCycleCurriculumGroups(), CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID);
            for (CycleType cycleIter = sgroup.getCycleType().getPrevious(); cycleIter != null; cycleIter = cycleIter.getPrevious()) {
                if (curriculum.getStudentCurricularPlan().getDegreeCurricularPlan().getCycleCourseGroup(cycleIter) == null) continue;
                this.approvedCredits = this.approvedCredits.add(new BigDecimal(cycleIter.getEctsCredits()));
            }
        }
    };
    private static Supplier<Curriculum.CurriculumGradeCalculator> CURRICULUM_GRADE_CALCULATOR = () -> (Curriculum.CurriculumGradeCalculator)FenixeduAcademicExtensionsInitializer.loadClass(null, FenixEduAcademicExtensionsConfiguration.getConfiguration().getCurriculumGradeCalculator());
    private static Supplier<Curriculum.CurriculumEntryPredicate> CURRICULUM_ENTRY_PREDICATE = () -> new Curriculum.CurriculumEntryPredicate(){

        public boolean test(ICurriculumEntry input) {
            CurriculumLine line;
            return !(input instanceof CurriculumLine) || !CurriculumLineServices.isExcludedFromCurriculum(line = (CurriculumLine)input);
        }
    };
    public static Supplier<CurriculumGroup.CurriculumSupplier> GROUP_CURRICULUM_SUPPLIER = () -> new CurriculumGroup.CurriculumSupplier(){

        public Curriculum get(CurriculumGroup curriculumGroup, DateTime when, ExecutionYear executionYear) {
            Curriculum result = Curriculum.createEmpty((CurriculumModule)curriculumGroup, (ExecutionYear)executionYear);
            if (curriculumGroup.wasCreated(when)) {
                for (CurriculumModule curriculumModule : curriculumGroup.getCurriculumModulesSet()) {
                    result.add(curriculumModule.getCurriculum(when, executionYear));
                }
            }
            for (CurriculumGroup otherGroup : RegistrationConclusionServices.getCurriculumGroupsForConclusion(curriculumGroup)) {
                if (otherGroup == curriculumGroup) continue;
                result.add(otherGroup.getCurriculum(when, executionYear));
            }
            return result;
        }
    };
    private static Supplier<CurriculumGroup.ConclusionProcessEnabler> GROUP_CONCLUSION_ENABLER = () -> new CurriculumGroup.ConclusionProcessEnabler(){

        public boolean isAllowed(CurriculumGroup input) {
            if (input != null) {
                return input.isConcluded() || RegistrationServices.isCurriculumAccumulated(input.getRegistration());
            }
            return false;
        }
    };

    public static void init() {
        Curriculum.setCurricularYearCalculator(CURRICULAR_YEAR_CALCULATOR);
        Curriculum.setCurriculumGradeCalculator(CURRICULUM_GRADE_CALCULATOR);
        Curriculum.setCurriculumEntryPredicate(CURRICULUM_ENTRY_PREDICATE);
        CurriculumGroup.setCurriculumSupplier(GROUP_CURRICULUM_SUPPLIER);
        CurriculumGroup.setConclusionProcessEnabler(GROUP_CONCLUSION_ENABLER);
    }

    public static CurricularYearResult calculateCurricularYear(Curriculum curriculum) {
        ExecutionYear executionYear = curriculum.getExecutionYear();
        CurricularYearResult calculated = new CurricularYearResult(executionYear);
        if (curriculum.getCurriculumModule() == null) {
            calculated.setResult(1);
            calculated.setJustificationText(AcademicExtensionsUtil.bundle("error.curricularYear.unable.to.determine.student.curricular.plan.for.execution.year", executionYear.getQualifiedName()));
            return calculated;
        }
        Registration registration = curriculum.getCurriculumModule().getRegistration();
        StudentCurricularPlan scp = registration.getStudentCurricularPlan(executionYear);
        if (scp == null || CurricularPeriodServices.getCurricularPeriodConfiguration(scp.getDegreeCurricularPlan(), 1) == null) {
            scp = curriculum.getStudentCurricularPlan();
        }
        DegreeCurricularPlan dcp = scp.getDegreeCurricularPlan();
        RuleResult justification = null;
        for (int i = CurriculumConfigurationInitializer.calculateTotalCurricularYears(curriculum); i > 1; --i) {
            CurricularPeriodConfiguration configuration = CurricularPeriodServices.getCurricularPeriodConfiguration(dcp, i);
            if (configuration == null) {
                calculated.setJustification(RuleResult.createFalseWithLiteralMessage((DegreeModule)dcp.getRoot(), (String)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"label.enrolmentPeriodRestrictions", (String[])new String[0])));
                continue;
            }
            RuleResult ruleResult = configuration.verifyRulesForTransition(curriculum);
            if (ruleResult.isTrue()) {
                calculated.setResult(i);
                if (justification != null) break;
                justification = ruleResult;
                break;
            }
            justification = ruleResult;
        }
        calculated.setJustification(justification);
        Integer curricularYear = RegistrationDataServices.getOverridenCurricularYear(registration, executionYear);
        if (curricularYear != null) {
            CurricularYearResult overriden = new CurricularYearResult(executionYear);
            overriden.setResult(curricularYear);
            overriden.setJustification(RuleResult.createFalseWithLiteralMessage((DegreeModule)curriculum.getCurriculumModule().getDegreeModule(), (String)BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.curricularYear.overriden", (String[])new String[]{String.valueOf(overriden.getResult()), String.valueOf(calculated.getResult()), calculated.getJustificationPresentation()})));
            logger.debug("[REG][{}][CURRICULAR_YEAR][OVERRIDEN][{}]", (Object)registration.getNumber(), (Object)String.valueOf(overriden.getResult()));
            return overriden;
        }
        logger.debug("[REG][{}][CURRICULAR_YEAR][{}]", (Object)registration.getNumber(), (Object)String.valueOf(calculated.getResult()));
        return calculated;
    }

    private static int calculateTotalCurricularYears(Curriculum curriculum) {
        return curriculum.getStudentCurricularPlan() == null ? 0 : curriculum.getStudentCurricularPlan().getDegreeCurricularPlan().getDurationInYears(CurriculumConfigurationInitializer.calculateCycleType(curriculum));
    }

    private static CycleType calculateCycleType(Curriculum curriculum) {
        if (!curriculum.hasCurriculumModule() || !curriculum.isBolonha().booleanValue()) {
            return null;
        }
        CurriculumModule module = curriculum.getCurriculumModule();
        CycleType cycleType = module.isCycleCurriculumGroup() ? ((CycleCurriculumGroup)module).getCycleType() : null;
        return cycleType;
    }

    public static class CurricularYearResult {
        private int curricularYear = 1;
        private RuleResult justification = null;
        private String justificationText = null;
        private ExecutionYear executionYear;

        public CurricularYearResult(ExecutionYear executionYear) {
            this.setExecutionYear(executionYear);
        }

        public int getResult() {
            return this.curricularYear;
        }

        private void setResult(int result) {
            this.curricularYear = result;
        }

        public RuleResult getJustification() {
            return this.justification;
        }

        private void setJustification(RuleResult justification) {
            this.justification = justification;
        }

        private void setJustificationText(String justificationText) {
            this.justificationText = justificationText;
        }

        public String getJustificationPresentation() {
            return this.justificationText != null ? this.justificationText : CurricularPeriodRule.getMessages(this.justification).replace("-", AcademicExtensionsUtil.bundle("label.CurricularYearResult.empty", new String[0])).replace(AcademicExtensionsUtil.bundle("label.CurricularYearResult.prefix.remove", new String[0]), AcademicExtensionsUtil.bundle("label.CurricularYearResult.prefix.add", new String[0]));
        }

        public ExecutionYear getExecutionYear() {
            return this.executionYear;
        }

        public void setExecutionYear(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }
    }
}

