/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType$callable$create;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType$callable$delete;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType$callable$edit;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType_Base;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditsReasonType
extends CreditsReasonType_Base {
    public static final String SEPARATOR = " ; ";
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public CreditsReasonType() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    private static boolean equalInAnyLanguage(LocalizedString object, LocalizedString value) {
        for (Locale objectLocale : object.getLocales()) {
            for (Locale valueLocale : value.getLocales()) {
                if (!object.getContent(objectLocale).equals(value.getContent(valueLocale))) continue;
                return true;
            }
        }
        return false;
    }

    public static CreditsReasonType create(LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, LocalizedString localizedString2, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        return (CreditsReasonType)((Object)advice$create.perform((Callable)new CreditsReasonType$callable$create(localizedString, bl, bl2, bl3, localizedString2, bl4, bl5, bl6, bl7)));
    }

    static /* synthetic */ CreditsReasonType advised$create(LocalizedString reason, boolean active, boolean averageEntry, boolean infoHidden, LocalizedString infoText, boolean infoExplained, boolean infoExplainedWithCountry, boolean infoExplainedWithInstitution, boolean infoExplainedWithEcts) {
        CreditsReasonType result = new CreditsReasonType();
        result.init(reason, active, averageEntry, infoHidden, infoText, infoExplained, infoExplainedWithCountry, infoExplainedWithInstitution, infoExplainedWithEcts);
        return result;
    }

    public CreditsReasonType edit(LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, LocalizedString localizedString2, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        return (CreditsReasonType)((Object)advice$edit.perform((Callable)new CreditsReasonType$callable$edit(this, localizedString, bl, bl2, bl3, localizedString2, bl4, bl5, bl6, bl7)));
    }

    static /* synthetic */ CreditsReasonType advised$edit(CreditsReasonType this_, LocalizedString reason, boolean active, boolean averageEntry, boolean infoHidden, LocalizedString infoText, boolean infoExplained, boolean infoExplainedWithCountry, boolean infoExplainedWithInstitution, boolean infoExplainedWithEcts) {
        this_.init(reason, active, averageEntry, infoHidden, infoText, infoExplained, infoExplainedWithCountry, infoExplainedWithInstitution, infoExplainedWithEcts);
        return this_;
    }

    private void init(LocalizedString reason, boolean active, boolean averageEntry, boolean infoHidden, LocalizedString infoText, boolean infoExplained, boolean infoExplainedWithCountry, boolean infoExplainedWithInstitution, boolean infoExplainedWithEcts) {
        super.setReason(reason);
        super.setActive(active);
        super.setAverageEntry(averageEntry);
        super.setInfoHidden(infoHidden);
        super.setInfoText(infoText);
        super.setInfoExplained(infoExplained);
        super.setInfoExplainedWithCountry(infoExplainedWithCountry);
        super.setInfoExplainedWithInstitution(infoExplainedWithInstitution);
        super.setInfoExplainedWithEcts(infoExplainedWithEcts);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getReason() == null || this.getReason().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CreditsReasonType.required.Reason", new String[0]);
        }
        for (CreditsReasonType creditsReasonType : CreditsReasonType.findAll()) {
            if (creditsReasonType == this || !CreditsReasonType.equalInAnyLanguage(creditsReasonType.getReason(), this.getReason())) continue;
            throw new AcademicExtensionsDomainException("error.CreditsReasonType.reason.must.be.unique", new String[0]);
        }
    }

    public boolean isActive() {
        return super.getActive();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CreditsReasonType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CreditsReasonType this_) {
        if (!this_.getCreditsSet().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CreditsReasonType.cannot.delete.because.already.has.credits.associated", new String[0]);
        }
        super.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static Collection<CreditsReasonType> findActive() {
        HashSet<CreditsReasonType> result = new HashSet<CreditsReasonType>();
        for (CreditsReasonType reasonType : CreditsReasonType.findAll()) {
            if (!reasonType.isActive()) continue;
            result.add(reasonType);
        }
        return result;
    }

    public static Collection<CreditsReasonType> findAll() {
        return Bennu.getInstance().getCreditsReasonTypesSet();
    }

    public LocalizedString getInfo(ICurriculumEntry entry, Dismissal dismissal, boolean hideDetails) {
        LocalizedString.Builder result = new LocalizedString.Builder();
        Credits credits = dismissal.getCredits();
        if (this.isActive()) {
            if (this.getInfoHidden()) {
                return null;
            }
            result.append(this.getInfoText());
            if (!hideDetails) {
                LocalizedString explanation;
                if (entry instanceof ExternalEnrolment) {
                    this.addExternalEnrolmentInformation(result, (ExternalEnrolment)entry, false);
                }
                if (this.getInfoExplained() && !(explanation = this.getExplanation(dismissal)).isEmpty()) {
                    LocalizedString prefix = AcademicExtensionsUtil.bundleI18N(credits.isSubstitution() ? "info.CreditsReasonType.explained.Substitution" : "info.CreditsReasonType.explained.Equivalence", new String[0]);
                    result.append(prefix, " - ");
                    result.append(explanation, ": ");
                }
            }
        }
        return result.build();
    }

    private LocalizedString getExplanation(Dismissal dismissal) {
        LocalizedString.Builder result = new LocalizedString.Builder();
        Credits credits = dismissal.getCredits();
        if (credits.isSubstitution()) {
            credits.getDismissalsSet().stream().sorted(CurriculumLineServices.COMPARATOR).forEach(i -> {
                result.append(i.getName(), ", ");
                this.addECTS(result, (ICurriculumEntry)i);
            });
        } else {
            credits.getIEnrolments().stream().sorted(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID).forEach(i -> {
                if (i instanceof ExternalEnrolment) {
                    this.addExternalEnrolmentInformation(result, (ExternalEnrolment)i, true);
                }
                if (i instanceof OptionalEnrolment) {
                    this.addOptionalEnrolmentInformation(result, (OptionalEnrolment)i);
                } else {
                    result.append(i.getName(), ", ");
                }
                this.addECTS(result, (ICurriculumEntry)i);
            });
        }
        return result.build();
    }

    private void addOptionalEnrolmentInformation(LocalizedString.Builder result, OptionalEnrolment i) {
        result.append(i.getName(), ", ");
        String code = !StringUtils.isEmpty((String)i.getCurricularCourse().getCode()) ? i.getCurricularCourse().getCode() + " - " : "";
        LocalizedString optionalName = i.getCurricularCourse().getNameI18N(i.getExecutionInterval());
        result.append(" (").append(code).append(optionalName).append(") ");
    }

    private void addExternalEnrolmentInformation(LocalizedString.Builder result, ExternalEnrolment external, boolean includeName) {
        List unitFullPath = UnitUtils.getUnitFullPath((Unit)external.getExternalCurricularCourse().getUnit(), (List)Lists.newArrayList((Object[])new AccountabilityTypeEnum[]{AccountabilityTypeEnum.GEOGRAPHIC, AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE, AccountabilityTypeEnum.ACADEMIC_STRUCTURE}));
        Unit countryUnit = null;
        if (this.getInfoExplainedWithCountry()) {
            for (Unit iter : unitFullPath) {
                if (!iter.isCountryUnit()) continue;
                countryUnit = iter;
                break;
            }
            if (countryUnit != null) {
                String countryTwoLetters = countryUnit.getAcronym();
                Country country = Country.readByTwoLetterCode((String)countryTwoLetters);
                if (country != null) {
                    result.append(country.getLocalizedName(), ", ");
                } else {
                    result.append(countryUnit.getNameI18n(), ", ");
                }
            }
        }
        Unit institutionUnit = null;
        if (this.getInfoExplainedWithInstitution() && (institutionUnit = external.getAcademicUnit()) != null) {
            LocalizedString institutionUnitName = new LocalizedString();
            for (Locale locale : CoreConfiguration.supportedLocales()) {
                String value = institutionUnit.getNameI18n().getContent(locale);
                if (StringUtils.isBlank((String)value)) {
                    value = institutionUnit.getNameI18n().getContent(Locale.forLanguageTag(CoreConfiguration.getConfiguration().defaultLocale()));
                }
                institutionUnitName = institutionUnitName.with(locale, value);
            }
            result.append(institutionUnitName, countryUnit != null ? " > " : ", ");
        }
        if (includeName) {
            result.append(external.getName(), countryUnit != null || institutionUnit != null ? " > " : ", ");
        }
    }

    private void addECTS(LocalizedString.Builder result, ICurriculumEntry entry) {
        BigDecimal ects = entry.getEctsCreditsForCurriculum();
        if (this.getInfoExplainedWithEcts() && ects != null && ects.compareTo(BigDecimal.ZERO) > 0) {
            result.append(AcademicExtensionsUtil.bundleI18N("info.CreditsReasonType.explained.ects", "" + ects));
        }
    }
}

