/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.markSheet;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequest$callable$authorize;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequest$callable$close;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequest$callable$closeCascade;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequest$callable$create;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequestStateEnum;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequest_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.person.services.PersonServices;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class CompetenceCourseMarkSheetChangeRequest
extends CompetenceCourseMarkSheetChangeRequest_Base {
    public static Comparator<CompetenceCourseMarkSheetChangeRequest> COMPARATOR_BY_REQUEST_DATE;
    public static final Advice advice$create;
    public static final Advice advice$authorize;
    public static final Advice advice$close;
    public static final Advice advice$closeCascade;

    protected CompetenceCourseMarkSheetChangeRequest() {
        this.setState(CompetenceCourseMarkSheetChangeRequestStateEnum.PENDING);
        this.setRequestDate(new DateTime());
    }

    protected void init(CompetenceCourseMarkSheet markSheet, Person requester, String reason) {
        super.setCompetenceCourseMarkSheet(markSheet);
        super.setRequester(requester);
        super.setReason(reason);
        this.checkRules();
    }

    public boolean isPending() {
        return CompetenceCourseMarkSheetChangeRequestStateEnum.findPending() == this.getState();
    }

    public boolean isAuthorized() {
        return CompetenceCourseMarkSheetChangeRequestStateEnum.findAuthorized() == this.getState();
    }

    public boolean isClosed() {
        return CompetenceCourseMarkSheetChangeRequestStateEnum.findClosed() == this.getState();
    }

    private void checkRules() {
        if (this.getState() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetChangeRequest.state.required", new String[0]);
        }
        if (this.getRequestDate() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetChangeRequest.requestDate.required", new String[0]);
        }
        if (this.getCompetenceCourseMarkSheet() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetChangeRequest.competenceCourseMarkSheet.required", new String[0]);
        }
        if (this.getRequester() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetChangeRequest.requester.required", new String[0]);
        }
        if (StringUtils.isBlank((String)this.getReason())) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetChangeRequest.reason.required", new String[0]);
        }
        if (!this.isPending()) {
            if (this.getResponder() == null) {
                throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetChangeRequest.responder.required", new String[0]);
            }
            if (this.getResponseDate() == null) {
                throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetChangeRequest.responseDate.required", new String[0]);
            }
        }
    }

    public static CompetenceCourseMarkSheetChangeRequest create(CompetenceCourseMarkSheet competenceCourseMarkSheet, Person person, String string) {
        return (CompetenceCourseMarkSheetChangeRequest)((Object)advice$create.perform((Callable)new CompetenceCourseMarkSheetChangeRequest$callable$create(competenceCourseMarkSheet, person, string)));
    }

    static /* synthetic */ CompetenceCourseMarkSheetChangeRequest advised$create(CompetenceCourseMarkSheet markSheet, Person requester, String reason) {
        CompetenceCourseMarkSheetChangeRequest result = new CompetenceCourseMarkSheetChangeRequest();
        result.init(markSheet, requester, reason);
        return result;
    }

    public void authorize(Person person, String string, LocalDate localDate) {
        Object object = advice$authorize.perform((Callable)new CompetenceCourseMarkSheetChangeRequest$callable$authorize(this, person, string, localDate));
    }

    static /* synthetic */ void advised$authorize(CompetenceCourseMarkSheetChangeRequest this_, Person responder, String comments, LocalDate markSheetExpireDate) {
        this_.edit(responder, comments, new DateTime(), CompetenceCourseMarkSheetChangeRequestStateEnum.findAuthorized());
        this_.getCompetenceCourseMarkSheet().editExpireDate(markSheetExpireDate);
        this_.getCompetenceCourseMarkSheet().revertToEdition(false, comments);
        this_.closeCascade();
    }

    public void close(Person person, String string) {
        Object object = advice$close.perform((Callable)new CompetenceCourseMarkSheetChangeRequest$callable$close(this, person, string));
    }

    static /* synthetic */ void advised$close(CompetenceCourseMarkSheetChangeRequest this_, Person responder, String comments) {
        this_.closeSelf(responder, comments);
        this_.closeCascade();
    }

    private void closeSelf(Person responder, String comments) {
        this.edit(responder, comments, new DateTime(), CompetenceCourseMarkSheetChangeRequestStateEnum.findClosed());
    }

    public void closeCascade() {
        Object object = advice$closeCascade.perform((Callable)new CompetenceCourseMarkSheetChangeRequest$callable$closeCascade(this));
    }

    static /* synthetic */ void advised$closeCascade(CompetenceCourseMarkSheetChangeRequest this_) {
        if (!this_.isPending()) {
            String comments = this_.getCommentForCascade();
            this_.getCompetenceCourseMarkSheet().getPendingChangeRequests().forEach(i -> i.closeSelf(this.getResponder(), comments));
        }
    }

    private String getCommentForCascade() {
        String result = "";
        String key = "";
        if (this.isAuthorized()) {
            key = "info.CompetenceCourseMarkSheetChangeRequest.cascade.authorize";
        } else if (this.isClosed()) {
            key = "info.CompetenceCourseMarkSheetChangeRequest.cascade.close";
        }
        if (!key.isEmpty()) {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            result = AcademicExtensionsUtil.bundle(key, this.getRequestDate().toString(formatter), PersonServices.getDisplayName(this.getResponder()), this.getResponseDate().toString(formatter));
        }
        return result;
    }

    protected void edit(Person responder, String comments, DateTime respondeDate, CompetenceCourseMarkSheetChangeRequestStateEnum state) {
        super.setResponder(responder);
        super.setComments(comments);
        super.setResponseDate(respondeDate);
        super.setState(state);
        this.checkRules();
    }

    public void delete() {
        super.setCompetenceCourseMarkSheet(null);
        super.setRequester(null);
        super.setResponder(null);
        super.deleteDomainObject();
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$authorize = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$close = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$closeCascade = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_REQUEST_DATE = Comparator.comparing(CompetenceCourseMarkSheetChangeRequest_Base::getRequestDate).thenComparing(CompetenceCourseMarkSheetChangeRequest_Base::getComments, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(AbstractDomainObject::getExternalId);
    }
}

