/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.function.Supplier;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager;
import org.fenixedu.academic.domain.enrolment.StudentCurricularPlanEnrolmentManager;
import org.fenixedu.academic.domain.enrolment.StudentCurricularPlanImprovementOfApprovedEnrolmentManager;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolment;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanExtraEnrolmentManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanPropaeudeuticsEnrolmentManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanStandaloneEnrolmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrolmentManagerFactoryInitializer {
    private static Logger logger = LoggerFactory.getLogger(EnrolmentManagerFactoryInitializer.class);
    private static Supplier<StudentCurricularPlanEnrolment.EnrolmentManagerFactory> ENROLMENT_MANAGER_FACTORY = () -> new StudentCurricularPlanEnrolment.EnrolmentManagerFactory(){

        public StudentCurricularPlanEnrolment createManager(EnrolmentContext enrolmentContext) {
            if (enrolmentContext.isNormal()) {
                return new StudentCurricularPlanEnrolmentManager(enrolmentContext);
            }
            if (enrolmentContext.isImprovement()) {
                return new StudentCurricularPlanImprovementOfApprovedEnrolmentManager(enrolmentContext);
            }
            if (enrolmentContext.isSpecialSeason()) {
                return new StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager(enrolmentContext);
            }
            if (enrolmentContext.isExtra()) {
                return new StudentCurricularPlanExtraEnrolmentManager(enrolmentContext);
            }
            if (enrolmentContext.isPropaeudeutics()) {
                return new StudentCurricularPlanPropaeudeuticsEnrolmentManager(enrolmentContext);
            }
            if (enrolmentContext.isStandalone()) {
                return new StudentCurricularPlanStandaloneEnrolmentManager(enrolmentContext);
            }
            throw new DomainException("StudentCurricularPlanEnrolment", new String[0]);
        }
    };

    public static void init() {
        StudentCurricularPlanEnrolment.setEnrolmentManagerFactory(ENROLMENT_MANAGER_FACTORY);
        logger.info("Overriding default");
    }
}

