/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.dml;

import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.dml.DynamicField;
import org.fenixedu.academic.domain.dml.DynamicFieldDescriptor_Base;
import org.fenixedu.academic.domain.dml.DynamicFieldValueConverter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.DomainObject;

public class DynamicFieldDescriptor
extends DynamicFieldDescriptor_Base {
    private static final String DOMAIN_OBJECT_FIELD_NAME = "DynamicField";
    private static final String DOMAIN_OBJECT_METHOD_NAME_ADD = "addDynamicField";
    private static final String DOMAIN_OBJECT_METHOD_NAME_GET = "getDynamicFieldSet";

    protected DynamicFieldDescriptor() {
        this.setRoot(Bennu.getInstance());
    }

    protected void init(String domainObjectClass, String code, LocalizedString name, String fieldValueClass, boolean required) {
        this.setDomainObjectClassName(domainObjectClass);
        this.setCode(code);
        this.setName(name);
        this.setFieldValueClassName(fieldValueClass);
        this.setRequired(required);
        this.checkRules();
        this.changeOrder(DynamicFieldDescriptor.find(this.getDomainObjectClassName()).size() - 1);
    }

    private void checkRules() {
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.code.required");
        }
        if (StringUtils.isBlank((String)this.getDomainObjectClassName())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.domainObjectClass.required");
        }
        if (!DynamicFieldDescriptor.isDomainObjectClass(this.getDomainObjectClassName())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.domainObjectClass.is.not.a.domain.object");
        }
        if (Bennu.getInstance().getDynamicFieldDescriptorSet().stream().anyMatch(df -> df != this && Objects.equals(this.getCode(), df.getCode()))) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.duplicate");
        }
        if (this.getName() == null || this.getName().isEmpty()) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.name.required");
        }
        if (Strings.isNullOrEmpty((String)this.getFieldValueClassName())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.fieldValueClassName.required");
        }
        if (!DynamicFieldValueConverter.isSupported(this.getFieldValueClass())) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.fieldValueClass.unsupported");
        }
        if (this.getRequired() && this.getFieldsSet().stream().anyMatch(i -> Strings.isNullOrEmpty((String)i.getValue()))) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.value.inconsistent");
        }
        if (this.getMinLength() != null && this.getMaxLength() == null || this.getMinLength() == null && this.getMaxLength() != null) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.min.and.max.length.must.be.defined.simultaneously");
        }
        if (this.getMinLength() != null && this.getMaxLength() != null && this.getMinLength() > this.getMaxLength()) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.min.length.cannot.be.greather.than.max.length");
        }
        if (this.getMinNumber() != null && this.getMaxNumber() == null || this.getMinNumber() == null && this.getMaxNumber() != null) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.min.and.max.number.must.be.defined.simultaneously");
        }
        if (this.getMinNumber() != null && this.getMaxNumber() != null && this.getMinNumber().intValue() > this.getMaxNumber().intValue()) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.min.number.cannot.be.greather.than.max.length");
        }
    }

    public void edit(String code, LocalizedString name, String fieldValueClassName, boolean required, Integer minLength, Integer maxLength, BigDecimal minNumber, BigDecimal maxNumber, boolean richText, boolean largeSize) {
        super.setCode(code);
        super.setName(name);
        super.setFieldValueClassName(fieldValueClassName);
        super.setRequired(required);
        super.setMinLength(minLength);
        super.setMaxLength(maxLength);
        super.setMinNumber(minNumber);
        super.setMaxNumber(maxNumber);
        super.setRichText(richText);
        super.setLargeSize(largeSize);
        this.checkRules();
    }

    public Class<? extends DomainObject> getDomainClass() {
        return DynamicFieldDescriptor.convertToDomainObjectClass(this.getDomainObjectClassName());
    }

    private boolean isFor(DomainObject domainObject) {
        return domainObject != null && DynamicFieldDescriptor.convertToDomainObjectClass(this.getDomainObjectClassName()) == domainObject.getClass();
    }

    protected DynamicField createField(DomainObject domainObject) {
        DynamicField result = new DynamicField();
        result.setDescriptor(this);
        this.setField(domainObject, result);
        this.findField(domainObject);
        return result;
    }

    protected DynamicField findField(DomainObject domainObject) {
        DynamicField result = null;
        if (this.isFor(domainObject)) {
            try {
                Method method = domainObject.getClass().getMethod(DOMAIN_OBJECT_METHOD_NAME_GET, new Class[0]);
                Set fields = (Set)method.invoke((Object)domainObject, new Object[0]);
                for (DynamicField iter : fields) {
                    if (iter.getDescriptor() != this) continue;
                    if (result != null) {
                        throw new IllegalArgumentException("error.DynamicField.duplicate");
                    }
                    result = iter;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    protected void setField(DomainObject domainObject, DynamicField field) {
        if (this.isFor(domainObject) && this.getFieldsSet().contains((Object)field)) {
            try {
                Method method = domainObject.getClass().getMethod(DOMAIN_OBJECT_METHOD_NAME_ADD, DynamicField.class);
                method.invoke((Object)domainObject, new Object[]{field});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Class getFieldValueClass() {
        try {
            return Class.forName(this.getFieldValueClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void moveUp() {
        int currentIndex = this.getOrder();
        if (currentIndex == 0) {
            return;
        }
        DynamicFieldDescriptor toChange = DynamicFieldDescriptor.findAtPosition(this.getDomainObjectClassName(), currentIndex - 1);
        toChange.changeOrder(currentIndex);
        this.changeOrder(currentIndex - 1);
    }

    public void moveTop() {
        while (this.getOrder() != 0) {
            this.moveUp();
        }
    }

    public void moveDown() {
        int currentIndex = this.getOrder();
        if (currentIndex == DynamicFieldDescriptor.find(this.getDomainObjectClassName()).size() - 1) {
            return;
        }
        DynamicFieldDescriptor toChange = DynamicFieldDescriptor.findAtPosition(this.getDomainObjectClassName(), currentIndex + 1);
        toChange.changeOrder(currentIndex);
        this.changeOrder(currentIndex + 1);
    }

    public void moveBottom() {
        while (this.getOrder() < DynamicFieldDescriptor.find(this.getDomainObjectClassName()).size() - 1) {
            this.moveDown();
        }
    }

    protected void changeOrder(int order) {
        super.setOrder(order);
    }

    public void setOrder(int order) {
        throw new RuntimeException("Order change should be done using move methods");
    }

    public void delete() {
        this.moveBottom();
        if (!this.getFieldsSet().isEmpty()) {
            throw new IllegalArgumentException("error.DynamicFieldDescriptor.cannot.delete.with.field.instances");
        }
        super.setRoot(null);
        super.deleteDomainObject();
    }

    public static DynamicFieldDescriptor create(String domainClass, String code, LocalizedString name, String fieldValueClass, boolean required) {
        DynamicFieldDescriptor result = new DynamicFieldDescriptor();
        result.init(domainClass, code, name, fieldValueClass, required);
        return result;
    }

    private static Class<? extends DomainObject> convertToDomainObjectClass(String className) {
        try {
            if (DynamicFieldDescriptor.isDomainObjectClass(className)) {
                return Class.forName(className);
            }
            throw new IllegalArgumentException("Class " + className + " is not a domain object");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isDomainObjectClass(String className) {
        try {
            Class<?> result = Class.forName(className);
            return DomainObject.class.isAssignableFrom(result);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static DynamicFieldDescriptor findAtPosition(String domainClass, int order) {
        return DynamicFieldDescriptor.find(domainClass).stream().filter(df -> df.getOrder() == order).findFirst().orElse(null);
    }

    public static Collection<DynamicFieldDescriptor> find(String className) {
        if (StringUtils.isBlank((String)className)) {
            return Collections.emptySet();
        }
        Class<? extends DomainObject> domainObjectClass = DynamicFieldDescriptor.convertToDomainObjectClass(className);
        return Bennu.getInstance().getDynamicFieldDescriptorSet().stream().filter(df -> df.getDomainClass() == domainObjectClass).collect(Collectors.toSet());
    }

    public static Set<DynamicFieldDescriptor> find(DomainObject domainObject) {
        HashSet<DynamicFieldDescriptor> result = new HashSet<DynamicFieldDescriptor>();
        if (domainObject != null) {
            for (DynamicFieldDescriptor iter : Bennu.getInstance().getDynamicFieldDescriptorSet()) {
                if (!iter.isFor(domainObject)) continue;
                result.add(iter);
            }
        }
        return result;
    }
}

