/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curriculum.grade;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class QualitativeGradeComparator
implements Comparator<Grade> {
    private List<String> sortedGrades = new ArrayList<String>();

    public QualitativeGradeComparator(List<String> sortedGrades) {
        this.sortedGrades.addAll(sortedGrades);
    }

    @Override
    public int compare(Grade leftGrade, Grade rightGrade) {
        if (rightGrade == null || rightGrade.isEmpty()) {
            return 1;
        }
        if (leftGrade == null || leftGrade.isEmpty()) {
            return -1;
        }
        if (!leftGrade.getGradeScale().equals((Object)rightGrade.getGradeScale())) {
            throw new DomainException("Grade.unsupported.comparassion.of.grades.of.different.scales", new String[0]);
        }
        boolean isLeftApproved = leftGrade.isApproved();
        boolean isRightApproved = rightGrade.isApproved();
        if (isLeftApproved && isRightApproved) {
            return this.getGradeIndex(leftGrade).compareTo(this.getGradeIndex(rightGrade));
        }
        if (isLeftApproved) {
            return 1;
        }
        if (isRightApproved) {
            return -1;
        }
        return this.getGradeIndex(leftGrade).compareTo(this.getGradeIndex(rightGrade));
    }

    private Integer getGradeIndex(Grade value) {
        return this.sortedGrades.indexOf(value.getValue());
    }
}

