/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.prescription;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionBonificationStatute;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionConfig$callable$create;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionConfig$callable$delete;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionConfig$callable$edit;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionConfig_Base;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionEntry;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PrescriptionConfig
extends PrescriptionConfig_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PrescriptionConfig() {
        super.setBennu(Bennu.getInstance());
    }

    protected void init(String name, BigDecimal partialRegimeBonus, boolean reingressionRestartsYearCount, ExecutionYear beginExecutionYear) {
        super.setName(name);
        super.setPartialRegimeBonus(partialRegimeBonus);
        super.setReingressionRestartsYearCount(reingressionRestartsYearCount);
        super.setBeginExecutionYear(beginExecutionYear);
        this.checkRules();
    }

    public void edit(String string, BigDecimal bigDecimal, boolean bl, ExecutionYear executionYear) {
        Object object = advice$edit.perform((Callable)new PrescriptionConfig$callable$edit(this, string, bigDecimal, bl, executionYear));
    }

    static /* synthetic */ void advised$edit(PrescriptionConfig this_, String name, BigDecimal bonus, boolean reingressionRestartsYearCount, ExecutionYear beginExecutionYear) {
        super.setName(name);
        super.setPartialRegimeBonus(bonus);
        super.setReingressionRestartsYearCount(reingressionRestartsYearCount);
        super.setBeginExecutionYear(beginExecutionYear);
        this_.checkRules();
    }

    public void removeDegreeCurricularPlans(DegreeCurricularPlan degreeCurricularPlans) {
        super.removeDegreeCurricularPlans(degreeCurricularPlans);
        this.checkRules();
    }

    public void addDegreeCurricularPlans(DegreeCurricularPlan degreeCurricularPlans) {
        super.addDegreeCurricularPlans(degreeCurricularPlans);
        this.checkRules();
    }

    protected void checkRules() {
        if (this.getName() == null) {
            throw new AcademicExtensionsDomainException("error.PrescriptionConfig.name.cannot.be.null", new String[0]);
        }
        if (this.getPartialRegimeBonus() == null) {
            throw new AcademicExtensionsDomainException("error.PrescriptionConfig.partialRegimeBonus.cannot.be.null", new String[0]);
        }
        if (PrescriptionConfig.findAll().stream().anyMatch(pc -> pc != this && pc.getName().equals(this.getName()))) {
            throw new AcademicExtensionsDomainException("error.PrescriptionConfig.already.exists.other.configuration.with.same.name", new String[0]);
        }
        if (PrescriptionConfig.findAll().stream().anyMatch(pc -> pc != this && this.getDegreeCurricularPlansSet().stream().anyMatch(dcp -> pc.appliesTo((DegreeCurricularPlan)dcp)))) {
            throw new AcademicExtensionsDomainException("error.PrescriptionConfig.degree.curricular.plan.can.only.belong.to.single.configuration", new String[0]);
        }
    }

    public Collection<ExecutionYear> filterExecutionYears(Registration registration, Collection<ExecutionYear> executionYears) {
        ExecutionYear lastReingressionYear = this.getReingressionRestartsYearCount() ? RegistrationServices.getLastReingressionYear(registration) : null;
        ExecutionYear minExecutionYear = this.getBeginExecutionYear();
        return executionYears.stream().filter(ey -> !(minExecutionYear != null && !ey.isAfterOrEquals(minExecutionYear) || lastReingressionYear != null && !ey.isAfterOrEquals(lastReingressionYear))).collect(Collectors.toSet());
    }

    public BigDecimal getBonification(Collection<StatuteType> statuteTypes, boolean partialRegime) {
        return this.getBonificationStatutesSet().stream().filter(b -> statuteTypes.contains(b.getStatuteType())).map(b -> b.getBonus()).max((x, y) -> x.compareTo((BigDecimal)y)).orElse(BigDecimal.ZERO).max(partialRegime ? this.getPartialRegimeBonus() : BigDecimal.ZERO);
    }

    public boolean appliesTo(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getDegreeCurricularPlansSet().contains(degreeCurricularPlan);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PrescriptionConfig$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PrescriptionConfig this_) {
        while (!this_.getBonificationStatutesSet().isEmpty()) {
            ((PrescriptionBonificationStatute)((Object)this_.getBonificationStatutesSet().iterator().next())).delete();
        }
        while (!this_.getPrescriptionEntriesSet().isEmpty()) {
            ((PrescriptionEntry)((Object)this_.getPrescriptionEntriesSet().iterator().next())).delete();
        }
        this_.getDegreeCurricularPlansSet().clear();
        super.setBeginExecutionYear(null);
        super.setBennu(null);
        super.deleteDomainObject();
    }

    public static PrescriptionConfig create(String string, BigDecimal bigDecimal, boolean bl, ExecutionYear executionYear) {
        return (PrescriptionConfig)((Object)advice$create.perform((Callable)new PrescriptionConfig$callable$create(string, bigDecimal, bl, executionYear)));
    }

    static /* synthetic */ PrescriptionConfig advised$create(String name, BigDecimal partialRegimeBonus, boolean reingressionRestartsYearCount, ExecutionYear beginExecutionYear) {
        PrescriptionConfig result = new PrescriptionConfig();
        result.init(name, partialRegimeBonus, reingressionRestartsYearCount, beginExecutionYear);
        return result;
    }

    public static Collection<PrescriptionConfig> findAll() {
        return Bennu.getInstance().getPrescriptionConfigsSet();
    }

    public static PrescriptionConfig findBy(DegreeCurricularPlan degreeCurricularPlan) {
        return PrescriptionConfig.findAll().stream().filter(pc -> pc.appliesTo(degreeCurricularPlan)).findFirst().orElse(null);
    }
}

