/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.EnrolmentPeriodRestrictions;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.AbstractCurricularRuleExecutorLogic;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutorFactory;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrolmentPeriodRestrictionsExecutorLogic
extends AbstractCurricularRuleExecutorLogic {
    private static final Logger logger = LoggerFactory.getLogger(EnrolmentPeriodRestrictionsExecutorLogic.class);

    public static void configure() {
        CurricularRuleExecutorFactory.findExecutor(EnrolmentPeriodRestrictions.class).setLogic((CurricularRuleExecutor.CurricularRuleExecutorLogic)new EnrolmentPeriodRestrictionsExecutorLogic());
    }

    @Override
    protected String getCurricularRuleLabelKey() {
        return "label.enrolmentPeriodRestrictions";
    }

    public RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        DegreeCurricularPlan dcp = enrolmentContext.getStudentCurricularPlan().getDegreeCurricularPlan();
        RuleResult result = this.createFalseConfiguration((DegreeModule)dcp.getRoot());
        Registration registration = enrolmentContext.getRegistration();
        int year = RegistrationServices.getCurricularYear(enrolmentContext.getRegistration(), enrolmentContext.getExecutionPeriod().getExecutionYear()).getResult();
        logger.debug("Verifying restrictions for Registration Nr. [{}] in [{}] curricular year", (Object)registration.getNumber(), (Object)year);
        CurricularPeriodConfiguration configuration = CurricularPeriodServices.getCurricularPeriodConfiguration(dcp, year);
        if (configuration != null) {
            result = configuration.verifyRulesForEnrolment(enrolmentContext);
        }
        return result;
    }
}

