/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourseExceptions;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.AbstractCurricularRuleExecutorLogic;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutorFactory;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyCurricularCourseExceptionsExecutorLogic
extends AbstractCurricularRuleExecutorLogic {
    private static final Logger logger = LoggerFactory.getLogger(AnyCurricularCourseExceptionsExecutorLogic.class);

    public static void configure() {
        CurricularRuleExecutorFactory.findExecutor(AnyCurricularCourseExceptions.class).setLogic((CurricularRuleExecutor.CurricularRuleExecutorLogic)new AnyCurricularCourseExceptionsExecutorLogic());
    }

    @Override
    protected String getCurricularRuleLabelKey() {
        return "label.anyCurricularCourseExceptions";
    }

    public RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RuleResult result = this.createFalseConfiguration(sourceDegreeModuleToEvaluate.getDegreeModule());
        CurricularCourse curricularCourseToEnrol = AnyCurricularCourseExceptionsExecutorLogic.getCurricularCourseFromOptional(sourceDegreeModuleToEvaluate);
        if (curricularCourseToEnrol != null && (result = this.verifyOptionalsConfiguration((AnyCurricularCourseExceptions)curricularRule, sourceDegreeModuleToEvaluate, curricularCourseToEnrol)).isTrue()) {
            result = this.verifyCompetenceCourses((AnyCurricularCourseExceptions)curricularRule, sourceDegreeModuleToEvaluate, curricularCourseToEnrol, enrolmentContext);
        }
        return result;
    }

    private static CurricularCourse getCurricularCourseFromOptional(IDegreeModuleToEvaluate input) {
        CurricularCourse result = null;
        if (input.isEnroling()) {
            OptionalDegreeModuleToEnrol toEnrol = (OptionalDegreeModuleToEnrol)input;
            result = toEnrol.getCurricularCourse();
        } else if (input.isEnroled()) {
            EnroledOptionalEnrolment enroled = (EnroledOptionalEnrolment)input;
            result = (CurricularCourse)enroled.getCurriculumModule().getDegreeModule();
        }
        return result;
    }

    private RuleResult verifyOptionalsConfiguration(AnyCurricularCourseExceptions rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CurricularCourse curricularCourseToEnrol) {
        RuleResult result = RuleResult.createTrue((DegreeModule)curricularCourseToEnrol);
        Boolean optionalsConfiguration = rule.getOptionalsConfiguration();
        if (optionalsConfiguration != null) {
            boolean isOptional = AnyCurricularCourseExceptionsExecutorLogic.hasOneOptionalParentCourseGroup(curricularCourseToEnrol);
            if (optionalsConfiguration.booleanValue() && !isOptional) {
                result = AnyCurricularCourseExceptionsExecutorLogic.createResultFalse(rule, sourceDegreeModuleToEvaluate, curricularCourseToEnrol, "curricularRules.ruleExecutors.AnyCurricularCourseExceptions.only.optional");
            }
            if (!optionalsConfiguration.booleanValue() && isOptional) {
                result = AnyCurricularCourseExceptionsExecutorLogic.createResultFalse(rule, sourceDegreeModuleToEvaluate, curricularCourseToEnrol, "curricularRules.ruleExecutors.AnyCurricularCourseExceptions.only.mandatory");
            }
        }
        return result;
    }

    private static boolean hasOneOptionalParentCourseGroup(CurricularCourse curricularCourseToEnrol) {
        for (Context context : curricularCourseToEnrol.getParentContextsSet()) {
            if (!context.getParentCourseGroup().getIsOptional()) continue;
            return true;
        }
        return false;
    }

    private RuleResult verifyCompetenceCourses(AnyCurricularCourseExceptions rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CurricularCourse curricularCourseToEnrol, EnrolmentContext enrolmentContext) {
        StudentCurricularPlan studentCurricularPlan;
        DegreeCurricularPlan chosenDegreeCurricularPlan;
        RuleResult result = this.createFalseConfiguration(sourceDegreeModuleToEvaluate.getDegreeModule());
        CompetenceCourse competenceCourse = curricularCourseToEnrol.getCompetenceCourse();
        result = AnyCurricularCourseExceptionsExecutorLogic.isException(competenceCourse, chosenDegreeCurricularPlan = curricularCourseToEnrol.getDegreeCurricularPlan(), studentCurricularPlan = enrolmentContext.getStudentCurricularPlan()) ? AnyCurricularCourseExceptionsExecutorLogic.createResultFalse(rule, sourceDegreeModuleToEvaluate, curricularCourseToEnrol, "curricularRules.ruleExecutors.AnyCurricularCourseExceptions.not.offered") : RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        return result;
    }

    public static boolean isException(CompetenceCourse competenceCourse, DegreeCurricularPlan chosenDegreeCurricularPlan, StudentCurricularPlan studentCurricularPlan) {
        boolean result = false;
        if (chosenDegreeCurricularPlan != studentCurricularPlan.getDegreeCurricularPlan()) {
            result = Bennu.getInstance().getAnyCurricularCourseExceptionsConfiguration().getCompetenceCoursesSet().contains(competenceCourse);
        }
        return result;
    }

    private static RuleResult createResultFalse(AnyCurricularCourseExceptions rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CurricularCourse curricularCourseToEnrol, String messageKey) {
        String message = BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)messageKey, (String[])new String[]{curricularCourseToEnrol.getName(), rule.getDegreeModuleToApplyRule().getName()});
        return sourceDegreeModuleToEvaluate.isEnroled() ? RuleResult.createImpossibleWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)message) : RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)message);
    }
}

