/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.StudentStatuteExecutiveRule$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.StudentStatuteExecutiveRule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class StudentStatuteExecutiveRule
extends StudentStatuteExecutiveRule_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected StudentStatuteExecutiveRule() {
    }

    public boolean isExecutive() {
        return true;
    }

    public static StudentStatuteExecutiveRule create(CurricularPeriodConfiguration curricularPeriodConfiguration, StatuteType statuteType) {
        return (StudentStatuteExecutiveRule)((Object)advice$create.perform((Callable)new StudentStatuteExecutiveRule$callable$create(curricularPeriodConfiguration, statuteType)));
    }

    static /* synthetic */ StudentStatuteExecutiveRule advised$create(CurricularPeriodConfiguration configuration, StatuteType statuteType) {
        StudentStatuteExecutiveRule result = new StudentStatuteExecutiveRule();
        result.init(configuration, statuteType);
        return result;
    }

    protected void init(CurricularPeriodConfiguration configuration, StatuteType statuteType) {
        super.init(configuration, BigDecimal.ZERO, (Integer)null, (Integer)null);
        super.setStatuteTypeForRuleTransition(statuteType);
        this.checkRules();
    }

    public StatuteType getStatuteType() {
        return super.getStatuteTypeForRuleTransition();
    }

    private void checkRules() {
        if (this.getStatuteType() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".statuteType.required", new String[0]);
        }
    }

    public String getLabel() {
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[]{this.getStatuteType().getName().getContent()});
    }

    public RuleResult execute(Curriculum curriculum) {
        Registration registration = curriculum.getStudentCurricularPlan().getRegistration();
        ExecutionYear executionYear = curriculum.getExecutionYear() == null ? ExecutionYear.findCurrent((AcademicCalendarRootEntry)registration.getDegree().getCalendar()) : curriculum.getExecutionYear();
        for (StatuteType iter : StatuteServices.findStatuteTypes(registration, (ExecutionInterval)executionYear)) {
            if (this.getStatuteType() != iter) continue;
            return this.createTrue();
        }
        return this.createFalseLabelled(this.getMessagesSuffix("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".suffix", new String[]{executionYear.getQualifiedName()}));
    }
}

