/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.FlunkedCurricularCourses$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.FlunkedCurricularCourses_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FlunkedCurricularCourses
extends FlunkedCurricularCourses_Base {
    private static final Logger logger;
    private Set<CompetenceCourse> competenceCourses;
    public static final Advice advice$create;

    protected FlunkedCurricularCourses() {
    }

    public static FlunkedCurricularCourses create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n, String string) {
        return (FlunkedCurricularCourses)((Object)advice$create.perform((Callable)new FlunkedCurricularCourses$callable$create(curricularPeriodConfiguration, bigDecimal, n, string)));
    }

    static /* synthetic */ FlunkedCurricularCourses advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer year, String codesCSV) {
        FlunkedCurricularCourses result = new FlunkedCurricularCourses();
        result.init(configuration, credits, year, codesCSV);
        return result;
    }

    private void init(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer year, String codesCSV) {
        super.init(configuration, credits, year, year);
        this.setCodesCSV(codesCSV);
        this.checkRules();
    }

    private void checkRules() {
        this.getCompetenceCourses();
    }

    private Set<CompetenceCourse> getCompetenceCourses() {
        if (this.competenceCourses == null) {
            this.loadCompetenceCourses();
        }
        return this.competenceCourses;
    }

    private synchronized void loadCompetenceCourses() {
        if (this.competenceCourses == null) {
            HashSet loadedCompetenceCourses = Sets.newHashSet();
            if (StringUtils.isNotBlank((String)this.getCodesCSV())) {
                for (String code : this.getCodesCSV().split(",")) {
                    CompetenceCourse competenceCourse = CompetenceCourse.find((String)code);
                    if (competenceCourse == null) {
                        logger.warn("[{}], for DCP [{}]: unable to find Competence Course [{}]", new Object[]{this, this.getDegreeCurricularPlan().getPresentationName(), code});
                        continue;
                    }
                    loadedCompetenceCourses.add(competenceCourse);
                }
            }
            this.competenceCourses = loadedCompetenceCourses;
        }
    }

    public String getLabel() {
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[]{this.getCredits().toString(), this.getYearMin().toString(), this.getCodesCSV().toString()});
    }

    public RuleResult execute(Curriculum curriculum) {
        HashSet toInspect = Sets.newHashSet();
        toInspect.addAll(this.getCompetenceCourses());
        block0: for (ICurriculumEntry entry : curriculum.getCurricularYearEntries()) {
            Iterator iterator = toInspect.iterator();
            while (iterator.hasNext()) {
                CompetenceCourse competenceCourse = (CompetenceCourse)iterator.next();
                if (!StringUtils.equals((String)entry.getCode(), (String)competenceCourse.getCode())) continue;
                iterator.remove();
                continue block0;
            }
        }
        BigDecimal total = BigDecimal.ZERO;
        for (CompetenceCourse competenceCourse : toInspect) {
            total = total.add(BigDecimal.valueOf(competenceCourse.getEctsCredits()));
        }
        return total.compareTo(this.getCredits()) <= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(FlunkedCurricularCourses.class);
    }
}

