/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.academicStructure;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.academicStructure.AcademicAreaType_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;

public class AcademicAreaType
extends AcademicAreaType_Base {
    public AcademicAreaType() {
        this.setRoot(Bennu.getInstance());
    }

    public void setName(LocalizedString name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("error.AcademicAreaType.name.cannotBeEmpty");
        }
        super.setName(name);
    }

    public void setCode(String code) {
        if (StringUtils.isNotBlank((String)code) && Bennu.getInstance().getAcademicAreaTypesSet().stream().anyMatch(t -> code.equals(t.getCode()) && t != this)) {
            throw new IllegalArgumentException("error.AcademicAreaType.code.alreadyExists");
        }
        super.setCode(code);
    }

    public static AcademicAreaType findByCode(String code) {
        return StringUtils.isNotBlank((String)code) ? (AcademicAreaType)Bennu.getInstance().getAcademicAreaTypesSet().stream().filter(t -> code.equals(t.getCode())).findAny().orElse(null) : null;
    }

    public void delete() {
        super.setRoot(null);
        this.getAreasSet().forEach(a -> a.delete());
        super.deleteDomainObject();
    }
}

