/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.academicStructure;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.academicStructure.AcademicAreaType;
import org.fenixedu.academic.domain.academicStructure.AcademicArea_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class AcademicArea
extends AcademicArea_Base
implements Comparable<AcademicArea> {
    public AcademicArea() {
        this.setRoot(Bennu.getInstance());
    }

    public AcademicArea(String code, LocalizedString name, AcademicAreaType type) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setType(type);
    }

    public void setName(LocalizedString name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("error.AcademicArea.name.cannotBeEmpty");
        }
        super.setName(name);
    }

    public static AcademicArea findByCodeAndType(String code, AcademicAreaType type) {
        return type != null && StringUtils.isNotBlank((String)code) ? (AcademicArea)type.getAreasSet().stream().filter(a -> code.equals(a.getCode())).findAny().orElse(null) : null;
    }

    public static Set<AcademicArea> findAcademicAreasInUnit(Unit unit, AcademicAreaType type) {
        return unit.getAcademicAreasSet().stream().filter(a -> a.getType() == type).collect(Collectors.toSet());
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getQualificationsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.AcademicArea.delete.qualificationsNotEmpty", (String[])new String[0]));
        }
    }

    public void delete() {
        super.setRoot(null);
        super.setType(null);
        super.deleteDomainObject();
    }

    @Override
    public int compareTo(AcademicArea otherArea) {
        int typeCompare;
        if (this.getType() != null && otherArea.getType() != null && (typeCompare = this.getType().getName().compareTo(otherArea.getType().getName())) != 0) {
            return typeCompare;
        }
        Comparator nullSafeStringComparator = Comparator.nullsLast(String::compareToIgnoreCase);
        Comparator<AcademicArea> comparator = Comparator.comparing(AcademicArea_Base::getCode, nullSafeStringComparator).thenComparing(AcademicArea_Base::getName).thenComparing(AbstractDomainObject::getExternalId);
        return comparator.compare(this, otherArea);
    }
}

