/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.Shift_Base;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.StudentSchoolClassCurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseLoadType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class StudentSchoolClassCurricularRuleExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    @Deprecated
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        CurricularCourse curricularCourse;
        if (sourceDegreeModuleToEvaluate.isEnroled() || !this.canApplyRule(enrolmentContext, curricularRule) || !sourceDegreeModuleToEvaluate.isLeaf() || sourceDegreeModuleToEvaluate.getExecutionInterval() != enrolmentContext.getExecutionPeriod()) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (sourceDegreeModuleToEvaluate instanceof EnroledOptionalEnrolment) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        StudentSchoolClassCurricularRule schoolClassCurricularRule = (StudentSchoolClassCurricularRule)curricularRule;
        Registration registration = enrolmentContext.getRegistration();
        ExecutionInterval executionInterval = sourceDegreeModuleToEvaluate.getExecutionInterval();
        CurricularCourse curricularCourse2 = curricularCourse = sourceDegreeModuleToEvaluate instanceof OptionalDegreeModuleToEnrol ? ((OptionalDegreeModuleToEnrol)sourceDegreeModuleToEvaluate).getCurricularCourse() : (CurricularCourse)sourceDegreeModuleToEvaluate.getDegreeModule();
        if (schoolClassCurricularRule.getSchoolClassMustContainCourse().booleanValue()) {
            int curricularYear = RegistrationServices.getCurricularYear(registration, executionInterval.getExecutionYear()).getResult();
            if (sourceDegreeModuleToEvaluate.getContext().getCurricularYear().equals(curricularYear) && registration.findSchoolClass(executionInterval).stream().flatMap(sc -> sc.getAssociatedShiftsSet().stream()).map(Shift_Base::getExecutionCourse).noneMatch(ec -> ec.getAssociatedCurricularCoursesSet().contains(curricularCourse))) {
                return RuleResult.createFalseWithLiteralMessage((DegreeModule)curricularCourse, (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.schoolClassMustContainCourse", executionInterval.getName(), curricularCourse.getCode(), curricularCourse.getName()));
            }
        }
        Optional registrationSchoolClass = registration.findSchoolClass(executionInterval);
        if (schoolClassCurricularRule.getCourseMustHaveFreeShifts().booleanValue()) {
            if (registrationSchoolClass.isPresent()) {
                Set<Shift> shifts = ((SchoolClass)registrationSchoolClass.get()).getAssociatedShiftsSet().stream().filter(s -> s.getExecutionCourse().getAssociatedCurricularCoursesSet().contains(curricularCourse)).collect(Collectors.toSet());
                if (this.isAllShiftsOfLoadTypeFull(registration, shifts)) {
                    return RuleResult.createFalseWithLiteralMessage((DegreeModule)curricularCourse, (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.courseMustHaveFreeShiftsInSchoolClass", curricularCourse.getCode(), curricularCourse.getName()));
                }
            } else {
                Set<Shift> shifts = curricularCourse.getExecutionCoursesByExecutionPeriod(executionInterval).stream().flatMap(ec -> ec.getShiftsSet().stream()).collect(Collectors.toSet());
                if (this.isAllShiftsOfLoadTypeFull(registration, shifts)) {
                    return RuleResult.createFalseWithLiteralMessage((DegreeModule)curricularCourse, (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.courseMustHaveFreeShifts", curricularCourse.getCode(), curricularCourse.getName()));
                }
            }
        }
        if (StringUtils.isNotBlank((String)schoolClassCurricularRule.getSchoolClassNames()) && (registrationSchoolClass.isEmpty() || schoolClassCurricularRule.getSchoolClassesSplitted().noneMatch(name -> name.equals(((SchoolClass)registrationSchoolClass.get()).getName())))) {
            return RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.registrationNotForSchoolClass", curricularCourse.getCode(), curricularCourse.getName()));
        }
        return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private boolean isAllShiftsOfLoadTypeFull(Registration registration, Set<Shift> shifts) {
        Map<CourseLoadType, List<Shift>> shiftsByCourseLoad = shifts.stream().collect(Collectors.groupingBy(Shift_Base::getCourseLoadType));
        for (CourseLoadType courseLoadType : shiftsByCourseLoad.keySet()) {
            List<Shift> shiftsForType = shiftsByCourseLoad.get(courseLoadType);
            ExecutionCourse executionCourse = shiftsForType.iterator().next().getExecutionCourse();
            if (!registration.findEnrolledShiftFor(executionCourse, courseLoadType).isEmpty() || !shiftsForType.stream().noneMatch(s -> s.isFreeFor(registration))) continue;
            return true;
        }
        return false;
    }
}

