/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academicextensions.services.registrationhistory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolClass_Base;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionConfig;
import org.fenixedu.academic.domain.curricularRules.prescription.PrescriptionEntry;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.BranchType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.ResearchArea;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.student.curriculum.CurriculumConfigurationInitializer;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academicextensions.services.registrationhistory.ConclusionReport;
import org.fenixedu.academicextensions.services.registrationhistory.RegistrationHistoryReportService;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.joda.time.format.DateTimeFormat;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class RegistrationHistoryReport
implements Comparable<RegistrationHistoryReport> {
    private Collection<Enrolment> enrolments;
    private ExecutionYear executionYear;
    private Registration registration;
    private Set<ProgramConclusion> programConclusionsToReport = Sets.newHashSet();
    private Map<ProgramConclusion, RegistrationConclusionBean> conclusionReports = Maps.newHashMap();
    private Integer curricularYear;
    private Integer previousYearCurricularYear;
    private Integer nextYearCurricularYear;
    private Integer enrolmentsCount;
    private RegistrationState lastRegistrationState;
    private BigDecimal enrolmentsCredits;
    private Integer extraCurricularEnrolmentsCount;
    private BigDecimal extraCurricularEnrolmentsCredits;
    private Integer standaloneEnrolmentsCount;
    private BigDecimal standaloneEnrolmentsCredits;
    private Integer affinityEnrolmentsCount;
    private BigDecimal affinityEnrolmentsCredits;
    private BigDecimal executionYearSimpleAverage;
    private BigDecimal executionYearWeightedAverage;
    private Boolean executionYearEnroledMandatoryFlunked;
    private Boolean executionYearEnroledMandatoryInAdvance;
    private BigDecimal executionYearCreditsMandatoryEnroled;
    private BigDecimal executionYearCreditsMandatoryApproved;
    private LocalDate executionYearConclusionDate;
    private BigDecimal currentAverage;

    public RegistrationHistoryReport(Registration registration, ExecutionYear executionYear) {
        this.executionYear = executionYear;
        this.registration = registration;
        if (this.getRegistration().getRegistrationYear().isAfter(executionYear)) {
            throw new AcademicExtensionsDomainException("error.RegistrationHistoryReport.registration.starts.after.executionYear", this.getStudent().getNumber().toString(), this.getDegree().getCode(), executionYear.getQualifiedName());
        }
    }

    @Override
    public int compareTo(RegistrationHistoryReport o) {
        Comparator byYear = (x, y) -> ExecutionYear.COMPARATOR_BY_BEGIN_DATE.compare(x.getExecutionYear(), y.getExecutionYear());
        Comparator byDegreeType = (x, y) -> x.getDegreeType().compareTo(y.getDegreeType());
        Comparator byDegree = (x, y) -> Degree.COMPARATOR_BY_NAME.compare(x.getRegistration().getDegree(), y.getRegistration().getDegree());
        Comparator byDegreeCurricularPlan = (x, y) -> x.getStudentCurricularPlanName().compareTo(y.getStudentCurricularPlanName());
        Comparator byRegistrationNumber = (x, y) -> x.getRegistrationNumber().compareTo(y.getRegistrationNumber());
        return byYear.thenComparing(byDegreeType).thenComparing(byDegree).thenComparing(byDegreeCurricularPlan).thenComparing(byRegistrationNumber).compare(this, o);
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    protected Degree getDegree() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getDegree();
    }

    private Student getStudent() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getStudent();
    }

    private Person getPerson() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getPerson();
    }

    public Collection<Enrolment> getEnrolments() {
        if (this.enrolments == null) {
            this.enrolments = Lists.newArrayList();
            StudentCurricularPlan scp = this.getStudentCurricularPlan();
            if (scp != null) {
                scp.getEnrolmentsByExecutionYear(this.getExecutionYear()).stream().filter(e -> !e.isAnnulled()).collect(Collectors.toCollection(() -> this.enrolments));
            }
        }
        return this.enrolments;
    }

    Collection<Enrolment> getEnrolmentsIncludingAnnuled() {
        StudentCurricularPlan scp = this.getStudentCurricularPlan();
        if (scp != null) {
            return scp.getEnrolmentsByExecutionYear(this.getExecutionYear());
        }
        return Collections.emptySet();
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return RegistrationServices.getStudentCurricularPlan(this.registration, this.getExecutionYear());
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        StudentCurricularPlan scp = this.getStudentCurricularPlan();
        return scp == null ? null : scp.getDegreeCurricularPlan();
    }

    public boolean isReingression() {
        return this.registration.hasReingression(this.getExecutionYear());
    }

    public boolean getHasPreviousReingression() {
        return this.registration.getReingressions().stream().filter(ri -> ri.getExecutionYear().isBefore(this.getExecutionYear())).count() > 0L;
    }

    public boolean getHasPreviousReingressionIncludingPrecedentRegistrations() {
        return Stream.concat(Stream.of(this.registration), RegistrationServices.getPrecedentDegreeRegistrations(this.registration).stream()).flatMap(r -> r.getReingressions().stream()).filter(ri -> ri.getExecutionYear().isBefore(this.getExecutionYear())).count() > 0L;
    }

    public LocalDate getEnrolmentDate() {
        Optional<RegistrationDataByExecutionYear> dataByYear = this.registration.getRegistrationDataByExecutionYearSet().stream().filter(r -> r.getExecutionYear() == this.getExecutionYear()).findFirst();
        return dataByYear.isPresent() ? dataByYear.get().getEnrolmentDate() : null;
    }

    public String getPrimaryBranchName() {
        return this.getStudentCurricularPlan().getBranchCurriculumGroups().stream().filter(b -> b.getDegreeModule().getBranchType() == BranchType.MAJOR).map(b -> b.getName().getContent()).collect(Collectors.joining(","));
    }

    public String getSecondaryBranchName() {
        return this.getStudentCurricularPlan().getBranchCurriculumGroups().stream().filter(b -> b.getDegreeModule().getBranchType() == BranchType.MINOR).map(b -> b.getName().getContent()).collect(Collectors.joining(","));
    }

    public Collection<StudentStatute> getStudentStatutes() {
        HashSet result = Sets.newHashSet();
        result.addAll(this.registration.getStudentStatutesSet().stream().filter(s -> s.isValidOnAnyExecutionPeriodFor(this.getExecutionYear())).collect(Collectors.toSet()));
        result.addAll(this.getStudent().getStudentStatutesSet().stream().filter(s -> s.isValidOnAnyExecutionPeriodFor(this.getExecutionYear())).collect(Collectors.toSet()));
        return result;
    }

    public String getStudentStatutesNames() {
        return this.getStudentStatutes().stream().map(s -> s.getType().getName().getContent()).collect(Collectors.joining(", "));
    }

    public String getStudentStatutesNamesAndDates() {
        return this.getStudentStatutes().stream().map(s -> {
            String name = s.getType().getName().getContent();
            Object dates = "";
            ExecutionInterval beginInterval = s.getBeginExecutionInterval();
            if (beginInterval != null) {
                ExecutionInterval endInterval = s.getEndExecutionInterval();
                if (endInterval == beginInterval) {
                    dates = BundleUtil.getString((String)"resources.EnumerationResources", (String)beginInterval.getAcademicPeriod().getAbbreviatedName(), (String[])new String[0]) + " " + beginInterval.getChildOrder();
                }
            } else {
                LocalDate begin = s.getBeginDate();
                if (begin != null) {
                    dates = begin.toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
                    LocalDate end = s.getEndDate();
                    if (end != null) {
                        dates = (String)dates + "<>" + end.toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
                    }
                }
            }
            return name + (String)(((String)dates).isEmpty() ? "" : " [" + (String)dates + "]");
        }).collect(Collectors.joining(", "));
    }

    public boolean getHasEnrolmentsWithoutShifts() {
        for (ExecutionCourse executionCourse : this.getRegistration().getAttendingExecutionCoursesFor(this.getExecutionYear())) {
            if (executionCourse.getAssociatedShifts().isEmpty() || !this.registration.getShiftsFor(executionCourse).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LocalDate getFirstRegistrationStateDate() {
        Registration registration = this.getRegistration();
        RegistrationState state = registration == null ? null : registration.getFirstRegistrationState();
        return state == null ? null : state.getStateDate().toLocalDate();
    }

    public RegistrationState getLastRegistrationState() {
        if (this.lastRegistrationState == null) {
            this.lastRegistrationState = this.getRegistration().getLastRegistrationState(this.getExecutionYear());
        }
        return this.lastRegistrationState;
    }

    public Set<RegistrationState> getAllLastRegistrationStates() {
        return this.getRegistration().getRegistrationStates(this.executionYear);
    }

    public String getLastRegistrationStateType() {
        RegistrationState state = this.getLastRegistrationState();
        return state == null ? null : state.getType().getName().getContent();
    }

    public String getLastRegistrationStateRemarks() {
        return Optional.ofNullable(this.getLastRegistrationState()).map(r -> r.getRemarks()).orElse(null);
    }

    public LocalDate getLastRegistrationStateDate() {
        RegistrationState state = this.getLastRegistrationState();
        return state == null ? null : state.getStateDate().toLocalDate();
    }

    public boolean getHasAnyInactiveRegistrationStateForYear() {
        return this.getRegistration().getRegistrationStates(this.getExecutionYear()).stream().anyMatch(s -> !s.getType().getActive());
    }

    protected void addConclusion(ProgramConclusion programConclusion, RegistrationConclusionBean bean) {
        this.conclusionReports.put(programConclusion, bean);
    }

    protected void addEmptyConclusion(ProgramConclusion programConclusion) {
        this.conclusionReports.put(programConclusion, null);
    }

    public List<ProgramConclusion> getProgramConclusions() {
        return this.getConclusionReports().keySet().stream().sorted(Comparator.comparing(ProgramConclusion_Base::getName).thenComparing(ProgramConclusion_Base::getDescription).thenComparing(AbstractDomainObject::getExternalId)).collect(Collectors.toList());
    }

    public RegistrationConclusionBean getConclusionReportFor(ProgramConclusion programConclusion) {
        return this.getConclusionReports().get(programConclusion);
    }

    private Map<ProgramConclusion, RegistrationConclusionBean> getConclusionReports() {
        if (this.conclusionReports.isEmpty()) {
            RegistrationHistoryReportService.addConclusion(this);
        }
        return this.conclusionReports;
    }

    protected Set<ProgramConclusion> getProgramConclusionsToReport() {
        return this.programConclusionsToReport;
    }

    protected void setProgramConclusionsToReport(Set<ProgramConclusion> input) {
        this.programConclusionsToReport = input;
    }

    public ConclusionReport getPartialConclusion() {
        return this.getConclusionReports().values().stream().filter(cr -> cr != null && !cr.getProgramConclusion().isTerminal()).findFirst().map(b -> new ConclusionReport((RegistrationConclusionBean)b)).orElse(ConclusionReport.empty());
    }

    public ConclusionReport getFinalConclusion() {
        return this.getConclusionReports().values().stream().filter(cr -> cr != null && cr.getProgramConclusion().isTerminal()).findFirst().map(b -> new ConclusionReport((RegistrationConclusionBean)b)).orElse(ConclusionReport.empty());
    }

    private ICurriculum getCurriculum() {
        return RegistrationServices.getCurriculum(this.getRegistration(), this.getExecutionYear());
    }

    public Integer getCurricularYear() {
        if (this.curricularYear == null) {
            CurriculumConfigurationInitializer.CurricularYearResult result = RegistrationServices.getCurricularYear(this.getRegistration(), this.getExecutionYear());
            this.curricularYear = result == null ? null : Integer.valueOf(result.getResult());
        }
        return this.curricularYear;
    }

    public Integer getPreviousYearCurricularYear() {
        ExecutionYear previous = this.getExecutionYear().getPreviousExecutionYear();
        if (this.registration.getStartExecutionYear().isAfterOrEquals(this.getExecutionYear()) || this.registration.getStudentCurricularPlan(previous) == null || this.registration.getStudentCurricularPlan(this.getExecutionYear()) == null) {
            return null;
        }
        if (this.previousYearCurricularYear == null) {
            CurriculumConfigurationInitializer.CurricularYearResult result = RegistrationServices.getCurricularYear(this.getRegistration(), previous);
            this.previousYearCurricularYear = result == null ? null : Integer.valueOf(result.getResult());
        }
        return this.previousYearCurricularYear;
    }

    public Integer getNextYearCurricularYear() {
        if (this.nextYearCurricularYear == null) {
            ExecutionYear next = this.getExecutionYear().getNextExecutionYear();
            CurriculumConfigurationInitializer.CurricularYearResult result = RegistrationServices.getCurricularYear(this.getRegistration(), next);
            this.nextYearCurricularYear = result == null ? null : Integer.valueOf(result.getResult());
        }
        return this.nextYearCurricularYear;
    }

    public BigDecimal getEctsCredits() {
        return this.getCurriculum().getSumEctsCredits();
    }

    public String getAverage() {
        ICurriculum curriculum = this.getCurriculum();
        Grade rawGrade = curriculum == null ? null : curriculum.getRawGrade();
        return rawGrade == null ? null : rawGrade.getValue();
    }

    public boolean getHasDismissals() {
        return this.getStudentCurricularPlan().getCreditsSet().stream().anyMatch(c -> c.getExecutionPeriod().getExecutionYear() == this.getExecutionYear());
    }

    public Collection<EnrolmentEvaluation> getImprovementEvaluations() {
        return RegistrationServices.getImprovementEvaluations(this.getRegistration(), this.getExecutionYear(), ev -> !ev.isAnnuled());
    }

    public boolean getHasImprovementEvaluations() {
        return RegistrationServices.hasImprovementEvaluations(this.getRegistration(), this.getExecutionYear(), ev -> !ev.isAnnuled());
    }

    public boolean getHasAnnulledEnrolments() {
        return this.getStudentCurricularPlan().getEnrolmentsSet().stream().filter(e -> e.getExecutionYear() == this.getExecutionYear()).anyMatch(e -> e.isAnnulled());
    }

    public int getEnrolmentsCount() {
        if (this.enrolmentsCount == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.enrolmentsCount;
    }

    protected void setEnrolmentsCount(int input) {
        this.enrolmentsCount = input;
    }

    public BigDecimal getEnrolmentsCredits() {
        if (this.enrolmentsCredits == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.enrolmentsCredits;
    }

    protected void setEnrolmentsCredits(BigDecimal input) {
        this.enrolmentsCredits = input;
    }

    public int getExtraCurricularEnrolmentsCount() {
        if (this.extraCurricularEnrolmentsCount == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.extraCurricularEnrolmentsCount;
    }

    protected void setExtraCurricularEnrolmentsCount(int input) {
        this.extraCurricularEnrolmentsCount = input;
    }

    public BigDecimal getExtraCurricularEnrolmentsCredits() {
        if (this.extraCurricularEnrolmentsCredits == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.extraCurricularEnrolmentsCredits;
    }

    protected void setExtraCurricularEnrolmentsCredits(BigDecimal input) {
        this.extraCurricularEnrolmentsCredits = input;
    }

    public int getStandaloneEnrolmentsCount() {
        if (this.standaloneEnrolmentsCount == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.standaloneEnrolmentsCount;
    }

    protected void setStandaloneEnrolmentsCount(int input) {
        this.standaloneEnrolmentsCount = input;
    }

    public BigDecimal getStandaloneEnrolmentsCredits() {
        if (this.standaloneEnrolmentsCredits == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.standaloneEnrolmentsCredits;
    }

    protected void setStandaloneEnrolmentsCredits(BigDecimal input) {
        this.standaloneEnrolmentsCredits = input;
    }

    public int getAffinityEnrolmentsCount() {
        if (this.affinityEnrolmentsCount == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.affinityEnrolmentsCount;
    }

    protected void setAffinityEnrolmentsCount(int input) {
        this.affinityEnrolmentsCount = input;
    }

    public BigDecimal getAffinityEnrolmentsCredits() {
        if (this.affinityEnrolmentsCredits == null) {
            RegistrationHistoryReportService.addEnrolmentsAndCreditsCount(this);
        }
        return this.affinityEnrolmentsCredits;
    }

    protected void setAffinityEnrolmentsCredits(BigDecimal input) {
        this.affinityEnrolmentsCredits = input;
    }

    public BigDecimal getExecutionYearSimpleAverage() {
        if (this.executionYearSimpleAverage == null) {
            this.executionYearSimpleAverage = RegistrationHistoryReportService.calculateExecutionYearSimpleAverage(this);
        }
        return this.executionYearSimpleAverage;
    }

    public BigDecimal getExecutionYearWeightedAverage() {
        if (this.executionYearWeightedAverage == null) {
            this.executionYearWeightedAverage = RegistrationHistoryReportService.calculateExecutionYearWeightedAverage(this);
        }
        return this.executionYearWeightedAverage;
    }

    public Boolean getExecutionYearEnroledMandatoryFlunked() {
        if (this.executionYearEnroledMandatoryFlunked == null) {
            RegistrationHistoryReportService.addExecutionYearMandatoryCoursesData(this);
        }
        return this.executionYearEnroledMandatoryFlunked;
    }

    protected void setExecutionYearEnroledMandatoryFlunked(boolean input) {
        this.executionYearEnroledMandatoryFlunked = input;
    }

    public Boolean getExecutionYearEnroledMandatoryInAdvance() {
        if (this.executionYearEnroledMandatoryInAdvance == null) {
            RegistrationHistoryReportService.addExecutionYearMandatoryCoursesData(this);
        }
        return this.executionYearEnroledMandatoryInAdvance;
    }

    protected void setExecutionYearEnroledMandatoryInAdvance(boolean input) {
        this.executionYearEnroledMandatoryInAdvance = input;
    }

    public BigDecimal getExecutionYearCreditsMandatoryEnroled() {
        if (this.executionYearCreditsMandatoryEnroled == null) {
            RegistrationHistoryReportService.addExecutionYearMandatoryCoursesData(this);
        }
        return this.executionYearCreditsMandatoryEnroled;
    }

    protected void setExecutionYearCreditsMandatoryEnroled(BigDecimal input) {
        this.executionYearCreditsMandatoryEnroled = input;
    }

    public BigDecimal getExecutionYearCreditsMandatoryApproved() {
        if (this.executionYearCreditsMandatoryApproved == null) {
            RegistrationHistoryReportService.addExecutionYearMandatoryCoursesData(this);
        }
        return this.executionYearCreditsMandatoryApproved;
    }

    protected void setExecutionYearCreditsMandatoryApproved(BigDecimal input) {
        this.executionYearCreditsMandatoryApproved = input;
    }

    public LocalDate getExecutionYearConclusionDate() {
        if (this.executionYearConclusionDate == null) {
            Enrolment enrolment = this.getEnrolments().stream().filter(i -> i.isApproved() && i.calculateConclusionDate() != null).max((x, y) -> x.calculateConclusionDate().compareTo((ReadablePartial)y.calculateConclusionDate())).orElse(null);
            YearMonthDay date = enrolment == null ? null : enrolment.calculateConclusionDate();
            this.executionYearConclusionDate = date == null ? null : new LocalDate((Object)date);
        }
        return this.executionYearConclusionDate;
    }

    public BigDecimal getCurrentAverage() {
        if (this.currentAverage == null) {
            this.currentAverage = RegistrationHistoryReportService.calculateAverage(this.getRegistration());
        }
        return this.currentAverage;
    }

    protected RegistrationRegimeType getRegimeType() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getRegimeType(this.getExecutionYear());
    }

    public String getRegimeTypeName() {
        RegistrationRegimeType regimeType = this.getRegimeType();
        return regimeType == null ? null : regimeType.getLocalizedName();
    }

    public boolean isFirstTime() {
        Registration registration = this.getRegistration();
        return registration == null ? false : registration.getRegistrationYear() == this.getExecutionYear();
    }

    public Integer getStudentNumber() {
        Student student = this.getStudent();
        return student == null ? null : student.getNumber();
    }

    public Integer getRegistrationNumber() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getNumber();
    }

    public String getOtherRegistrationNumbers() {
        return this.getRegistration().getStudent().getRegistrationsSet().stream().map(r -> r.getNumber()).filter(n -> n.intValue() != this.getRegistration().getNumber().intValue()).distinct().sorted().map(n -> String.valueOf(n)).collect(Collectors.joining(","));
    }

    public String getDegreeCode() {
        Degree degree = this.getDegree();
        return degree != null ? degree.getCode() : null;
    }

    public String getDegreeMinistryCode() {
        Degree degree = this.getDegree();
        return degree != null ? degree.getMinistryCode() : null;
    }

    protected DegreeType getDegreeType() {
        Degree degree = this.getDegree();
        return degree == null ? null : degree.getDegreeType();
    }

    public String getDegreeTypeName() {
        DegreeType degreeType = this.getDegreeType();
        return degreeType == null ? null : degreeType.getName().getContent();
    }

    public String getDegreePresentationName() {
        Degree degree = this.getDegree();
        return degree == null ? null : degree.getPresentationNameI18N().getContent();
    }

    protected IngressionType getIngressionType() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getIngressionType();
    }

    public String getIngressionTypeDescription() {
        IngressionType type = this.getIngressionType();
        return type == null ? null : type.getDescription().getContent();
    }

    protected RegistrationProtocol getRegistrationProtocol() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getRegistrationProtocol();
    }

    public String getRegistrationProtocolDescription() {
        RegistrationProtocol protocol = this.getRegistrationProtocol();
        return protocol == null ? null : protocol.getDescription().getContent();
    }

    public LocalDate getStartDate() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getStartDate().toLocalDate();
    }

    public String getRegistrationYear() {
        Registration registration = this.getRegistration();
        ExecutionYear year = registration.getRegistrationYear();
        return year == null ? null : year.getQualifiedName();
    }

    public String getStudentCurricularPlanName() {
        StudentCurricularPlan scp = this.getStudentCurricularPlan();
        return scp == null ? null : scp.getName();
    }

    public Integer getStudentCurricularPlanCount() {
        Registration registration = this.getRegistration();
        return registration == null ? null : Integer.valueOf(registration.getStudentCurricularPlansSet().size());
    }

    public String getSchoolClasses() {
        return this.getRegistration().getSchoolClassesSet().stream().filter(sc -> sc.getExecutionPeriod().getExecutionYear() == this.getExecutionYear()).sorted(Comparator.comparing(SchoolClass_Base::getExecutionPeriod)).map(sc -> String.format("%s (S%d)", sc.getName(), sc.getExecutionPeriod().getChildOrder())).collect(Collectors.joining("; "));
    }

    public String getLastEnrolmentExecutionYear() {
        Registration registration = this.getRegistration();
        ExecutionYear year = registration == null ? null : registration.getLastEnrolmentExecutionYear();
        return year == null ? null : year.getQualifiedName();
    }

    public String getRegistrationObservations() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getRegistrationObservationsSet().stream().map(o -> o.getUpdatedBy() + ":" + o.getValue()).collect(Collectors.joining(" \n --------------\n "));
    }

    private PrecedentDegreeInformation getCompletedPrecedentInformation() {
        Registration registration = this.getRegistration();
        StudentCandidacy candidacy = registration == null ? null : registration.getStudentCandidacy();
        return candidacy == null ? null : candidacy.getCompletedDegreeInformation();
    }

    private PrecedentDegreeInformation getPreviousPrecedentInformation() {
        Registration registration = this.getRegistration();
        StudentCandidacy candidacy = registration == null ? null : registration.getStudentCandidacy();
        return candidacy == null ? null : candidacy.getPreviousDegreeInformation();
    }

    public String getQualificationInstitutionName() {
        PrecedentDegreeInformation info = this.getCompletedPrecedentInformation();
        return info == null ? null : info.getInstitutionName();
    }

    public String getQualificationSchoolLevel() {
        PrecedentDegreeInformation info = this.getCompletedPrecedentInformation();
        SchoolLevelType schoolLevel = info.getSchoolLevel();
        return schoolLevel == null ? null : schoolLevel.getLocalizedName();
    }

    public String getQualificationDegreeDesignation() {
        PrecedentDegreeInformation info = this.getCompletedPrecedentInformation();
        return info == null ? null : info.getDegreeDesignation();
    }

    public String getOriginInstitutionName() {
        PrecedentDegreeInformation info = this.getPreviousPrecedentInformation();
        Unit precedentInstitution = info.getInstitution();
        return precedentInstitution == null ? null : precedentInstitution.getName();
    }

    public String getOriginSchoolLevel() {
        PrecedentDegreeInformation info = this.getPreviousPrecedentInformation();
        SchoolLevelType schoolLevel = info.getSchoolLevel();
        return schoolLevel == null ? null : schoolLevel.getLocalizedName();
    }

    public String getOriginDegreeDesignation() {
        PrecedentDegreeInformation info = this.getPreviousPrecedentInformation();
        return info == null ? null : info.getDegreeDesignation();
    }

    public String getUsername() {
        Person person = this.getPerson();
        return person == null ? null : person.getUsername();
    }

    public String getPersonName() {
        Person person = this.getPerson();
        return person == null ? null : person.getName();
    }

    public String getIdDocumentType() {
        Person person = this.getPerson();
        IDDocumentType type = person.getIdDocumentType();
        return type == null ? null : type.getLocalizedName();
    }

    public String getDocumentIdNumber() {
        Person person = this.getPerson();
        return person == null ? null : person.getDocumentIdNumber();
    }

    public String getGender() {
        Person person = this.getPerson();
        Gender gender = person.getGender();
        return gender == null ? null : gender.getLocalizedName();
    }

    @Deprecated(forRemoval=true)
    public YearMonthDay getDateOfBirthYearMonthDay() {
        Person person = this.getPerson();
        return person == null ? null : person.getDateOfBirthYearMonthDay();
    }

    public LocalDate getDateOfBirth() {
        return Optional.ofNullable(this.getPerson()).map(p -> p.getDateOfBirthYearMonthDay()).map(dt -> dt.toLocalDate()).orElse(null);
    }

    public String getNameOfFather() {
        Person person = this.getPerson();
        return person == null ? null : person.getNameOfFather();
    }

    public String getNameOfMother() {
        Person person = this.getPerson();
        return person == null ? null : person.getNameOfMother();
    }

    public String getNationality() {
        Person person = this.getPerson();
        Country country = person.getCountry();
        return country == null ? null : country.getName();
    }

    public String getCountryOfBirth() {
        Person person = this.getPerson();
        Country country = person.getCountryOfBirth();
        return country == null ? null : country.getName();
    }

    public String getFiscalNumber() {
        return PersonCustomer.uiPersonFiscalNumber((Person)this.getPerson());
    }

    public String getDistrictOfBirth() {
        Person person = this.getPerson();
        return person == null ? null : person.getDistrictOfBirth();
    }

    public String getDistrictSubdivisionOfBirth() {
        Person person = this.getPerson();
        return person == null ? null : person.getDistrictSubdivisionOfBirth();
    }

    public String getParishOfBirth() {
        Person person = this.getPerson();
        return person == null ? null : person.getParishOfBirth();
    }

    public String getDefaultEmailAddressValue() {
        Person person = this.getPerson();
        return person == null ? null : person.getDefaultEmailAddressValue();
    }

    public String getInstitutionalEmailAddressValue() {
        Person person = this.getPerson();
        return person == null ? null : person.getInstitutionalEmailAddressValue();
    }

    public String getOtherEmailAddresses() {
        Person person = this.getPerson();
        return person == null ? null : person.getEmailAddresses().stream().map(e -> e.getValue()).collect(Collectors.joining(","));
    }

    public String getDefaultPhoneNumber() {
        Person person = this.getPerson();
        return person == null ? null : person.getDefaultPhoneNumber();
    }

    public String getDefaultMobilePhoneNumber() {
        Person person = this.getPerson();
        return person == null ? null : person.getDefaultMobilePhoneNumber();
    }

    public String getEmergencyContact() {
        Person person = this.getPerson();
        return Optional.ofNullable(person).map(p -> p.getProfile()).map(up -> up.getEmergencyContact()).map(ec -> ec.getContact()).orElse(null);
    }

    public boolean hasDefaultPhysicalAddress() {
        Person person = this.getPerson();
        return person == null ? false : person.hasDefaultPhysicalAddress();
    }

    private PhysicalAddress getDefaultPhysicalAddressObject() {
        Person person = this.getPerson();
        return person == null ? null : person.getDefaultPhysicalAddress();
    }

    public String getDefaultPhysicalAddress() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getAddress();
    }

    public String getDefaultPhysicalAddressDistrictOfResidence() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getDistrictOfResidence();
    }

    public String getDefaultPhysicalAddressDistrictSubdivisionOfResidence() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getDistrictSubdivisionOfResidence();
    }

    public String getDefaultPhysicalAddressParishOfResidence() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getParishOfResidence();
    }

    public String getDefaultPhysicalAddressArea() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getArea();
    }

    public String getDefaultPhysicalAddressAreaCode() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getAreaCode();
    }

    public String getDefaultPhysicalAddressAreaOfAreaCode() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getAreaOfAreaCode();
    }

    public String getDefaultPhysicalAddressCountryOfResidenceName() {
        PhysicalAddress address = this.getDefaultPhysicalAddressObject();
        return address == null ? null : address.getCountryOfResidenceName();
    }

    public boolean isTuitionCharged() {
        ITreasuryBridgeAPI treasuryBridgeAPI = TreasuryBridgeAPIFactory.implementation();
        if (treasuryBridgeAPI == null) {
            return false;
        }
        IAcademicTreasuryEvent event = treasuryBridgeAPI.getTuitionForRegistrationTreasuryEvent(this.registration, this.getExecutionYear());
        return event != null && event.isCharged();
    }

    public BigDecimal getTuitionAmount() {
        ITreasuryBridgeAPI treasuryBridgeAPI = TreasuryBridgeAPIFactory.implementation();
        if (treasuryBridgeAPI == null) {
            return BigDecimal.ZERO;
        }
        IAcademicTreasuryEvent event = treasuryBridgeAPI.getTuitionForRegistrationTreasuryEvent(this.registration, this.getExecutionYear());
        if (event == null) {
            return BigDecimal.ZERO;
        }
        return event.getAmountWithVatToPay();
    }

    public Integer getEnrolmentYears() {
        return this.getEnrolmentExecutionYears().size();
    }

    public Integer getEnrolmentYearsIncludingPrecedentRegistrations() {
        return this.getEnrolmentExecutionYearsIncludingPrecedentRegistrations().size();
    }

    public boolean isPrescriptionConfigured() {
        PrescriptionConfig config = PrescriptionConfig.findBy(this.getDegreeCurricularPlan());
        return config != null && !config.getPrescriptionEntriesSet().isEmpty();
    }

    public BigDecimal getEnrolmentYearsForPrescription() {
        PrescriptionConfig config = PrescriptionConfig.findBy(this.getDegreeCurricularPlan());
        if (config == null) {
            return null;
        }
        Collection<ExecutionYear> executionYears = config.filterExecutionYears(this.registration, this.getEnrolmentExecutionYearsIncludingPrecedentRegistrations());
        BigDecimal result = new BigDecimal(executionYears.size());
        BigDecimal bonification = BigDecimal.ZERO;
        for (ExecutionYear iter : executionYears) {
            bonification = bonification.add(config.getBonification(StatuteServices.findStatuteTypes(this.getRegistration(), (ExecutionInterval)iter), this.getRegistration().isPartialRegime(iter)));
        }
        return BigDecimal.ZERO.max(result.subtract(bonification));
    }

    public Boolean getCanPrescribe() {
        PrescriptionConfig config = PrescriptionConfig.findBy(this.getDegreeCurricularPlan());
        if (config == null) {
            return null;
        }
        BigDecimal studentEcts = RegistrationServices.getCurriculum(this.registration, this.executionYear.getNextExecutionYear()).getSumEctsCredits();
        int enrolmentYearsForPrescription = this.getEnrolmentYearsForPrescription().intValue();
        Comparator comparator = (x, y) -> x.getEnrolmentYears().compareTo(y.getEnrolmentYears());
        PrescriptionEntry biggestEntryValue = config.getPrescriptionEntriesSet().stream().sorted(comparator.reversed()).findFirst().orElse(null);
        if (biggestEntryValue != null && enrolmentYearsForPrescription > biggestEntryValue.getEnrolmentYears().intValue()) {
            return studentEcts.compareTo(biggestEntryValue.getMinEctsApproved()) < 0;
        }
        PrescriptionEntry entry = config.getPrescriptionEntriesSet().stream().filter(e -> enrolmentYearsForPrescription <= e.getEnrolmentYears().intValue()).sorted(comparator).findFirst().orElse(null);
        if (entry == null) {
            throw new AcademicExtensionsDomainException("error.RegistrationHistoryReport.prescriptionConfig.is.missing", new String[0]);
        }
        return studentEcts.compareTo(entry.getMinEctsApproved()) < 0;
    }

    private Set<ExecutionYear> getEnrolmentExecutionYears() {
        return RegistrationServices.getEnrolmentYears(this.registration).stream().filter(ey -> ey.isBeforeOrEquals(this.getExecutionYear())).collect(Collectors.toSet());
    }

    private Set<ExecutionYear> getEnrolmentExecutionYearsIncludingPrecedentRegistrations() {
        return RegistrationServices.getEnrolmentYearsIncludingPrecedentRegistrations(this.registration).stream().filter(ey -> ey.isBeforeOrEquals(this.getExecutionYear())).collect(Collectors.toSet());
    }

    public String getOtherConcludedRegistrationYears() {
        StringBuilder result = new StringBuilder();
        this.getStudent().getRegistrationsSet().stream().filter(r -> r != this.registration && r.isConcluded() && r.getLastStudentCurricularPlan() != null).forEach(r -> {
            TreeSet executionYears = Sets.newTreeSet(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed());
            executionYears.addAll(RegistrationServices.getEnrolmentYears(r));
            if (!executionYears.isEmpty()) {
                result.append(((ExecutionYear)executionYears.first()).getQualifiedName()).append('|');
            }
        });
        return result.toString().endsWith("|") ? result.delete(result.length() - 1, result.length()).toString() : result.toString();
    }

    public ResearchArea getResearchArea() {
        return this.getRegistration().getResearchArea();
    }

    public Degree getAffinityDegree() {
        ExternalCurriculumGroup affinityCycle = this.getAffinityCycleCurriculumGroup();
        return affinityCycle != null ? affinityCycle.getDegreeModule().getDegree() : null;
    }

    public DegreeCurricularPlan getAffinityDegreeCurricularPlan() {
        ExternalCurriculumGroup affinityCycle = this.getAffinityCycleCurriculumGroup();
        return affinityCycle != null ? affinityCycle.getDegreeModule().getParentDegreeCurricularPlan() : null;
    }

    private ExternalCurriculumGroup getAffinityCycleCurriculumGroup() {
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan();
        return studentCurricularPlan.getExternalCurriculumGroups().isEmpty() ? null : (ExternalCurriculumGroup)studentCurricularPlan.getExternalCurriculumGroups().iterator().next();
    }

    public String getIban() {
        return this.getPerson().getIban();
    }

    public String getHealthCardNumber() {
        return this.getPerson().getHealthCardNumber();
    }
}

