/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.gradingTable;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.fenixedu.academic.domain.student.gradingTable.GradingTable;

public class GradingTableGenerator {
    public static void defaultData(GradingTable table) {
        table.addMark("10.0", "E");
        table.addMark("11.0", "E");
        table.addMark("12.0", "D");
        table.addMark("13.0", "D");
        table.addMark("14.0", "C");
        table.addMark("15.0", "C");
        table.addMark("16.0", "B");
        table.addMark("17.0", "B");
        table.addMark("18.0", "A");
        table.addMark("19.0", "A");
        table.addMark("20.0", "A");
    }

    public static void generateTableDataImprovement(GradingTable table, List<BigDecimal> sample) {
        LinkedHashMap<BigDecimal, LongAdder> gradeDistro = new LinkedHashMap<BigDecimal, LongAdder>();
        LinkedHashMap<BigDecimal, BigDecimal> heapedGradeDistro = new LinkedHashMap<BigDecimal, BigDecimal>();
        BigDecimal sampleSize = new BigDecimal(sample.size());
        gradeDistro.put(new BigDecimal("20.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("19.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("18.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("17.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("16.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("15.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("14.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("13.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("12.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("11.0"), new LongAdder());
        gradeDistro.put(new BigDecimal("10.0"), new LongAdder());
        for (BigDecimal bigDecimal : sample) {
            BigDecimal bigDecimal2 = bigDecimal.setScale(1);
            ((LongAdder)gradeDistro.get(bigDecimal2)).increment();
        }
        BigDecimal heap = BigDecimal.ZERO;
        for (Map.Entry entry : gradeDistro.entrySet()) {
            BigDecimal grade = (BigDecimal)entry.getKey();
            BigDecimal count = new BigDecimal(((LongAdder)entry.getValue()).longValue());
            BigDecimal share = count.divide(sampleSize, 5, 6);
            heap = heap.add(share);
            heapedGradeDistro.put(grade, heap.setScale(3, 6));
        }
        heapedGradeDistro.put(new BigDecimal(21).setScale(1), BigDecimal.ZERO);
        GradeDistributionConverter gradeDistributionConverter = new GradeDistributionConverter();
        Map<BigDecimal, String> map = gradeDistributionConverter.process(heapedGradeDistro);
        for (Map.Entry<BigDecimal, String> mark : map.entrySet()) {
            table.addMark(mark.getKey(), mark.getValue());
        }
    }

    private static class GradeDistributionConverter {
        private Map<String, BigDecimal> distro = new LinkedHashMap<String, BigDecimal>();
        private static final String[] ectsGrades = new String[]{"A", "B", "C", "D", "E"};
        private static final BigDecimal[] thresholds = GradeDistributionConverter.createThresholds();
        private static final BigDecimal TWENTY = new BigDecimal(20).setScale(1);

        private static BigDecimal[] createThresholds() {
            BigDecimal[] results = new BigDecimal[]{new BigDecimal("0.10").setScale(3), new BigDecimal("0.35").setScale(3), new BigDecimal("0.65").setScale(3), new BigDecimal("0.90").setScale(3)};
            return results;
        }

        GradeDistributionConverter() {
            this.distro.put("A", new BigDecimal("0.10"));
            this.distro.put("B", new BigDecimal("0.35"));
            this.distro.put("C", new BigDecimal("0.65"));
            this.distro.put("D", new BigDecimal("0.90"));
            this.distro.put("E", new BigDecimal("1.00"));
        }

        Map<BigDecimal, String> process(Map<BigDecimal, BigDecimal> heapedGradeDistro) {
            LinkedHashMap<BigDecimal, String> tableMap = new LinkedHashMap<BigDecimal, String>();
            HashMap<String, Integer> lowerBound = new HashMap<String, Integer>();
            HashMap<String, Integer> upperBound = new HashMap<String, Integer>();
            int gradeIndex = 0;
            upperBound.put("A", 20);
            lowerBound.put("E", 10);
            for (BigDecimal threshold : thresholds) {
                for (Map.Entry<BigDecimal, BigDecimal> tuple : heapedGradeDistro.entrySet()) {
                    BigDecimal rightHandSide;
                    BigDecimal currentGrade = tuple.getKey();
                    BigDecimal currentPercentage = tuple.getValue();
                    if (currentPercentage.compareTo(threshold) < 0) continue;
                    BigDecimal previousPercentage = heapedGradeDistro.get(currentGrade.add(BigDecimal.ONE).setScale(1));
                    BigDecimal leftHandSide = currentPercentage.subtract(threshold).abs();
                    if (leftHandSide.compareTo(rightHandSide = previousPercentage.subtract(threshold).abs()) <= 0) {
                        lowerBound.put(ectsGrades[gradeIndex], currentGrade.intValue());
                        break;
                    }
                    if (this.canLetterBeSkipped(gradeIndex) && currentGrade.equals(TWENTY)) {
                        lowerBound.put(ectsGrades[gradeIndex], 21);
                        upperBound.put(ectsGrades[gradeIndex], 20);
                        break;
                    }
                    lowerBound.put(ectsGrades[gradeIndex], currentGrade.intValue() + 1);
                    break;
                }
                ++gradeIndex;
            }
            for (int i = 1; i < ectsGrades.length; ++i) {
                int previousClassLowerBound = (Integer)lowerBound.get(ectsGrades[i - 1]);
                upperBound.put(ectsGrades[i], previousClassLowerBound - 1);
            }
            for (String grade : ectsGrades) {
                for (int i = ((Integer)lowerBound.get(grade)).intValue(); i <= (Integer)upperBound.get(grade); ++i) {
                    tableMap.put(new BigDecimal(i).setScale(1), grade);
                }
            }
            return tableMap;
        }

        private boolean canLetterBeSkipped(int index) {
            return index < 3;
        }

        Map<BigDecimal, String> oldProcess(Map<BigDecimal, BigDecimal> heapedGradeDistro) {
            LinkedHashMap<BigDecimal, String> tableMap = new LinkedHashMap<BigDecimal, String>();
            int gradeIndex = 0;
            ArrayDeque<BigDecimal> pendingAssignment = new ArrayDeque<BigDecimal>(10);
            BigDecimal threshold = this.distro.get(ectsGrades[gradeIndex]);
            boolean addCurrent = false;
            for (Map.Entry<BigDecimal, BigDecimal> tuple : heapedGradeDistro.entrySet()) {
                BigDecimal currentGrade = tuple.getKey();
                BigDecimal currentPercentage = tuple.getValue();
                if (gradeIndex == 4) {
                    pendingAssignment.add(currentGrade);
                    continue;
                }
                if (currentPercentage.compareTo(threshold) >= 0) {
                    BigDecimal rightHandSide;
                    BigDecimal previousPercentage = heapedGradeDistro.get(currentGrade.add(BigDecimal.ONE).setScale(1));
                    BigDecimal leftHandSide = currentPercentage.subtract(threshold).abs();
                    if (leftHandSide.compareTo(rightHandSide = previousPercentage.subtract(threshold).abs()) <= 0) {
                        pendingAssignment.add(currentGrade);
                    } else {
                        if (gradeIndex < 3 && currentGrade.equals(TWENTY)) {
                            pendingAssignment.add(currentGrade);
                            ++gradeIndex;
                            continue;
                        }
                        addCurrent = true;
                    }
                    while (!pendingAssignment.isEmpty()) {
                        tableMap.put((BigDecimal)pendingAssignment.poll(), ectsGrades[gradeIndex]);
                    }
                    if (addCurrent) {
                        addCurrent = false;
                        pendingAssignment.add(currentGrade);
                    }
                    ++gradeIndex;
                    continue;
                }
                pendingAssignment.add(currentGrade);
            }
            while (!pendingAssignment.isEmpty()) {
                tableMap.put((BigDecimal)pendingAssignment.poll(), ectsGrades[gradeIndex]);
            }
            tableMap.remove(new BigDecimal(21).setScale(1));
            return tableMap;
        }
    }
}

