/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum.creditstransfer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.student.curriculum.creditstransfer.CreditsTransferRemarkEntry;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

class SubstitutionRemarkEntry
extends CreditsTransferRemarkEntry {
    private Unit unit;
    private Collection<Dismissal> dismissals = new LinkedHashSet<Dismissal>();

    public SubstitutionRemarkEntry(CreditsReasonType reasonType, Class<?> creditsType, ICurriculumEntry entry, Dismissal dismissal) {
        super(reasonType, creditsType, entry);
        this.dismissals.add(dismissal);
    }

    public static SubstitutionRemarkEntry build(ICurriculumEntry entry, Dismissal dismissal) {
        SubstitutionRemarkEntry result = new SubstitutionRemarkEntry(dismissal.getCredits().getReason(), dismissal.getCredits().getClass(), entry, dismissal);
        if (entry instanceof ExternalEnrolment) {
            result.unit = ((ExternalEnrolment)entry).getAcademicUnit();
        }
        return result;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Collection<Dismissal> getDismissals() {
        return this.dismissals;
    }

    @Override
    protected String toString(Locale locale) {
        String remarkIdPrefix = this.getFormattedRemarkId() + (StringUtils.isNotBlank((CharSequence)this.getFormattedRemarkId()) ? " " : "");
        if (this.getReasonType() == null) {
            String formattedUnit = this.getFormattedUnit(this.unit, locale, true, true);
            return remarkIdPrefix + AcademicExtensionsUtil.bundleI18N("label.creditsTransfer", new String[0]).getContent(locale) + (String)(StringUtils.isNotBlank((CharSequence)formattedUnit) ? ", " + formattedUnit : "");
        }
        if (this.getReasonType().getInfoHidden()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(remarkIdPrefix);
        result.append(this.getFormattedReason(locale));
        String formattedUnit = this.getFormattedUnit(this.unit, locale, this.getReasonType().getInfoExplainedWithCountry(), this.getReasonType().getInfoExplainedWithInstitution());
        result.append((String)(StringUtils.isNotBlank((CharSequence)formattedUnit) ? ", " + formattedUnit : ""));
        if (this.getReasonType().getInfoExplained()) {
            String prefix = AcademicExtensionsUtil.bundleI18N("info.CreditsReasonType.explained.Substitution", new String[0]).getContent(locale);
            result.append(" - ").append(prefix).append(": ");
            result.append(this.dismissals.stream().sorted(CurriculumLineServices.COMPARATOR).map(d -> {
                String formattedEcts = this.getFormattedEcts((ICurriculumEntry)d, locale);
                return d.getName().getContent(locale) + (String)(StringUtils.isNotBlank((CharSequence)formattedEcts) ? " " + formattedEcts : "");
            }).collect(Collectors.joining(", ")));
        }
        return result.toString();
    }

    @Override
    public boolean matches(CreditsTransferRemarkEntry entry) {
        if (entry instanceof SubstitutionRemarkEntry && this.getReasonType() != null && this.getReasonType().getInfoExplained()) {
            SubstitutionRemarkEntry otherEntry = (SubstitutionRemarkEntry)entry;
            Set sources = this.dismissals.stream().flatMap(d -> d.getCredits().getIEnrolments().stream()).collect(Collectors.toSet());
            Set otherSources = otherEntry.getDismissals().stream().flatMap(d -> d.getCredits().getIEnrolments().stream()).collect(Collectors.toSet());
            return Objects.equals((Object)this.getReasonType(), (Object)otherEntry.getReasonType()) && Objects.equals(this.getUnit(), otherEntry.getUnit()) && sources.equals(otherSources);
        }
        return this.toLocalizedString().compareTo(entry.toLocalizedString()) == 0;
    }

    @Override
    public void merge(CreditsTransferRemarkEntry entry) {
        if (entry instanceof SubstitutionRemarkEntry) {
            SubstitutionRemarkEntry otherEntry = (SubstitutionRemarkEntry)entry;
            this.getDismissals().addAll(otherEntry.getDismissals());
        }
        this.getMergedEntries().add(entry);
    }
}

