/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.markSheet;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange$callable$createConfirmedState;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange$callable$createEditionState;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange$callable$createSubmitedState;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange$callable$delete;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange$callable$edit;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange_Base;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateEnum;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CompetenceCourseMarkSheetStateChange
extends CompetenceCourseMarkSheetStateChange_Base
implements Comparable<CompetenceCourseMarkSheetStateChange> {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createEditionState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createConfirmedState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createSubmitedState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CompetenceCourseMarkSheetStateChange() {
    }

    protected void init(CompetenceCourseMarkSheet markSheet, CompetenceCourseMarkSheetStateEnum state, String reason, boolean byTeacher) {
        this.setCompetenceCourseMarkSheet(markSheet);
        this.setState(state);
        this.setReason(reason);
        this.setByTeacher(byTeacher);
        this.setDate(new DateTime());
        this.setResponsible(Authenticate.getUser().getPerson());
        this.checkRules();
    }

    private void checkRules() {
        if (this.getCompetenceCourseMarkSheet() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetStateChange.competenceCourseMarkSheet.required", new String[0]);
        }
        if (this.getState() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetStateChange.state.required", new String[0]);
        }
        if (this.getDate() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetStateChange.date.required", new String[0]);
        }
        if (this.getResponsible() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetStateChange.responsible.required", new String[0]);
        }
    }

    public void edit(CompetenceCourseMarkSheet competenceCourseMarkSheet, CompetenceCourseMarkSheetStateEnum competenceCourseMarkSheetStateEnum, DateTime dateTime, String string, boolean bl) {
        Object object = advice$edit.perform((Callable)new CompetenceCourseMarkSheetStateChange$callable$edit(this, competenceCourseMarkSheet, competenceCourseMarkSheetStateEnum, dateTime, string, bl));
    }

    static /* synthetic */ void advised$edit(CompetenceCourseMarkSheetStateChange this_, CompetenceCourseMarkSheet competenceCourseMarkSheet, CompetenceCourseMarkSheetStateEnum state, DateTime date, String reason, boolean byTeacher) {
        this_.setCompetenceCourseMarkSheet(competenceCourseMarkSheet);
        this_.setState(state);
        this_.setDate(date);
        this_.setReason(reason);
        this_.setByTeacher(byTeacher);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CompetenceCourseMarkSheetStateChange$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CompetenceCourseMarkSheetStateChange this_) {
        if (this_.getSnapshot() != null) {
            this_.getSnapshot().delete();
        }
        super.setCompetenceCourseMarkSheet(null);
        super.setResponsible(null);
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.deleteDomainObject();
    }

    public static CompetenceCourseMarkSheetStateChange createEditionState(CompetenceCourseMarkSheet competenceCourseMarkSheet, boolean bl, String string) {
        return (CompetenceCourseMarkSheetStateChange)advice$createEditionState.perform((Callable)new CompetenceCourseMarkSheetStateChange$callable$createEditionState(competenceCourseMarkSheet, bl, string));
    }

    static /* synthetic */ CompetenceCourseMarkSheetStateChange advised$createEditionState(CompetenceCourseMarkSheet markSheet, boolean byTeacher, String reason) {
        CompetenceCourseMarkSheetStateChange result = new CompetenceCourseMarkSheetStateChange();
        result.init(markSheet, CompetenceCourseMarkSheetStateEnum.findEdition(), reason, byTeacher);
        if (byTeacher) {
            markSheet.checkIfIsGradeSubmissionAvailable();
        }
        return result;
    }

    public static CompetenceCourseMarkSheetStateChange createConfirmedState(CompetenceCourseMarkSheet competenceCourseMarkSheet, boolean bl, String string) {
        return (CompetenceCourseMarkSheetStateChange)advice$createConfirmedState.perform((Callable)new CompetenceCourseMarkSheetStateChange$callable$createConfirmedState(competenceCourseMarkSheet, bl, string));
    }

    static /* synthetic */ CompetenceCourseMarkSheetStateChange advised$createConfirmedState(CompetenceCourseMarkSheet markSheet, boolean byTeacher, String reason) {
        CompetenceCourseMarkSheetStateChange result = new CompetenceCourseMarkSheetStateChange();
        result.init(markSheet, CompetenceCourseMarkSheetStateEnum.findConfirmed(), reason, byTeacher);
        return result;
    }

    public static CompetenceCourseMarkSheetStateChange createSubmitedState(CompetenceCourseMarkSheet competenceCourseMarkSheet, boolean bl, String string) {
        return (CompetenceCourseMarkSheetStateChange)advice$createSubmitedState.perform((Callable)new CompetenceCourseMarkSheetStateChange$callable$createSubmitedState(competenceCourseMarkSheet, bl, string));
    }

    static /* synthetic */ CompetenceCourseMarkSheetStateChange advised$createSubmitedState(CompetenceCourseMarkSheet markSheet, boolean byTeacher, String reason) {
        CompetenceCourseMarkSheetStateChange result = new CompetenceCourseMarkSheetStateChange();
        result.init(markSheet, CompetenceCourseMarkSheetStateEnum.findSubmited(), reason, byTeacher);
        if (byTeacher) {
            markSheet.checkIfIsGradeSubmissionAvailable();
        }
        return result;
    }

    public static Stream<CompetenceCourseMarkSheetStateChange> findByCompetenceCourseMarkSheet(CompetenceCourseMarkSheet competenceCourseMarkSheet) {
        return competenceCourseMarkSheet.getStateChangeSet().stream().filter(i -> competenceCourseMarkSheet.equals((Object)i.getCompetenceCourseMarkSheet()));
    }

    @Override
    public int compareTo(CompetenceCourseMarkSheetStateChange o) {
        int c = this.getDate().compareTo((ReadableInstant)o.getDate());
        return c != 0 ? c : this.getExternalId().compareTo(o.getExternalId());
    }

    public boolean isEdition() {
        return this.getState().isEdition();
    }

    public boolean isSubmitted() {
        return this.getState().isSubmitted();
    }

    public boolean isConfirmed() {
        return this.getState().isConfirmed();
    }
}

