/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Shift;

public abstract class EvaluationServices {
    private static Function<Evaluation, Boolean> COURSE_EVALUATION_IGNORED_IN_MARK_SHEET = null;
    private static BiFunction<ExecutionCourse, EvaluationSeason, Set<Evaluation>> EXECUTION_COURSE_EVALUATION_FINDER = null;
    private static Function<Evaluation, Set<Shift>> COURSE_EVALUATION_SHIFT_FINDER = null;
    private static IEnrolmentCourseEvaluationFinder ENROLMENT_COURSE_EVALUATION_FINDER = null;

    public static void setCourseEvaluationIgnoredInMarkSheet(Function<Evaluation, Boolean> input) {
        COURSE_EVALUATION_IGNORED_IN_MARK_SHEET = input;
    }

    public static Boolean isCourseEvaluationIgnoredInMarkSheet(Evaluation input) {
        return COURSE_EVALUATION_IGNORED_IN_MARK_SHEET == null ? Boolean.FALSE : COURSE_EVALUATION_IGNORED_IN_MARK_SHEET.apply(input);
    }

    public static void setExecutionCourseEvaluationsFinder(BiFunction<ExecutionCourse, EvaluationSeason, Set<Evaluation>> input) {
        EXECUTION_COURSE_EVALUATION_FINDER = input;
    }

    public static Set<Evaluation> findExecutionCourseEvaluations(ExecutionCourse execution, EvaluationSeason season) {
        return EXECUTION_COURSE_EVALUATION_FINDER == null ? Sets.newHashSet() : EXECUTION_COURSE_EVALUATION_FINDER.apply(execution, season);
    }

    public static void setCourseEvaluationShiftFinder(Function<Evaluation, Set<Shift>> input) {
        COURSE_EVALUATION_SHIFT_FINDER = input;
    }

    public static Set<Shift> findCourseEvaluationShifts(Evaluation input) {
        return COURSE_EVALUATION_SHIFT_FINDER == null ? Sets.newHashSet() : COURSE_EVALUATION_SHIFT_FINDER.apply(input);
    }

    public static void setEnrolmentCourseEvaluationFinder(IEnrolmentCourseEvaluationFinder finder) {
        ENROLMENT_COURSE_EVALUATION_FINDER = finder;
    }

    public static Set<Evaluation> findEnrolmentCourseEvaluations(Enrolment enrolment, EvaluationSeason season, ExecutionInterval interval) {
        return ENROLMENT_COURSE_EVALUATION_FINDER == null ? Sets.newHashSet() : ENROLMENT_COURSE_EVALUATION_FINDER.apply(enrolment, season, interval);
    }

    public static boolean isEnroledInAnyCourseEvaluation(Enrolment enrolment, EvaluationSeason season, ExecutionInterval interval) {
        return !EvaluationServices.findEnrolmentCourseEvaluations(enrolment, season, interval).isEmpty();
    }

    public static boolean isEnroledInCourseEvaluation(Enrolment enrolment, EvaluationSeason season, ExecutionInterval interval, Evaluation evaluation) {
        return EvaluationServices.findEnrolmentCourseEvaluations(enrolment, season, interval).contains(evaluation);
    }

    public static interface IEnrolmentCourseEvaluationFinder {
        public Set<Evaluation> apply(Enrolment var1, EvaluationSeason var2, ExecutionInterval var3);
    }
}

