/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleTransition;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.RuleTransitionOr$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.RuleTransitionOr_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RuleTransitionOr
extends RuleTransitionOr_Base {
    private static final Logger logger;
    public static final Advice advice$create;

    protected RuleTransitionOr() {
    }

    protected void init(CurricularPeriodConfiguration configuration, List<RuleTransition> children) {
        super.init(configuration, BigDecimal.valueOf(children.size()), null, null);
        children.forEach(x -> this.addChildRule((RuleTransition)((Object)x)));
        this.checkRules();
    }

    private void checkRules() {
        if (this.getChildrenSet().isEmpty()) {
            throw new DomainException("error.RuleTransitionOr.at.least.one.child.is.required", new String[0]);
        }
    }

    public static RuleTransitionOr create(CurricularPeriodConfiguration curricularPeriodConfiguration, List<RuleTransition> list) {
        return (RuleTransitionOr)((Object)advice$create.perform((Callable)new RuleTransitionOr$callable$create(curricularPeriodConfiguration, list)));
    }

    static /* synthetic */ RuleTransitionOr advised$create(CurricularPeriodConfiguration configuration, List<RuleTransition> children) {
        RuleTransitionOr result = new RuleTransitionOr();
        result.init(configuration, children);
        return result;
    }

    public RuleResult execute(Curriculum curriculum) {
        ArrayList falseResults = Lists.newArrayList();
        for (RuleTransition child : this.getChildrenSet()) {
            RuleResult childResult = child.execute(curriculum);
            if (childResult.isTrue()) {
                return childResult;
            }
            falseResults.add(childResult);
        }
        RuleResult result = RuleResult.createInitialFalse();
        Registration registration = curriculum.getStudentCurricularPlan().getRegistration();
        for (RuleResult iter : falseResults) {
            result = result.and(iter);
            logger.debug("[RULE !true] [REG][{}][{}]", (Object)registration.getNumber(), (Object)CurricularPeriodRule.getMessages(iter));
        }
        return result;
    }

    public String getLabel() {
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[0]);
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(CurricularPeriodConfiguration.class);
    }
}

