/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleTransition$callable$delete;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleTransition_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class RuleTransition
extends RuleTransition_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected RuleTransition() {
    }

    protected void init(CurricularPeriodConfiguration configuration, BigDecimal value, Integer yearMin, Integer yearMax) {
        super.init(value);
        this.setConfigurationTransition(configuration);
        this.setYearMin(yearMin);
        this.setYearMax(yearMax);
        this.checkRules();
    }

    public BigDecimal getCredits() {
        return super.getValue();
    }

    private void checkRules() {
        if (this.getConfigurationTransition() == null && this.getParentRuleTransition() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".configuration.or.parent.rule.is.required", new String[0]);
        }
    }

    protected boolean isForYear() {
        return this.getYearMin() != null && this.getYearMax() != null && this.getYearMin().intValue() == this.getYearMax().intValue();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getConfigurationTransition() != null) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".cannot.be.deleted"), (String[])new String[0]));
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new RuleTransition$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(RuleTransition this_) {
        super.setConfigurationTransition(null);
        super.setParentRuleTransition(null);
        super.setStatuteTypeForRuleTransition(null);
        while (!this_.getChildrenSet().isEmpty()) {
            ((RuleTransition)((Object)this_.getChildrenSet().iterator().next())).delete();
        }
        super.delete();
    }

    protected CurricularPeriodConfiguration getConfiguration() {
        return this.getParentRuleTransition() != null ? this.getParentRuleTransition().getConfiguration() : this.getConfigurationTransition();
    }

    protected DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getConfiguration().getDegreeCurricularPlan();
    }

    public void addChildRule(RuleTransition ruleTransition) {
        this.getChildrenSet().add(ruleTransition);
        ruleTransition.setConfigurationTransition(null);
        ruleTransition.checkRules();
    }

    public abstract RuleResult execute(Curriculum var1);

    protected Curriculum prepareCurriculum(Curriculum input) {
        Curriculum result = input;
        Registration registration = input.getStudentCurricularPlan().getRegistration();
        if (this.getAllowToCollectAllCurricularPlans() && RegistrationServices.canCollectAllPlansForCurriculum(registration)) {
            result = RegistrationServices.getAllPlansCurriculum(registration, input.getExecutionYear());
        }
        if (this.getSemester() != null) {
            result = RegistrationServices.filterCurricularYearEntriesBySemester(result, this.getSemester());
        }
        return result;
    }

    public void copyConfigurationTo(CurricularPeriodRule target) {
        super.copyConfigurationTo(target);
        RuleTransition ruleTransition = (RuleTransition)((Object)target);
        ruleTransition.setAllowToCollectAllCurricularPlans(this.getAllowToCollectAllCurricularPlans());
        ruleTransition.setCodesCSV(this.getCodesCSV());
        ruleTransition.setStatuteTypeForRuleTransition(this.getStatuteTypeForRuleTransition());
        for (RuleTransition child : this.getChildrenSet()) {
            ruleTransition.addChildRule((RuleTransition)((Object)child.cloneRule()));
        }
    }
}

