/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.curricularRules.StudentSchoolClassCurricularRule;
import org.fenixedu.academic.domain.degreeStructure.CourseLoadType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;

public class StudentScheduleListeners {
    public static Consumer<DomainObjectEvent<Enrolment>> SHIFTS_ENROLLER = new Consumer<DomainObjectEvent<Enrolment>>(){

        @Override
        public void accept(DomainObjectEvent<Enrolment> event) {
            boolean enrolInShiftIfUnique;
            ExecutionInterval executionInterval;
            Enrolment enrolment = (Enrolment)event.getInstance();
            Attends attends = enrolment.getAttendsFor(executionInterval = enrolment.getExecutionInterval());
            if (attends == null) {
                return;
            }
            boolean bl = enrolInShiftIfUnique = !enrolment.getCurriculumGroup().isNoCourseGroupCurriculumGroup() && enrolment.getCurricularRules(executionInterval).stream().filter(cr -> cr instanceof StudentSchoolClassCurricularRule).map(cr -> (StudentSchoolClassCurricularRule)((Object)cr)).anyMatch(ssccr -> ssccr.getEnrolInShiftIfUnique());
            if (enrolInShiftIfUnique) {
                Registration registration = enrolment.getRegistration();
                ExecutionCourse executionCourse = attends.getExecutionCourse();
                SchoolClass schoolClass = registration.findSchoolClass(executionInterval).orElse(null);
                for (CourseLoadType courseLoadType : executionCourse.getCourseLoadTypes()) {
                    Collection shiftsOfType;
                    if (!registration.findEnrolledShiftFor(executionCourse, courseLoadType).isEmpty() || (shiftsOfType = (Collection)executionCourse.findShiftsByLoadType(courseLoadType).filter(shift -> schoolClass == null || shift.getAssociatedClassesSet().contains(schoolClass)).collect(Collectors.toSet())).size() != 1) continue;
                    Shift shift2 = (Shift)shiftsOfType.iterator().next();
                    shift2.enrol(registration);
                }
            }
        }
    };
}

