/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.curricularRules.BlockEnrolmentByPreviousEnrolmentConditions_Base;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.BlockEnrolmentByPreviousEnrolmentConditionsExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.BlockEnrolmentByPreviousEnrolmentConditionsVerifier;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class BlockEnrolmentByPreviousEnrolmentConditions
extends BlockEnrolmentByPreviousEnrolmentConditions_Base {
    protected BlockEnrolmentByPreviousEnrolmentConditions() {
    }

    public BlockEnrolmentByPreviousEnrolmentConditions(DegreeModule degreeModule, CourseGroup courseGroup, ExecutionInterval begin, ExecutionInterval end, EnrollmentState previousEnrolmentState) {
        this();
        super.init(degreeModule, courseGroup, begin, end, CurricularRuleType.CUSTOM);
        super.setPreviousEnrolmentState(previousEnrolmentState);
        this.checkRules();
    }

    public void edit(CourseGroup courseGroup, ExecutionInterval begin, ExecutionInterval end, EnrollmentState previousEnrolmentState) {
        super.edit(begin, end);
        super.setContextCourseGroup(courseGroup);
        super.setPreviousEnrolmentState(previousEnrolmentState);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getPreviousEnrolmentState() == null) {
            throw new DomainException("error.BlockEnrolmentByPreviousEnrolmentConditions.previousEnrolmentState.cannot.be.null", new String[0]);
        }
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        return Collections.singletonList(new GenericPair((Object)AcademicExtensionsUtil.bundle("label.BlockEnrolmentByPreviousEnrolmentConditions", this.getPreviousEnrolmentState().getDescription()), (Object)false));
    }

    public boolean isVisible() {
        return false;
    }

    protected void removeOwnParameters() {
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return new BlockEnrolmentByPreviousEnrolmentConditionsVerifier();
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return new BlockEnrolmentByPreviousEnrolmentConditionsExecutor().execute((ICurricularRule)this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    public Collection<CurricularCourse> expandCurricularCourses(CurricularCourse curricularCourse) {
        return curricularCourse.getCompetenceCourse() != null ? curricularCourse.getCompetenceCourse().getAssociatedCurricularCoursesSet() : Collections.singleton(curricularCourse);
    }

    public boolean hasPreviousEnrolmentMatchingConditions(Registration registration, Collection<CurricularCourse> curricularCourses, ExecutionInterval maxInterval) {
        return registration.getStudentCurricularPlansSet().stream().flatMap(scp -> scp.getEnrolmentsSet().stream()).filter(e -> e.getExecutionInterval().isBefore(maxInterval) && curricularCourses.stream().anyMatch(cc -> e.hasDegreeModule((DegreeModule)cc))).anyMatch(e -> e.getEnrollmentState() == this.getPreviousEnrolmentState());
    }
}

